/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal;

import com.couchbase.lite.BlobKey;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.support.Base64;
import com.couchbase.lite.util.Log;
import com.couchbase.lite.util.Utils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class AttachmentInternal {
    private String name;
    private String contentType;
    private Database database;
    private int length;
    private int encodedLength;
    private AttachmentEncoding encoding = AttachmentEncoding.AttachmentEncodingNone;
    private int revpos;
    private BlobKey blobKey;
    private String digest;
    private byte[] data;

    public AttachmentInternal(String name, String contentType) {
        this.name = name;
        this.contentType = contentType;
    }

    public AttachmentInternal(String name, Map<String, Object> attachInfo) throws CouchbaseLiteException {
        this(name, (String)attachInfo.get("content_type"));
        Object newContentBase64;
        String encodingStr;
        Number explicitLength = (Number)attachInfo.get("length");
        if (explicitLength != null) {
            this.length = explicitLength.intValue();
        }
        if ((explicitLength = (Number)attachInfo.get("encoded_length")) != null) {
            this.encodedLength = explicitLength.intValue();
        }
        this.digest = (String)attachInfo.get("digest");
        if (this.digest != null) {
            try {
                this.blobKey = new BlobKey(this.digest);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((encodingStr = (String)attachInfo.get("encoding")) != null && encodingStr.length() > 0) {
            if (encodingStr.equalsIgnoreCase("gzip")) {
                this.encoding = AttachmentEncoding.AttachmentEncodingGZIP;
            } else {
                throw new CouchbaseLiteException(490);
            }
        }
        if ((newContentBase64 = attachInfo.get("data")) != null) {
            if (newContentBase64 instanceof String) {
                try {
                    this.data = Base64.decode((String)newContentBase64, 4);
                }
                catch (IOException e) {
                    throw new CouchbaseLiteException(490);
                }
            } else {
                this.data = (byte[])newContentBase64;
            }
            if (this.data == null) {
                throw new CouchbaseLiteException(490);
            }
            this.setPossiblyEncodedLength(this.data.length);
        } else if (attachInfo.containsKey("stub") && ((Boolean)attachInfo.get("stub")).booleanValue()) {
            if (attachInfo.containsKey("revpos")) {
                int revPos = ((Number)attachInfo.get("revpos")).intValue();
                if (revPos <= 0) {
                    throw new CouchbaseLiteException(491);
                }
                this.setRevpos(revPos);
            }
        } else if (attachInfo.containsKey("follows") && ((Boolean)attachInfo.get("follows")).booleanValue()) {
            if (this.digest == null) {
                throw new CouchbaseLiteException(491);
            }
        } else {
            throw new CouchbaseLiteException(491);
        }
    }

    public boolean hasBlobKey() {
        return this.blobKey != null && this.blobKey.hasBlobKey();
    }

    public String getDigest() {
        if (this.digest != null) {
            return this.digest;
        }
        if (this.hasBlobKey()) {
            return this.blobKey.base64Digest();
        }
        return null;
    }

    public boolean isValid() {
        if (this.encoding != AttachmentEncoding.AttachmentEncodingNone ? this.encodedLength == 0 && this.length > 0 : this.encodedLength > 0) {
            return false;
        }
        return this.revpos != 0;
    }

    public Map<String, Object> asStubDictionary() {
        HashMap<String, Object> dict = new HashMap<String, Object>();
        dict.put("stub", true);
        dict.put("digest", this.blobKey.base64Digest());
        if (this.contentType != null) {
            dict.put("content_type", this.contentType);
        }
        dict.put("revpos", this.revpos);
        dict.put("length", this.length);
        if (this.encodedLength > 0) {
            dict.put("encoded_length", this.encodedLength);
        }
        switch (this.encoding) {
            case AttachmentEncodingGZIP: {
                dict.put("encoding", "gzip");
                break;
            }
        }
        return dict;
    }

    public byte[] getEncodedContent() {
        if (this.data != null) {
            return this.data;
        }
        return this.database != null ? this.database.getAttachmentStore().blobForKey(this.blobKey) : null;
    }

    public byte[] getContent() {
        byte[] data = this.getEncodedContent();
        switch (this.encoding) {
            case AttachmentEncodingGZIP: {
                if (data == null) break;
                data = Utils.decompressByGzip(data);
                break;
            }
            case AttachmentEncodingNone: {
                if (data == null || this.blobKey == null || this.database == null || !this.database.getAttachmentStore().isGZipped(this.blobKey)) break;
                data = Utils.decompressByGzip(data);
                this.encoding = AttachmentEncoding.AttachmentEncodingGZIP;
            }
        }
        if (data == null) {
            Log.w("Database", "Unable to decode attachment!");
        }
        return data;
    }

    public InputStream getContentInputStream() {
        return new ByteArrayInputStream(this.getContent());
    }

    public InputStream getEncodedContentInputStream() {
        return new ByteArrayInputStream(this.getEncodedContent());
    }

    public URL getContentURL() throws MalformedURLException {
        String path = this.database.getAttachmentStore().getBlobPathForKey(this.blobKey);
        return path != null ? new File(path).toURI().toURL() : null;
    }

    public String getName() {
        return this.name;
    }

    public String getContentType() {
        return this.contentType;
    }

    public AttachmentEncoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(AttachmentEncoding encoding) {
        this.encoding = encoding;
    }

    public BlobKey getBlobKey() {
        return this.blobKey;
    }

    public void setBlobKey(BlobKey blobKey) {
        this.blobKey = blobKey;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public long getEncodedLength() {
        return this.encodedLength;
    }

    public void setEncodedLength(int encodedLength) {
        this.encodedLength = encodedLength;
    }

    public int getRevpos() {
        return this.revpos;
    }

    public void setRevpos(int revpos) {
        this.revpos = revpos;
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public void setPossiblyEncodedLength(int len) {
        if (this.encoding != AttachmentEncoding.AttachmentEncodingNone) {
            this.encodedLength = len;
        } else {
            this.length = len;
        }
    }

    public static enum AttachmentEncoding {
        AttachmentEncodingNone,
        AttachmentEncodingGZIP;

    }
}

