/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.auth;

import com.couchbase.lite.auth.BaseAuthorizer;
import com.couchbase.lite.auth.CredentialAuthorizer;
import com.couchbase.lite.auth.CustomHeadersAuthorizer;
import okhttp3.Credentials;
import okhttp3.Request;

public class PasswordAuthorizer
extends BaseAuthorizer
implements CustomHeadersAuthorizer,
CredentialAuthorizer {
    public static final String TAG = "Sync";
    private String username;
    private String password;

    public PasswordAuthorizer(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public boolean authorizeURLRequest(Request.Builder builder) {
        if (this.authUserInfo() == null) {
            return false;
        }
        String credential = Credentials.basic((String)this.username, (String)this.password);
        builder.addHeader("Authorization", credential);
        return true;
    }

    @Override
    public String authUserInfo() {
        if (this.username != null && this.password != null) {
            return this.username + ':' + this.password;
        }
        return null;
    }

    @Override
    public boolean removeStoredCredentials() {
        this.username = null;
        this.password = null;
        return true;
    }

    @Override
    public String getUsername() {
        return this.username;
    }
}

