/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.auth;

import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.auth.BaseAuthorizer;
import com.couchbase.lite.auth.CustomHeadersAuthorizer;
import com.couchbase.lite.auth.LoginAuthorizer;
import com.couchbase.lite.auth.OIDCLoginCallback;
import com.couchbase.lite.auth.OIDCLoginContinuation;
import com.couchbase.lite.auth.SessionCookieAuthorizer;
import com.couchbase.lite.auth.TokenStore;
import com.couchbase.lite.replicator.RemoteRequestResponseException;
import com.couchbase.lite.util.Log;
import com.couchbase.lite.util.URIUtils;
import com.couchbase.lite.util.URLUtils;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.Request;

public class OpenIDConnectAuthorizer
extends BaseAuthorizer
implements CustomHeadersAuthorizer,
SessionCookieAuthorizer {
    private static final String TAG = "Sync";
    private String username;
    protected OIDCLoginCallback loginCallback;
    protected TokenStore tokenStore;
    protected URL authURL;
    protected String IDToken;
    protected String refreshToken;
    protected boolean haveSessionCookie;

    public OpenIDConnectAuthorizer(OIDCLoginCallback callback, TokenStore tokenStore) {
        this.loginCallback = callback;
        this.tokenStore = tokenStore;
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "OpenIDConnectAuthorizer[%s]", this.getRemoteURL());
    }

    @Override
    public boolean authorizeURLRequest(Request.Builder builder) {
        this.loadTokens();
        if (this.IDToken != null && !this.haveSessionCookie) {
            String auth = String.format(Locale.ENGLISH, "Bearer ", this.IDToken);
            builder.addHeader("Authorization", auth);
            return true;
        }
        return false;
    }

    @Override
    public List<Object> loginRequest() {
        this.loadTokens();
        this.IDToken = null;
        this.haveSessionCookie = false;
        String path = this.refreshToken != null ? String.format(Locale.ENGLISH, "_oidc_refresh?refresh_token=%s", URIUtils.encode(this.refreshToken)) : (this.authURL != null ? String.format(Locale.ENGLISH, "_oidc_callback?%s", this.authURL.getQuery()) : "_oidc_challenge?offline=true");
        return Arrays.asList("GET", path);
    }

    @Override
    public void loginResponse(Object jsonResponse, Headers headers, Throwable error, LoginAuthorizer.ContinuationBlock block) {
        if (!(error == null || error instanceof RemoteRequestResponseException && ((RemoteRequestResponseException)error).getCode() == 401)) {
            block.call(false, error);
            return;
        }
        if (this.refreshToken != null || this.authURL != null) {
            if (error != null) {
                this.authURL = null;
                if (this.refreshToken != null) {
                    this.refreshToken = null;
                    this.username = null;
                    this.deleteTokens();
                    block.call(true, null);
                }
            } else {
                HashMap<String, String> response = (HashMap<String, String>)jsonResponse;
                if (this.refreshToken != null && response.get("refresh_token") == null) {
                    response = new HashMap<String, String>(response);
                    response.put("refresh_token", this.refreshToken);
                }
                if (this.parseTokens((Map<String, String>)response)) {
                    Log.v(TAG, "%s: Logged in as %s !", this.getClass().getName(), this.username);
                    this.saveTokens(response);
                } else {
                    error = new CouchbaseLiteException("Server didn't return a refreshed ID token", 589);
                }
            }
        } else {
            Map challenge;
            String login = null;
            RemoteRequestResponseException rrre = (RemoteRequestResponseException)error;
            Map map = challenge = rrre.getUserInfo() != null ? (Map)rrre.getUserInfo().get("AuthChallenge") : null;
            if (challenge != null && "OIDC".equals(challenge.get("Scheme"))) {
                login = (String)challenge.get("login");
            }
            if (login != null) {
                Log.v(TAG, "OpenIDConnectAuthorizer: Got OpenID Connect login URL: <%s>", login);
                URL loginURL = null;
                try {
                    loginURL = new URL(login);
                    this.continueAsyncLoginWithURL(loginURL, block);
                    return;
                }
                catch (MalformedURLException e) {
                    Log.e(TAG, "Unknown Error", e);
                    error = new CouchbaseLiteException(-1);
                }
            } else {
                error = new CouchbaseLiteException("Server didn't provide an OpenID login URL", 589);
            }
        }
        block.call(false, error);
    }

    @Override
    public boolean implementedLoginResponse() {
        return true;
    }

    @Override
    public boolean removeStoredCredentials() {
        if (!this.deleteTokens()) {
            return false;
        }
        this.IDToken = null;
        this.refreshToken = null;
        this.haveSessionCookie = false;
        this.authURL = null;
        return true;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public TokenStore getTokenStore() {
        return this.tokenStore;
    }

    public void setTokenStore(TokenStore tokenStore) {
        this.tokenStore = tokenStore;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getIDToken() {
        return this.IDToken;
    }

    public void setIDToken(String IDToken) {
        this.IDToken = IDToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public static boolean forgetIDTokensForServer(URL serverURL, TokenStore tokenStore) {
        OpenIDConnectAuthorizer authorizer = new OpenIDConnectAuthorizer(null, tokenStore);
        authorizer.setRemoteURL(serverURL);
        return authorizer.deleteTokens();
    }

    boolean loadTokens() {
        if (this.tokenStore == null) {
            return false;
        }
        try {
            return this.parseTokens(this.tokenStore.loadTokens(this.getRemoteURL(), this.getLocalUUID()));
        }
        catch (Exception e) {
            Log.w(TAG, "Error in loadTokens()", e);
            return false;
        }
    }

    boolean saveTokens(Map<String, String> tokens) {
        if (this.tokenStore == null) {
            return false;
        }
        return this.tokenStore.saveTokens(this.getRemoteURL(), this.getLocalUUID(), tokens);
    }

    boolean deleteTokens() {
        if (this.tokenStore == null) {
            return false;
        }
        return this.tokenStore.deleteTokens(this.getRemoteURL(), this.getLocalUUID());
    }

    private boolean parseTokens(Map<String, String> tokens) {
        if (tokens == null) {
            return false;
        }
        String idToken = tokens.get("id_token");
        if (idToken == null) {
            Log.v(TAG, "OpenIDConnectAuthorizer: the parsed token doesn't have the ID Token");
            return false;
        }
        this.IDToken = idToken;
        this.refreshToken = tokens.get("refresh_token");
        this.username = tokens.get("name");
        this.haveSessionCookie = tokens.containsKey("session_id");
        return true;
    }

    private void continueAsyncLoginWithURL(URL loginURL, final LoginAuthorizer.ContinuationBlock block) {
        Log.v(TAG, "OpenIDConnectAuthorizer: Calling app login callback block...");
        final URL remoteURL = this.getRemoteURL();
        URL redirectBaseURL = OpenIDConnectAuthorizer.extractRedirectURL(loginURL);
        if (this.loginCallback != null) {
            this.loginCallback.callback(loginURL, redirectBaseURL, new OIDCLoginContinuation(){

                @Override
                public void callback(URL url, Throwable error) {
                    if (url != null) {
                        Log.v(OpenIDConnectAuthorizer.TAG, "OpenIDConnectAuthorizer: App login callback returned authURL <%s>", url.toExternalForm());
                        if (remoteURL == null || url.getHost().compareToIgnoreCase(remoteURL.getHost()) != 0 || url.getPort() != remoteURL.getPort()) {
                            Log.w(OpenIDConnectAuthorizer.TAG, "OpenIDConnectAuthorizer: App-provided authURL <%s> doesn't match server URL; ignoring it", url.toExternalForm());
                            url = null;
                            error = new RemoteRequestResponseException(RemoteRequestResponseException.BAD_URL, null, null);
                        }
                    }
                    if (url != null) {
                        OpenIDConnectAuthorizer.this.authURL = url;
                        block.call(true, null);
                    } else {
                        if (error == null) {
                            error = new RemoteRequestResponseException(RemoteRequestResponseException.USER_DENIED_AUTH, null, null);
                        }
                        Log.w(OpenIDConnectAuthorizer.TAG, "OpenIDConnectAuthorizer: App login callback returned error=" + error);
                        block.call(false, error);
                    }
                }
            });
        }
    }

    private static URL extractRedirectURL(URL loginURL) {
        try {
            Map<String, List<String>> queries = URLUtils.splitQuery(loginURL);
            if (queries.containsKey("redirect_uri") && queries.get("redirect_uri").size() > 0) {
                try {
                    return new URL(queries.get("redirect_uri").get(0));
                }
                catch (MalformedURLException e) {
                    Log.w(TAG, "Invalid URL: redirect_uri=<%s>", e, queries.get("redirect_uri").get(0));
                    return null;
                }
            }
            return null;
        }
        catch (UnsupportedEncodingException e) {
            Log.w(TAG, "Invalid URL: loginURL=<%s>", e, loginURL);
            return null;
        }
    }
}

