/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.auth;

import com.couchbase.lite.auth.TokenStore;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class MemTokenStore
implements TokenStore {
    private Map<String, Map<String, String>> store = new HashMap<String, Map<String, String>>();

    @Override
    public Map<String, String> loadTokens(URL remoteURL, String localUUID) throws Exception {
        if (remoteURL == null) {
            return null;
        }
        String key = this.getKey(remoteURL, localUUID);
        if (!this.store.containsKey(key)) {
            return null;
        }
        return this.store.get(key);
    }

    @Override
    public boolean saveTokens(URL remoteURL, String localUUID, Map<String, String> tokens) {
        if (tokens == null) {
            return this.deleteTokens(remoteURL, localUUID);
        }
        if (remoteURL == null) {
            return false;
        }
        String key = this.getKey(remoteURL, localUUID);
        this.store.put(key, tokens);
        return true;
    }

    @Override
    public boolean deleteTokens(URL remoteURL, String localUUID) {
        if (remoteURL == null) {
            return false;
        }
        String key = this.getKey(remoteURL, localUUID);
        if (!this.store.containsKey(key)) {
            return false;
        }
        this.store.remove(key);
        return true;
    }

    String getKey(URL remoteURL, String localUUID) {
        if (remoteURL == null) {
            throw new IllegalArgumentException("remoteURL is null");
        }
        String service = remoteURL.toExternalForm();
        String label = String.format(Locale.ENGLISH, "%s OpenID Connect tokens", remoteURL.getHost());
        if (localUUID == null) {
            return String.format(Locale.ENGLISH, "%s%s", label, service);
        }
        return String.format(Locale.ENGLISH, "%s%s%s", label, service, localUUID);
    }
}

