/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.auth;

import com.couchbase.lite.auth.BaseAuthorizer;
import com.couchbase.lite.auth.LoginAuthorizer;
import com.couchbase.lite.auth.SessionCookieAuthorizer;
import com.couchbase.lite.util.Log;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Headers;

public class FacebookAuthorizer
extends BaseAuthorizer
implements SessionCookieAuthorizer {
    private static final String TAG = "Sync";
    private static final String kLoginParamAccessToken = "access_token";
    private static Map<List<String>, String> sRegisteredTokens = Collections.synchronizedMap(new HashMap());
    private String email;

    public FacebookAuthorizer(String email) {
        if (email == null) {
            throw new IllegalArgumentException("email is null");
        }
        this.email = email;
    }

    @Override
    public List<Object> loginRequest() {
        String token = this.token();
        if (token == null) {
            return null;
        }
        HashMap<String, String> loginParams = new HashMap<String, String>();
        loginParams.put(kLoginParamAccessToken, token);
        return Arrays.asList("POST", "_facebook", loginParams);
    }

    @Override
    public void loginResponse(Object jsonResponse, Headers headers, Throwable error, LoginAuthorizer.ContinuationBlock block) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean implementedLoginResponse() {
        return false;
    }

    public static boolean registerToken(String token, String email, URL site) {
        ArrayList<String> key = new ArrayList<String>();
        key.add(email);
        key.add(site.toExternalForm().toLowerCase());
        sRegisteredTokens.put(key, token);
        return true;
    }

    private String token() {
        ArrayList<String> key = new ArrayList<String>();
        key.add(this.email);
        key.add(this.getRemoteURL().toExternalForm().toLowerCase());
        Log.v(TAG, "FacebookAuthorizer looking up key: %s from list of access tokens", key);
        return sRegisteredTokens.get(key);
    }
}

