/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.auth;

import com.couchbase.lite.auth.Authenticator;
import com.couchbase.lite.auth.OIDCLoginCallback;
import com.couchbase.lite.auth.OpenIDConnectAuthorizer;
import com.couchbase.lite.auth.PasswordAuthorizer;
import com.couchbase.lite.auth.TokenAuthenticator;
import com.couchbase.lite.auth.TokenStore;
import java.util.HashMap;

public class AuthenticatorFactory {
    public static Authenticator createBasicAuthenticator(String username, String password) {
        return new PasswordAuthorizer(username, password);
    }

    public static Authenticator createFacebookAuthenticator(String token) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("access_token", token);
        return new TokenAuthenticator("_facebook", params);
    }

    public static Authenticator createPersonaAuthenticator(String assertion) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("assertion", assertion);
        return new TokenAuthenticator("_persona", params);
    }

    public static Authenticator createOpenIDConnectAuthenticator(OIDCLoginCallback callback, TokenStore tokenStore) {
        return new OpenIDConnectAuthorizer(callback, tokenStore);
    }
}

