/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.Mapper;
import com.couchbase.lite.Query;
import com.couchbase.lite.QueryOptions;
import com.couchbase.lite.QueryRow;
import com.couchbase.lite.Reducer;
import com.couchbase.lite.Status;
import com.couchbase.lite.ViewCompiler;
import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.store.ViewStore;
import com.couchbase.lite.store.ViewStoreDelegate;
import com.couchbase.lite.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class View
implements ViewStoreDelegate {
    private Database database;
    private String name;
    private Mapper mapBlock;
    private Reducer reduceBlock;
    private String version;
    private static ViewCompiler compiler;
    private ViewStore viewStore;

    @InterfaceAudience.Private
    protected View(Database database, String name, boolean create) throws CouchbaseLiteException {
        this.database = database;
        this.name = name;
        this.viewStore = database.getViewStorage(name, create);
        if (this.viewStore == null) {
            throw new CouchbaseLiteException(404);
        }
        this.viewStore.setDelegate(this);
    }

    @Override
    @InterfaceAudience.Public
    public Mapper getMap() {
        return this.mapBlock;
    }

    @Override
    @InterfaceAudience.Public
    public Reducer getReduce() {
        return this.reduceBlock;
    }

    @Override
    public String getMapVersion() {
        return this.version;
    }

    @Override
    public String getDocumentType() {
        return this.database.getViewDocumentType(this.name);
    }

    public void setDocumentType(String docType) {
        this.database.setViewDocumentType(docType, this.name);
    }

    @InterfaceAudience.Private
    protected Database getDatabase() {
        return this.database;
    }

    @InterfaceAudience.Public
    public String getName() {
        return this.name;
    }

    @InterfaceAudience.Public
    public boolean setMapReduce(Mapper mapBlock, Reducer reduceBlock, String version) {
        assert (mapBlock != null);
        assert (version != null);
        boolean changed = this.version == null || !this.version.equals(version);
        this.mapBlock = mapBlock;
        this.reduceBlock = reduceBlock;
        this.version = version;
        this.viewStore.setVersion(version);
        return changed;
    }

    @InterfaceAudience.Public
    public boolean setMap(Mapper mapBlock, String version) {
        return this.setMapReduce(mapBlock, null, version);
    }

    @InterfaceAudience.Public
    public boolean isStale() {
        return this.viewStore.getLastSequenceIndexed() < this.database.getLastSequenceNumber();
    }

    @InterfaceAudience.Public
    public int getTotalRows() {
        try {
            this.updateIndex();
        }
        catch (CouchbaseLiteException e) {
            Log.e("View", "Update index failed when getting the total rows", e);
        }
        return this.getCurrentTotalRows();
    }

    @InterfaceAudience.Public
    public long getLastSequenceIndexed() {
        return this.viewStore.getLastSequenceIndexed();
    }

    @InterfaceAudience.Public
    public void deleteIndex() {
        this.viewStore.deleteIndex();
    }

    @InterfaceAudience.Public
    public void delete() {
        if (this.viewStore != null) {
            this.viewStore.deleteView();
        }
        if (this.database != null && this.name != null) {
            this.database.forgetView(this.name);
        }
        this.close();
    }

    @InterfaceAudience.Public
    public Query createQuery() {
        return new Query(this.database, this);
    }

    @InterfaceAudience.Public
    public static double totalValues(List<Object> values) {
        double total = 0.0;
        for (Object object : values) {
            if (object instanceof Number) {
                Number number = (Number)object;
                total += number.doubleValue();
                continue;
            }
            Log.w("View", "Warning non-numeric value found in totalValues: %s", object);
        }
        return total;
    }

    @InterfaceAudience.Public
    public static ViewCompiler getCompiler() {
        return compiler;
    }

    @InterfaceAudience.Public
    public static void setCompiler(ViewCompiler compiler) {
        View.compiler = compiler;
    }

    @InterfaceAudience.Private
    public int getCurrentTotalRows() {
        return this.viewStore.getTotalRows();
    }

    public void close() {
        if (this.viewStore != null) {
            this.viewStore.close();
        }
        this.viewStore = null;
        this.database = null;
    }

    @InterfaceAudience.Private
    public void setCollation(TDViewCollation collation) {
        this.viewStore.setCollation(collation);
    }

    @InterfaceAudience.Private
    public Status updateIndex() throws CouchbaseLiteException {
        return this.updateIndexes(this.getViewsInGroup());
    }

    @InterfaceAudience.Private
    public Status updateIndexAlone() throws CouchbaseLiteException {
        return this.updateIndexes(Arrays.asList(this));
    }

    @InterfaceAudience.Private
    protected Status updateIndexes(List<View> views) throws CouchbaseLiteException {
        ArrayList<ViewStore> storages = new ArrayList<ViewStore>();
        for (View view : views) {
            storages.add(view.viewStore);
        }
        return this.viewStore.updateIndexes(storages);
    }

    @InterfaceAudience.Private
    protected List<View> getViewsInGroup() {
        ArrayList<View> views = new ArrayList<View>();
        int slash = this.name.indexOf(47);
        if (slash > 0) {
            String prefix = this.name.substring(0, slash + 1);
            for (View view : this.database.getAllViews()) {
                if (!view.name.startsWith(prefix)) continue;
                views.add(view);
            }
        } else {
            views.add(this);
        }
        return views;
    }

    @InterfaceAudience.Private
    public List<QueryRow> query(QueryOptions options) throws CouchbaseLiteException {
        if (options == null) {
            options = new QueryOptions();
        }
        if (this.groupOrReduce(options)) {
            return this.viewStore.reducedQuery(options);
        }
        return this.viewStore.regularQuery(options);
    }

    @InterfaceAudience.Private
    public static Object keyForPrefixMatch(Object key, int depth) {
        if (depth < 1) {
            return key;
        }
        if (key instanceof String) {
            return (String)key + '\uffff';
        }
        if (key instanceof List) {
            ArrayList<Object> nuKey = new ArrayList<Object>((List)key);
            if (depth == 1) {
                nuKey.add(new HashMap());
            } else {
                Object lastObject = View.keyForPrefixMatch(nuKey.get(nuKey.size() - 1), depth - 1);
                nuKey.set(nuKey.size() - 1, lastObject);
            }
            return nuKey;
        }
        return key;
    }

    private boolean groupOrReduce(QueryOptions options) {
        if (options.isGroup() || options.getGroupLevel() > 0) {
            return true;
        }
        if (options.isReduceSpecified()) {
            return options.isReduce();
        }
        return this.reduceBlock != null;
    }

    @InterfaceAudience.Private
    protected List<Map<String, Object>> dump() {
        return this.viewStore.dump();
    }

    public String toString() {
        return "View{name='" + this.name + '\'' + ", version='" + this.version + '\'' + '}';
    }

    public static enum TDViewCollation {
        TDViewCollationUnicode,
        TDViewCollationRaw,
        TDViewCollationASCII;

    }
}

