/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.Attachment;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Document;
import com.couchbase.lite.Revision;
import com.couchbase.lite.SavedRevision;
import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class UnsavedRevision
extends Revision {
    private final long parentSequence;
    private Map<String, Object> properties;

    @InterfaceAudience.Private
    protected UnsavedRevision(Document document, SavedRevision parentRevision) {
        super(document);
        if (parentRevision == null) {
            this.parentRevID = null;
            this.parentSequence = 0L;
        } else {
            this.parentRevID = parentRevision.getId();
            this.parentSequence = parentRevision.getSequence();
        }
        Map<String, Object> parentRevisionProperties = parentRevision == null ? null : parentRevision.getProperties();
        if (parentRevisionProperties == null) {
            this.properties = new HashMap<String, Object>();
            this.properties.put("_id", document.getId());
            if (this.parentRevID != null) {
                this.properties.put("_rev", this.parentRevID);
            }
        } else {
            this.properties = new HashMap<String, Object>(parentRevisionProperties);
        }
    }

    @InterfaceAudience.Public
    public void setIsDeletion(boolean isDeletion) {
        if (isDeletion) {
            this.properties.put("_deleted", true);
        } else {
            this.properties.remove("_deleted");
        }
    }

    @Override
    @InterfaceAudience.Public
    public String getId() {
        return null;
    }

    @Override
    @InterfaceAudience.Private
    protected long getSequence() {
        return 0L;
    }

    @InterfaceAudience.Public
    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @InterfaceAudience.Public
    public SavedRevision save() throws CouchbaseLiteException {
        boolean allowConflict = false;
        return this.document.putProperties(this.properties, this.parentRevID, allowConflict);
    }

    @InterfaceAudience.Public
    public SavedRevision save(boolean allowConflict) throws CouchbaseLiteException {
        return this.document.putProperties(this.properties, this.parentRevID, allowConflict);
    }

    @InterfaceAudience.Public
    public void removeAttachment(String name) {
        this.addAttachment(null, name);
    }

    @InterfaceAudience.Public
    public void setUserProperties(Map<String, Object> userProperties) {
        HashMap<String, Object> newProps = new HashMap<String, Object>();
        newProps.putAll(userProperties);
        for (String key : this.properties.keySet()) {
            if (!key.startsWith("_")) continue;
            newProps.put(key, this.properties.get(key));
        }
        this.properties = newProps;
    }

    @InterfaceAudience.Public
    public void setAttachment(String name, String contentType, InputStream contentStream) {
        Attachment attachment = new Attachment(contentStream, contentType);
        this.addAttachment(attachment, name);
    }

    @InterfaceAudience.Public
    public void setAttachment(String name, String contentType, URL contentStreamURL) {
        try {
            InputStream inputStream = contentStreamURL.openStream();
            this.setAttachment(name, contentType, inputStream);
        }
        catch (IOException e) {
            Log.e("Database", "Error opening stream for url: %s", contentStreamURL);
            throw new RuntimeException(e);
        }
    }

    @Override
    @InterfaceAudience.Public
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    @InterfaceAudience.Public
    public SavedRevision getParent() {
        if (this.parentRevID == null || this.parentRevID.length() == 0) {
            return null;
        }
        return this.document.getRevision(this.parentRevID);
    }

    @Override
    @InterfaceAudience.Public
    public String getParentId() {
        return this.parentRevID;
    }

    @Override
    @InterfaceAudience.Private
    protected long getParentSequence() {
        return this.parentSequence;
    }

    @Override
    @InterfaceAudience.Public
    public List<SavedRevision> getRevisionHistory() throws CouchbaseLiteException {
        SavedRevision parent = this.getParent();
        return parent != null ? parent.getRevisionHistory() : new ArrayList<SavedRevision>();
    }

    @InterfaceAudience.Private
    protected void addAttachment(Attachment attachment, String name) {
        HashMap<String, Attachment> attachments = (HashMap<String, Attachment>)this.properties.get("_attachments");
        if (attachments == null) {
            attachments = new HashMap<String, Attachment>();
        }
        attachments.put(name, attachment);
        this.properties.put("_attachments", attachments);
        if (attachment != null) {
            attachment.setName(name);
        }
    }
}

