/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import java.util.HashMap;
import java.util.Map;

public class Status {
    public static final int UNKNOWN = -1;
    public static final int OK = 200;
    public static final int CREATED = 201;
    public static final int ACCEPTED = 202;
    public static final int NOT_MODIFIED = 304;
    public static final int BAD_REQUEST = 400;
    public static final int UNAUTHORIZED = 401;
    public static final int FORBIDDEN = 403;
    public static final int NOT_FOUND = 404;
    public static final int METHOD_NOT_ALLOWED = 405;
    public static final int NOT_ACCEPTABLE = 406;
    public static final int REQUEST_TIMEOUT = 408;
    public static final int CONFLICT = 409;
    public static final int GONE = 410;
    public static final int DUPLICATE = 412;
    public static final int UNSUPPORTED_TYPE = 415;
    public static final int INTERNAL_SERVER_ERROR = 500;
    public static final int NOT_IMPLEMENTED = 501;
    public static final int BAD_ENCODING = 490;
    public static final int BAD_ATTACHMENT = 491;
    public static final int ATTACHMENT_NOT_FOUND = 492;
    public static final int BAD_JSON = 493;
    public static final int BAD_ID = 494;
    public static final int BAD_PARAM = 495;
    public static final int DELETED = 496;
    public static final int INVALID_STORAGE_TYPE = 497;
    public static final int BAD_CHANGES_FEED = 587;
    public static final int CHANGES_FEED_TRUNCATED = 588;
    public static final int UPSTREAM_ERROR = 589;
    public static final int DB_ERROR = 590;
    public static final int CORRUPT_ERROR = 591;
    public static final int ATTACHMENT_ERROR = 592;
    public static final int CALLBACK_ERROR = 593;
    public static final int EXCEPTION = 594;
    public static final int DB_BUSY = 595;
    private static final Map<Integer, HTTPStatus> statusMap = new HashMap<Integer, HTTPStatus>();
    private int code;

    public Status() {
        this.code = -1;
    }

    public Status(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public boolean isSuccessful() {
        return this.code > 0 && this.code < 400;
    }

    public boolean isError() {
        return !this.isSuccessful();
    }

    public String toString() {
        return "Status: " + this.code + " (" + this.getHTTPStatus().toString() + ')';
    }

    public HTTPStatus getHTTPStatus() {
        HTTPStatus httpStatus = statusMap.get(this.getCode());
        if (httpStatus == null) {
            httpStatus = statusMap.get(-1);
        }
        return httpStatus;
    }

    public int getHTTPCode() {
        return this.getHTTPStatus().getCode();
    }

    public String getHTTPMessage() {
        return this.getHTTPStatus().getMessage();
    }

    static {
        statusMap.put(200, new HTTPStatus(200, "OK"));
        statusMap.put(201, new HTTPStatus(201, "Created"));
        statusMap.put(202, new HTTPStatus(202, "Accepted"));
        statusMap.put(304, new HTTPStatus(304, "Not Modified"));
        statusMap.put(500, new HTTPStatus(500, "Internal Server Error"));
        statusMap.put(501, new HTTPStatus(501, "Not Implemented"));
        statusMap.put(400, new HTTPStatus(400, "bad_request"));
        statusMap.put(401, new HTTPStatus(401, "unauthorized"));
        statusMap.put(403, new HTTPStatus(403, "forbidden"));
        statusMap.put(404, new HTTPStatus(404, "not_found"));
        statusMap.put(405, new HTTPStatus(405, "method_not_allowed"));
        statusMap.put(406, new HTTPStatus(406, "not_acceptable"));
        statusMap.put(408, new HTTPStatus(408, "request_timeout"));
        statusMap.put(409, new HTTPStatus(409, "conflict"));
        statusMap.put(410, new HTTPStatus(410, "gone"));
        statusMap.put(412, new HTTPStatus(412, "file_exists"));
        statusMap.put(415, new HTTPStatus(415, "bad_content_type"));
        statusMap.put(-1, new HTTPStatus(500, "Internal error"));
        statusMap.put(490, new HTTPStatus(400, "Bad data encoding"));
        statusMap.put(491, new HTTPStatus(400, "Invalid attachment"));
        statusMap.put(492, new HTTPStatus(404, "Attachment not found"));
        statusMap.put(493, new HTTPStatus(400, "Invalid JSON"));
        statusMap.put(494, new HTTPStatus(400, "Invalid database/document/revision ID"));
        statusMap.put(495, new HTTPStatus(400, "Invalid parameter in HTTP query or JSON body"));
        statusMap.put(496, new HTTPStatus(404, "Deleted"));
        statusMap.put(497, new HTTPStatus(406, "Can't open database in that storage format"));
        statusMap.put(587, new HTTPStatus(502, "Server changes feed parse error"));
        statusMap.put(588, new HTTPStatus(502, "Server changes feed truncated"));
        statusMap.put(589, new HTTPStatus(502, "Invalid response from remote replication server"));
        statusMap.put(590, new HTTPStatus(500, "Database error!"));
        statusMap.put(591, new HTTPStatus(500, "Invalid data in database"));
        statusMap.put(592, new HTTPStatus(500, "Attachment store error"));
        statusMap.put(593, new HTTPStatus(500, "Application callback block failed"));
        statusMap.put(594, new HTTPStatus(500, "Internal error"));
        statusMap.put(595, new HTTPStatus(500, "Database locked"));
    }

    public static class HTTPStatus {
        private int code;
        private String message;

        public HTTPStatus(int code, String message) {
            this.code = code;
            this.message = message;
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return "HTTP " + this.code + ' ' + this.message;
        }
    }
}

