/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.Database;
import com.couchbase.lite.Document;
import com.couchbase.lite.SavedRevision;
import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.internal.RevisionInternal;
import com.couchbase.lite.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryRow {
    private Object key;
    private Object value;
    private long sequence;
    private String sourceDocID;
    RevisionInternal documentRevision;
    private Database database;

    @InterfaceAudience.Private
    public QueryRow(String docID, long sequence, Object key, Object value, RevisionInternal docRevision) {
        this.sourceDocID = docID;
        this.sequence = sequence;
        this.key = key;
        this.value = value;
        this.documentRevision = docRevision;
    }

    protected Database getDatabase() {
        return this.database;
    }

    protected void setDatabase(Database database) {
        this.database = database;
    }

    @InterfaceAudience.Public
    public Document getDocument() {
        if (this.getDocumentId() == null) {
            return null;
        }
        assert (this.database != null);
        Document document = this.database.getDocument(this.getDocumentId());
        document.loadCurrentRevisionFrom(this);
        return document;
    }

    @InterfaceAudience.Public
    public Object getKey() {
        return this.key;
    }

    @InterfaceAudience.Public
    public Object getValue() {
        return this.value;
    }

    @InterfaceAudience.Public
    public String getDocumentId() {
        String docID = null;
        if (this.documentRevision != null) {
            docID = this.documentRevision.getDocID();
        }
        if (docID == null && this.value != null && this.value instanceof Map) {
            Map props = (Map)this.value;
            docID = (String)props.get("_id");
        }
        if (docID == null) {
            docID = this.sourceDocID;
        }
        return docID;
    }

    @InterfaceAudience.Public
    public String getSourceDocumentId() {
        return this.sourceDocID;
    }

    @InterfaceAudience.Public
    public String getDocumentRevisionId() {
        Map mapValue;
        String rev = null;
        if (this.documentRevision != null) {
            rev = this.documentRevision.getRevID();
        }
        if (rev == null && this.value instanceof Map && (rev = (String)(mapValue = (Map)this.value).get("_rev")) == null) {
            rev = (String)mapValue.get("rev");
        }
        return rev;
    }

    @InterfaceAudience.Public
    public Map<String, Object> getDocumentProperties() {
        return this.documentRevision != null ? this.documentRevision.getProperties() : null;
    }

    @InterfaceAudience.Public
    public long getSequenceNumber() {
        return this.sequence;
    }

    @InterfaceAudience.Public
    public List<SavedRevision> getConflictingRevisions() {
        Document doc = this.database.getDocument(this.sourceDocID);
        Map valueTmp = (Map)this.value;
        ArrayList conflicts = (ArrayList)valueTmp.get("_conflicts");
        if (conflicts == null) {
            conflicts = new ArrayList();
        }
        ArrayList<SavedRevision> conflictingRevisions = new ArrayList<SavedRevision>();
        for (String conflictRevisionId : conflicts) {
            SavedRevision revision = doc.getRevision(conflictRevisionId);
            conflictingRevisions.add(revision);
        }
        return conflictingRevisions;
    }

    @InterfaceAudience.Public
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof QueryRow)) {
            return false;
        }
        QueryRow other = (QueryRow)object;
        if (this.database == other.database && Utils.isEqual(this.key, other.getKey()) && Utils.isEqual(this.sourceDocID, other.getSourceDocumentId()) && Utils.isEqual(this.documentRevision, other.documentRevision)) {
            if (this.value != null || other.getValue() != null) {
                return this.value.equals(other.getValue());
            }
            return this.sequence == other.sequence;
        }
        return false;
    }

    @InterfaceAudience.Public
    public String toString() {
        return this.asJSONDictionary().toString();
    }

    @InterfaceAudience.Private
    public Map<String, Object> asJSONDictionary() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.value != null || this.sourceDocID != null) {
            result.put("key", this.key);
            result.put("value", this.value);
            result.put("id", this.sourceDocID);
            result.put("doc", this.getDocumentProperties());
        } else {
            result.put("key", this.key);
            result.put("error", "not_found");
        }
        return result;
    }
}

