/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.util.Log;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class Misc {
    public static String CreateUUID() {
        return UUID.randomUUID().toString().toLowerCase();
    }

    public static String HexSHA1Digest(byte[] input) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            Log.e("Database", "Error, SHA-1 getDigest is unavailable.");
            return null;
        }
        byte[] sha1hash = new byte[40];
        md.update(input, 0, input.length);
        sha1hash = md.digest();
        return Misc.convertToHex(sha1hash);
    }

    public static String convertToHex(byte[] data) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }

    public static int SequenceCompare(long a, long b) {
        long diff = a - b;
        return diff > 0L ? 1 : (diff < 0L ? -1 : 0);
    }

    public static String unquoteString(String param) {
        return param.replace("\"", "");
    }

    public static Object keyForPrefixMatch(Object key, int depth) {
        if (depth < 1) {
            return key;
        }
        if (key instanceof String) {
            return key + "\uffff";
        }
        if (key instanceof List) {
            ArrayList<Map> nuKey = new ArrayList<Map>((List)key);
            if (depth == 1) {
                nuKey.add(new HashMap());
            } else {
                Object lastObject = nuKey.get(nuKey.size() - 1);
                lastObject = Misc.keyForPrefixMatch(lastObject, depth - 1);
                nuKey.set(nuKey.size() - 1, (Map)lastObject);
            }
            return nuKey;
        }
        return key;
    }
}

