/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.AsyncTask;
import com.couchbase.lite.Context;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.DatabaseOptions;
import com.couchbase.lite.DatabaseUpgrade;
import com.couchbase.lite.ManagerOptions;
import com.couchbase.lite.Status;
import com.couchbase.lite.auth.BaseAuthorizer;
import com.couchbase.lite.auth.FacebookAuthorizer;
import com.couchbase.lite.auth.PersonaAuthorizer;
import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.replicator.Replication;
import com.couchbase.lite.support.FileDirUtils;
import com.couchbase.lite.support.HttpClientFactory;
import com.couchbase.lite.support.Version;
import com.couchbase.lite.util.Log;
import com.couchbase.lite.util.StreamUtils;
import com.couchbase.lite.util.Utils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Manager {
    public static final String PRODUCT_NAME = "CouchbaseLite";
    protected static final String kV1DBExtension = ".cblite";
    protected static final String kDBExtension = ".cblite2";
    public static final ManagerOptions DEFAULT_OPTIONS = new ManagerOptions();
    public static final String LEGAL_CHARACTERS = "[^a-z]{1,}[^a-z0-9_$()/+-]*$";
    public static String USER_AGENT = null;
    public static final String SQLITE_STORAGE = "SQLite";
    public static final String FORESTDB_STORAGE = "ForestDB";
    private static final ObjectMapper mapper = new ObjectMapper().disable(new JsonParser.Feature[]{JsonParser.Feature.AUTO_CLOSE_SOURCE});
    private ManagerOptions options;
    private File directoryFile;
    Object lockDatabases = new Object();
    private Map<String, Database> databases;
    private Map<String, Object> encryptionKeys;
    private List<Replication> replications;
    private ScheduledExecutorService workExecutor;
    private HttpClientFactory defaultHttpClientFactory;
    private Context context;
    private String storageType;
    public static final String VERSION = Version.VERSION;
    private static String OS = System.getProperty("os.name").toLowerCase();

    @InterfaceAudience.Public
    public Manager() {
        String detailMessage = "Parameterless constructor is not a valid API call on Android.  Pure java version coming soon.";
        throw new UnsupportedOperationException("Parameterless constructor is not a valid API call on Android.  Pure java version coming soon.");
    }

    @InterfaceAudience.Public
    public Manager(Context context, ManagerOptions options) throws IOException {
        Log.i("Database", "### %s ###", Manager.getFullVersionInfo());
        this.context = context;
        this.directoryFile = context.getFilesDir();
        this.options = options != null ? options : DEFAULT_OPTIONS;
        this.databases = new HashMap<String, Database>();
        this.encryptionKeys = new HashMap<String, Object>();
        this.replications = new ArrayList<Replication>();
        if (!this.directoryFile.exists()) {
            this.directoryFile.mkdirs();
        }
        if (!this.directoryFile.isDirectory()) {
            throw new IOException(String.format(Locale.ENGLISH, "Unable to create directory for: %s", this.directoryFile));
        }
        this.upgradeOldDatabaseFiles(this.directoryFile);
        this.workExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "CBLManagerWorkExecutor");
            }
        });
    }

    @InterfaceAudience.Public
    public static Manager getSharedInstance() {
        String detailMessage = "getSharedInstance() is not a valid API call on Android.  Pure java version coming soon";
        throw new UnsupportedOperationException("getSharedInstance() is not a valid API call on Android.  Pure java version coming soon");
    }

    @InterfaceAudience.Public
    public String getStorageType() {
        return this.storageType;
    }

    @InterfaceAudience.Public
    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    public static void enableLogging(String tag, int logLevel) {
        Log.enableLogging(tag, logLevel);
    }

    @InterfaceAudience.Public
    public static boolean isValidDatabaseName(String databaseName) {
        if (databaseName.length() > 0 && databaseName.length() < 240 && Manager.containsOnlyLegalCharacters(databaseName) && Character.isLowerCase(databaseName.charAt(0))) {
            return true;
        }
        return databaseName.equals("_replicator");
    }

    @InterfaceAudience.Public
    public List<String> getAllDatabaseNames() {
        String[] databaseFiles = this.directoryFile.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(Manager.kDBExtension);
            }
        });
        ArrayList<String> result = new ArrayList<String>();
        for (String databaseFile : databaseFiles) {
            String trimmed = databaseFile.substring(0, databaseFile.length() - kDBExtension.length());
            String replaced = trimmed.replace(':', '/');
            result.add(replaced);
        }
        Collections.sort(result);
        return Collections.unmodifiableList(result);
    }

    @InterfaceAudience.Public
    public File getDirectory() {
        return this.directoryFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Public
    public void close() {
        Object object = this.lockDatabases;
        synchronized (object) {
            Database[] openDbs;
            Log.d("Database", "Closing " + this);
            for (Database database : openDbs = this.databases.values().toArray(new Database[this.databases.size()])) {
                database.close();
            }
            this.databases.clear();
            this.context.getNetworkReachabilityManager().stopListening();
            if (this.workExecutor != null && !this.workExecutor.isShutdown()) {
                Utils.shutdownAndAwaitTermination(this.workExecutor);
            }
            Log.d("Database", "Closed " + this);
        }
    }

    @InterfaceAudience.Public
    public Database getDatabase(String name) throws CouchbaseLiteException {
        DatabaseOptions options = this.getDefaultOptions(name);
        options.setCreate(true);
        return this.openDatabase(name, options);
    }

    @InterfaceAudience.Public
    public Database getExistingDatabase(String name) throws CouchbaseLiteException {
        DatabaseOptions options = this.getDefaultOptions(name);
        return this.openDatabase(name, options);
    }

    @InterfaceAudience.Public
    public Database openDatabase(String name, DatabaseOptions options) throws CouchbaseLiteException {
        Database db;
        if (options == null) {
            options = this.getDefaultOptions(name);
        }
        if ((db = this.getDatabase(name, !options.isCreate())) != null && !db.isOpen()) {
            db.open(options);
            this.registerEncryptionKey(options.getEncryptionKey(), name);
        }
        return db;
    }

    @InterfaceAudience.Public
    public boolean registerEncryptionKey(Object keyOrPassword, String databaseName) {
        if (databaseName == null) {
            return false;
        }
        if (keyOrPassword != null) {
            this.encryptionKeys.put(databaseName, keyOrPassword);
        } else {
            this.encryptionKeys.remove(databaseName);
        }
        return true;
    }

    @InterfaceAudience.Public
    public void replaceDatabase(String databaseName, InputStream databaseStream, Map<String, InputStream> attachmentStreams) throws CouchbaseLiteException {
        this.replaceDatabase(databaseName, databaseStream, attachmentStreams == null ? null : attachmentStreams.entrySet().iterator());
    }

    @InterfaceAudience.Public
    public boolean replaceDatabase(String databaseName, String databaseDir) {
        Database db = this.getDatabase(databaseName, false);
        if (db == null) {
            return false;
        }
        File dir = new File(databaseDir);
        if (!dir.exists()) {
            Log.w("Database", "Database file doesn't exist at path : %s", databaseDir);
            return false;
        }
        if (!dir.isDirectory()) {
            Log.w("Database", "Database file is not a directory. Use -replaceDatabaseNamed:withDatabaseFilewithAttachments:error: instead.");
            return false;
        }
        File destDir = new File(db.getPath());
        File srcDir = new File(databaseDir);
        if (destDir.exists() && !FileDirUtils.deleteRecursive(destDir)) {
            Log.w("Database", "Failed to delete file/directly: " + destDir);
            return false;
        }
        try {
            FileDirUtils.copyFolder(srcDir, destDir);
        }
        catch (IOException e) {
            Log.w("Database", "Failed to copy directly from " + srcDir + " to " + destDir, e);
            return false;
        }
        try {
            db.open();
        }
        catch (CouchbaseLiteException e) {
            Log.w("Database", "Failed to open database", e);
            return false;
        }
        if (!db.replaceUUIDs()) {
            Log.w("Database", "Failed to replace UUIDs");
            db.close();
            return false;
        }
        db.close();
        return true;
    }

    @InterfaceAudience.Private
    DatabaseOptions getDefaultOptions(String databaseName) {
        DatabaseOptions options = new DatabaseOptions();
        options.setEncryptionKey(this.encryptionKeys.get(databaseName));
        return options;
    }

    @InterfaceAudience.Private
    public static ObjectMapper getObjectMapper() {
        return mapper;
    }

    @InterfaceAudience.Private
    public HttpClientFactory getDefaultHttpClientFactory() {
        return this.defaultHttpClientFactory;
    }

    @InterfaceAudience.Private
    public void setDefaultHttpClientFactory(HttpClientFactory defaultHttpClientFactory) {
        this.defaultHttpClientFactory = defaultHttpClientFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public Collection<Database> allOpenDatabases() {
        Object object = this.lockDatabases;
        synchronized (object) {
            return this.databases.values();
        }
    }

    @InterfaceAudience.Private
    public Map<String, Object> getEncryptionKeys() {
        return Collections.unmodifiableMap(this.encryptionKeys);
    }

    @InterfaceAudience.Private
    public Future runAsync(String databaseName, final AsyncTask function) throws CouchbaseLiteException {
        final Database database = this.getDatabase(databaseName);
        return this.runAsync(new Runnable(){

            @Override
            public void run() {
                function.run(database);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public Database getDatabase(String name, boolean mustExist) {
        Object object = this.lockDatabases;
        synchronized (object) {
            Database db;
            if (this.options.isReadOnly()) {
                mustExist = true;
            }
            if ((db = this.databases.get(name)) == null) {
                if (!Manager.isValidDatabaseName(name)) {
                    throw new IllegalArgumentException("Invalid database name: " + name);
                }
                String path = this.pathForDatabaseNamed(name);
                if (path == null) {
                    return null;
                }
                db = new Database(path, name, this, this.options.isReadOnly());
                if (mustExist && !db.exists()) {
                    Log.i("Database", "mustExist is true and db (%s) does not exist", name);
                    return null;
                }
                db.setName(name);
                this.databases.put(name, db);
            }
            Log.v("Database", "getDatabase() %s %s", this, db);
            return db;
        }
    }

    @InterfaceAudience.Private
    public Replication getReplicator(Map<String, Object> properties) throws CouchbaseLiteException {
        Replication activeReplicator;
        String remoteUUID;
        String filterName;
        Map<String, Object> remoteMap;
        boolean cancel;
        Map<String, Object> sourceMap = Manager.parseSourceOrTarget(properties, "source");
        Map<String, Object> targetMap = Manager.parseSourceOrTarget(properties, "target");
        String source = (String)sourceMap.get("url");
        String target = (String)targetMap.get("url");
        Boolean createTargetBoolean = (Boolean)properties.get("create_target");
        boolean createTarget = createTargetBoolean != null && createTargetBoolean != false;
        Boolean continuousBoolean = (Boolean)properties.get("continuous");
        boolean continuous = continuousBoolean != null && continuousBoolean != false;
        Boolean cancelBoolean = (Boolean)properties.get("cancel");
        boolean bl = cancel = cancelBoolean != null && cancelBoolean != false;
        if (source == null || target == null) {
            throw new CouchbaseLiteException("Source and target are both null", new Status(400));
        }
        boolean push = false;
        Database db = null;
        String remoteStr = null;
        if (Manager.isValidDatabaseName(source)) {
            db = this.getExistingDatabase(source);
            remoteStr = target;
            push = true;
            remoteMap = targetMap;
        } else {
            remoteStr = source;
            if (createTarget && !cancel) {
                boolean mustExist = false;
                db = this.getDatabase(target, mustExist);
                db.open();
            } else {
                db = this.getExistingDatabase(target);
            }
            if (db == null) {
                throw new CouchbaseLiteException("Database is null", new Status(404));
            }
            remoteMap = sourceMap;
        }
        if (properties.get("filter") != null && properties.get("doc_ids") != null) {
            throw new CouchbaseLiteException("Can't specify both a filter and doc IDs", new Status(400));
        }
        URL remote = null;
        try {
            remote = new URL(remoteStr);
        }
        catch (MalformedURLException e) {
            throw new CouchbaseLiteException("Malformed remote url: " + remoteStr, new Status(400));
        }
        if (remote == null) {
            throw new CouchbaseLiteException("Remote URL is null: " + remoteStr, new Status(400));
        }
        BaseAuthorizer authorizer = null;
        Map authMap = (Map)remoteMap.get("auth");
        if (authMap != null) {
            Map facebook;
            Map persona = (Map)authMap.get("persona");
            if (persona != null) {
                String email = (String)persona.get("email");
                authorizer = new PersonaAuthorizer(email);
            }
            if ((facebook = (Map)authMap.get("facebook")) != null) {
                String email = (String)facebook.get("email");
                authorizer = new FacebookAuthorizer(email);
            }
            authorizer.setRemoteURL(remote);
            authorizer.setLocalUUID(db.publicUUID());
        }
        Replication repl = db.createReplicator(remote, push, this.getDefaultHttpClientFactory());
        repl.setContinuous(continuous);
        if (authorizer != null) {
            repl.setAuthenticator(authorizer);
        }
        Map headers = null;
        if (remoteMap != null) {
            headers = (Map)remoteMap.get("headers");
        }
        if (headers != null && !headers.isEmpty()) {
            repl.setHeaders(headers);
        }
        if ((filterName = (String)properties.get("filter")) != null) {
            repl.setFilter(filterName);
            Map filterParams = (Map)properties.get("query_params");
            if (filterParams != null) {
                repl.setFilterParams(filterParams);
            }
        }
        if (properties.get("doc_ids") != null && properties.get("doc_ids") instanceof List) {
            List docIds = (List)properties.get("doc_ids");
            repl.setDocIds(docIds);
        }
        if ((remoteUUID = (String)properties.get("remoteUUID")) != null) {
            repl.setRemoteUUID(remoteUUID);
        }
        if (push) {
            repl.setCreateTarget(createTarget);
        }
        return (activeReplicator = db.findActiveReplicator(repl)) != null ? activeReplicator : repl;
    }

    @InterfaceAudience.Private
    public ScheduledExecutorService getWorkExecutor() {
        return this.workExecutor;
    }

    @InterfaceAudience.Private
    public Context getContext() {
        return this.context;
    }

    @InterfaceAudience.Private
    public int getExecutorThreadPoolSize() {
        return this.options.getExecutorThreadPoolSize();
    }

    @InterfaceAudience.Private
    private void replaceDatabase(String databaseName, InputStream databaseStream, Iterator<Map.Entry<String, InputStream>> attachmentStreams) throws CouchbaseLiteException {
        try {
            Database db = this.getDatabase(databaseName, false);
            String dstDbPath = FileDirUtils.getPathWithoutExt(db.getPath()) + kV1DBExtension;
            String dstAttsPath = FileDirUtils.getPathWithoutExt(dstDbPath) + " attachments";
            FileOutputStream destStream = new FileOutputStream(new File(dstDbPath));
            StreamUtils.copyStream(databaseStream, destStream);
            File attachmentsFile = new File(dstAttsPath);
            FileDirUtils.deleteRecursive(attachmentsFile);
            if (!attachmentsFile.exists()) {
                attachmentsFile.mkdirs();
            }
            if (attachmentStreams != null) {
                StreamUtils.copyStreamsToFolder(attachmentStreams, attachmentsFile);
            }
            if (!this.upgradeV1Database(databaseName, dstDbPath)) {
                throw new CouchbaseLiteException(500);
            }
            db.open();
            db.replaceUUIDs();
        }
        catch (FileNotFoundException e) {
            Log.e("Database", "Error replacing the database: %s", e, databaseName);
            throw new CouchbaseLiteException(500);
        }
        catch (IOException e) {
            Log.e("Database", "Error replacing the database: %s", e, databaseName);
            throw new CouchbaseLiteException(500);
        }
    }

    @InterfaceAudience.Private
    private static boolean containsOnlyLegalCharacters(String databaseName) {
        Pattern p = Pattern.compile("^[abcdefghijklmnopqrstuvwxyz0123456789_$()+-/]+$");
        Matcher matcher = p.matcher(databaseName);
        return matcher.matches();
    }

    @InterfaceAudience.Private
    private void upgradeOldDatabaseFiles(File dir) throws IOException {
        if (dir == null) {
            throw new IllegalArgumentException("dir argument is null.");
        }
        if (!(dir.exists() && dir.isDirectory() && dir.canRead() && dir.canWrite())) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "dir[%s] might not exist, not be a directory, or not have read/write permission.", dir));
        }
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.endsWith(Manager.kV1DBExtension);
            }
        });
        if (files == null) {
            throw new IOException(String.format(Locale.ENGLISH, "Error in File.listFiles(): dir[%s]: dir might not be directory, or i/o error occurs.", dir));
        }
        for (File file : files) {
            String oldDbPath;
            String filename = file.getName();
            String name = Manager.nameOfDatabaseAtPath(filename);
            if (this.upgradeDatabase(name, oldDbPath = new File(dir, filename).getAbsolutePath(), true)) continue;
            throw new RuntimeException("Database upgrade failed for: " + name);
        }
    }

    private boolean upgradeDatabase(String name, String dbPath, boolean close) {
        String oldAttachmentsName;
        File oldAttachmentsDir;
        Log.v("Database", "CouchbaseLite: Upgrading database (%s) at %s ...", name, dbPath);
        Database db = this.getDatabase(name, false);
        if (!db.exists() && !name.equals("_replicator")) {
            DatabaseUpgrade upgrader;
            String tempName = name + ".tmp";
            Database tmpDB = this.getDatabase(tempName, false);
            if (tmpDB == null) {
                Log.w("Database", "Upgrade failed: Creating new db failed: %s", tempName);
                return false;
            }
            if (tmpDB.exists()) {
                Log.v("Database", "Previous upgrade probably crashed midway. dbPath: " + dbPath);
                upgrader = new DatabaseUpgrade(this, tmpDB, dbPath);
                upgrader.backOut();
                tmpDB = this.getDatabase(tempName, false);
                if (tmpDB == null) {
                    Log.w("Database", "Upgrade failed: Creating new db failed: %s", tempName);
                    return false;
                }
            }
            if (tmpDB.exists()) {
                Log.w("Database", "Upgrade failed: Failed to delete already existing db: %s", tempName);
                return false;
            }
            upgrader = new DatabaseUpgrade(this, tmpDB, dbPath);
            if (!upgrader.importData()) {
                upgrader.backOut();
                return false;
            }
            tmpDB.close();
            File tmpPath = new File(this.pathForDatabaseNamed(tempName));
            File newPath = new File(this.pathForDatabaseNamed(name));
            if (!tmpPath.renameTo(newPath)) {
                Log.w("Database", "Upgrade failed: Failed to rename db folder from temporary name: %s -> %s", tmpPath, newPath);
                upgrader = new DatabaseUpgrade(this, this.getDatabase(tempName, false), dbPath);
                upgrader.backOut();
                return false;
            }
            db = this.getDatabase(name, false);
            if (!db.exists()) {
                Log.w("Database", "Upgrade failed: Failed to open the database after migrate: %s", name);
                return false;
            }
        }
        if (close) {
            db.close();
        }
        Manager.moveSQLiteDbFiles(dbPath, null);
        if (dbPath.endsWith(kV1DBExtension) && (oldAttachmentsDir = new File(this.directoryFile, oldAttachmentsName = FileDirUtils.getDatabaseNameFromPath(dbPath) + " attachments")).exists()) {
            FileDirUtils.deleteRecursive(oldAttachmentsDir);
        }
        Log.v("Database", "    ...success!");
        return true;
    }

    private boolean upgradeV1Database(String name, String dbPath) {
        if (dbPath.endsWith(kV1DBExtension)) {
            return this.upgradeDatabase(name, dbPath, false);
        }
        Log.w("Database", "Upgrade skipped: Database file extension is not %s", kDBExtension);
        return true;
    }

    private static void moveSQLiteDbFiles(String oldDbPath, String newDbPath) {
        for (String suffix : Arrays.asList("", "-wal", "-shm", "-journal")) {
            File oldFile = new File(oldDbPath + suffix);
            if (!oldFile.exists()) continue;
            if (newDbPath != null) {
                oldFile.renameTo(new File(newDbPath + suffix));
                continue;
            }
            oldFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    protected Future runAsync(Runnable runnable) {
        ScheduledExecutorService scheduledExecutorService = this.workExecutor;
        synchronized (scheduledExecutorService) {
            if (!this.workExecutor.isShutdown()) {
                return this.workExecutor.submit(runnable);
            }
            return null;
        }
    }

    @InterfaceAudience.Private
    private static String nameOfDatabaseAtPath(String path) {
        String name = FileDirUtils.getDatabaseNameFromPath(path);
        return Manager.isWindows() ? name.replace('/', '.') : name.replace('/', ':');
    }

    @InterfaceAudience.Private
    private String pathForDatabaseNamed(String name) {
        if (name == null || name.length() == 0 || Pattern.matches(LEGAL_CHARACTERS, name)) {
            return null;
        }
        name = Manager.isWindows() ? name.replace('/', '.') : name.replace('/', ':');
        String result = this.directoryFile.getPath() + File.separator + name + kDBExtension;
        return result;
    }

    @InterfaceAudience.Private
    private static Map<String, Object> parseSourceOrTarget(Map<String, Object> properties, String key) {
        Map<String, Object> result = new HashMap<String, Object>();
        Object value = properties.get(key);
        if (value instanceof String) {
            result.put("url", value);
        } else if (value instanceof Map) {
            result = (Map)value;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    protected void forgetDatabase(Database db) {
        Object object = this.lockDatabases;
        synchronized (object) {
            Log.v("Database", "Fogetting forgetDatabase() %s %s", this, db);
            this.databases.remove(db.getName());
            Iterator<Replication> replicationIterator = this.replications.iterator();
            while (replicationIterator.hasNext()) {
                Replication replication = replicationIterator.next();
                if (!replication.getLocalDatabase().getName().equals(db.getName())) continue;
                replicationIterator.remove();
            }
            this.encryptionKeys.remove(db.getName());
            Log.v("Database", "Forgot forgetDatabase() %s %s", this, db);
        }
    }

    @InterfaceAudience.Private
    protected boolean isAutoMigrateBlobStoreFilename() {
        return this.options.isAutoMigrateBlobStoreFilename();
    }

    @InterfaceAudience.Private
    private static boolean isWindows() {
        return OS.indexOf("win") >= 0;
    }

    public static String getUserAgent() {
        if (USER_AGENT == null) {
            USER_AGENT = String.format(Locale.ENGLISH, "%s/%s (%s/%s)", PRODUCT_NAME, "1.3", Version.getVersionName(), Version.getCommitHash());
        }
        return USER_AGENT;
    }

    public static String getFullVersionInfo() {
        return String.format(Locale.ENGLISH, "Couchbase Lite %s (%s)", Version.getVersionName(), Version.getCommitHash());
    }
}

