/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.internal.RevisionInternal;
import java.net.URL;
import java.util.Locale;

public class DocumentChange {
    private RevisionInternal addedRevision;
    private String documentID;
    private String winningRevisionID;
    private boolean isConflict;
    private URL source;

    @InterfaceAudience.Private
    public DocumentChange(RevisionInternal addedRevision, String winningRevisionID, boolean isConflict, URL source) {
        this.addedRevision = addedRevision;
        this.documentID = addedRevision.getDocID();
        this.winningRevisionID = winningRevisionID;
        this.isConflict = isConflict;
        this.source = source;
    }

    @InterfaceAudience.Private
    public DocumentChange(String docID) {
        this.documentID = docID;
    }

    @InterfaceAudience.Public
    public String getDocumentId() {
        return this.documentID;
    }

    @InterfaceAudience.Public
    public String getRevisionId() {
        return this.addedRevision != null ? this.addedRevision.getRevID() : null;
    }

    @InterfaceAudience.Public
    public boolean isCurrentRevision() {
        return this.winningRevisionID != null && this.addedRevision != null && this.addedRevision.getRevID().equals(this.winningRevisionID);
    }

    @InterfaceAudience.Public
    public boolean isConflict() {
        return this.isConflict;
    }

    @InterfaceAudience.Public
    public URL getSource() {
        return this.source;
    }

    @InterfaceAudience.Public
    public boolean isDeletion() {
        return this.addedRevision != null ? this.addedRevision.isDeleted() : false;
    }

    @InterfaceAudience.Public
    public String toString() {
        return String.format(Locale.ENGLISH, "%s[%s]", this.getClass().getName(), this.addedRevision);
    }

    @InterfaceAudience.Private
    public RevisionInternal getAddedRevision() {
        return this.addedRevision;
    }

    @InterfaceAudience.Private
    protected RevisionInternal getWinningRevisionIfKnown() {
        return this.isCurrentRevision() ? this.addedRevision : null;
    }

    @InterfaceAudience.Private
    public String getWinningRevisionID() {
        return this.winningRevisionID;
    }

    protected void reduceMemoryUsage() {
        if (this.addedRevision != null) {
            this.addedRevision = this.addedRevision.copyWithoutBody();
        }
    }
}

