/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.support.WeakValueHashMap;
import com.couchbase.lite.util.LruCache;

@InterfaceAudience.Private
public class Cache<K, V> {
    private static final int DEFAULT_RETAIN_LIMIT = 50;
    int retainLimit = 50;
    private LruCache<K, V> strongReferenceCache;
    private WeakValueHashMap<K, V> weakReferenceCache;

    public Cache() {
        this(50);
    }

    public Cache(int retainLimit) {
        this.retainLimit = retainLimit;
        this.strongReferenceCache = new LruCache(this.retainLimit);
        this.weakReferenceCache = new WeakValueHashMap();
    }

    public V put(K key, V value) {
        this.strongReferenceCache.put(key, value);
        this.weakReferenceCache.put(key, value);
        return value;
    }

    public V get(K key) {
        Object value = null;
        if (this.weakReferenceCache.containsKey(key)) {
            value = this.weakReferenceCache.get(key);
        }
        if (value != null && this.strongReferenceCache.get(key) == null) {
            this.strongReferenceCache.put(key, value);
        }
        return value;
    }

    public V remove(K key) {
        V removedStrongValue = null;
        V removedWeakValue = null;
        removedStrongValue = this.strongReferenceCache.remove(key);
        removedWeakValue = this.weakReferenceCache.remove(key);
        if (removedStrongValue != null) {
            return removedStrongValue;
        }
        if (removedWeakValue != null) {
            return removedWeakValue;
        }
        return null;
    }

    public void clear() {
        this.strongReferenceCache.evictAll();
        this.weakReferenceCache.clear();
    }

    public V resourceWithCacheKeyDontRecache(K key) {
        return this.weakReferenceCache.get(key);
    }
}

