/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.support.Base64;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;

public class BlobKey {
    private byte[] bytes;

    public BlobKey() {
    }

    public BlobKey(byte[] bytes) {
        this.bytes = bytes;
    }

    public BlobKey(String base64Digest) {
        this(BlobKey.decodeBase64Digest(base64Digest));
    }

    private static byte[] decodeBase64Digest(String base64Digest) {
        String expectedPrefix = "sha1-";
        if (!base64Digest.startsWith(expectedPrefix)) {
            throw new IllegalArgumentException(base64Digest + " did not start with " + expectedPrefix);
        }
        base64Digest = base64Digest.replaceFirst(expectedPrefix, "");
        byte[] bytes = new byte[]{};
        try {
            bytes = Base64.decode(base64Digest);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public static String convertToHex(byte[] data) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(65 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }

    public static byte[] convertFromHex(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BlobKey)) {
            return false;
        }
        BlobKey oBlobKey = (BlobKey)o;
        return Arrays.equals(this.getBytes(), oBlobKey.getBytes());
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public String toString() {
        if (this.bytes != null) {
            return BlobKey.convertToHex(this.bytes);
        }
        return null;
    }

    public String base64Digest() {
        return String.format(Locale.ENGLISH, "sha1-%s", Base64.encodeBytes(this.bytes));
    }

    public boolean hasBlobKey() {
        if (this.bytes != null) {
            for (int i = 0; i < this.bytes.length; ++i) {
                if (this.bytes[i] == 0) continue;
                return true;
            }
        }
        return false;
    }
}

