/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.BlobStoreWriter;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.Document;
import com.couchbase.lite.Revision;
import com.couchbase.lite.internal.AttachmentInternal;
import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.support.security.SymmetricKeyException;
import com.couchbase.lite.util.Log;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Attachment {
    private Revision revision = null;
    private String name = null;
    private Map<String, Object> metadata = null;
    private InputStream body = null;

    @InterfaceAudience.Private
    public Attachment(InputStream contentStream, String contentType) {
        this.body = contentStream;
        this.metadata = new HashMap<String, Object>();
        this.metadata.put("content_type", contentType);
        this.metadata.put("follows", true);
    }

    @InterfaceAudience.Private
    protected Attachment(Revision revision, String name, Map<String, Object> metadata) {
        this.revision = revision;
        this.name = name;
        this.metadata = metadata;
    }

    private AttachmentInternal internalAttachment() throws CouchbaseLiteException {
        return this.revision.getDatabase().getAttachment(this.metadata, this.name);
    }

    @InterfaceAudience.Public
    public Revision getRevision() {
        return this.revision;
    }

    @InterfaceAudience.Public
    public Document getDocument() {
        return this.revision != null ? this.revision.getDocument() : null;
    }

    @InterfaceAudience.Public
    public String getName() {
        return this.name;
    }

    @InterfaceAudience.Public
    public String getContentType() {
        return (String)this.metadata.get("content_type");
    }

    @InterfaceAudience.Public
    public InputStream getContent() throws CouchbaseLiteException {
        if (this.body != null) {
            return this.body;
        }
        return new ByteArrayInputStream(this.internalAttachment().getContent());
    }

    @InterfaceAudience.Public
    public URL getContentURL() {
        try {
            return this.internalAttachment().getContentURL();
        }
        catch (MalformedURLException e) {
            Log.w("Database", e.toString());
        }
        catch (CouchbaseLiteException e) {
            Log.w("Database", e.toString());
        }
        return null;
    }

    @InterfaceAudience.Public
    public long getLength() {
        Number length = (Number)this.metadata.get("length");
        if (length != null) {
            return length.longValue();
        }
        return 0L;
    }

    @InterfaceAudience.Public
    public Map<String, Object> getMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    @InterfaceAudience.Private
    protected void setName(String name) {
        this.name = name;
    }

    @InterfaceAudience.Private
    protected void setRevision(Revision revision) {
        this.revision = revision;
    }

    @InterfaceAudience.Private
    protected InputStream getBodyIfNew() {
        return this.body;
    }

    @InterfaceAudience.Private
    protected static Map<String, Object> installAttachmentBodies(Map<String, Object> attachments, Database database) throws CouchbaseLiteException {
        HashMap<String, Object> updatedAttachments = new HashMap<String, Object>();
        for (String name : attachments.keySet()) {
            Object value = attachments.get(name);
            if (value instanceof Attachment) {
                Attachment attachment = (Attachment)value;
                HashMap<String, Object> metadataMutable = new HashMap<String, Object>();
                metadataMutable.putAll(attachment.getMetadata());
                InputStream body = attachment.getBodyIfNew();
                if (body != null) {
                    BlobStoreWriter writer;
                    try {
                        writer = Attachment.blobStoreWriterForBody(body, database);
                    }
                    catch (Exception e) {
                        throw new CouchbaseLiteException(e.getMessage(), 592);
                    }
                    metadataMutable.put("length", writer.getLength());
                    metadataMutable.put("digest", writer.mD5DigestString());
                    metadataMutable.put("follows", true);
                    database.rememberAttachmentWriter(writer);
                }
                updatedAttachments.put(name, metadataMutable);
                continue;
            }
            if (value instanceof AttachmentInternal) {
                throw new IllegalArgumentException("AttachmentInternal objects not expected here.  Could indicate a bug");
            }
            if (value == null) continue;
            updatedAttachments.put(name, value);
        }
        return updatedAttachments;
    }

    @InterfaceAudience.Private
    protected static BlobStoreWriter blobStoreWriterForBody(InputStream body, Database database) throws IOException, SymmetricKeyException {
        BlobStoreWriter writer = database.getAttachmentWriter();
        try {
            writer.appendInputStream(body);
            writer.finish();
        }
        catch (IOException e) {
            writer.cancel();
            throw e;
        }
        catch (SymmetricKeyException e) {
            writer.cancel();
            throw e;
        }
        return writer;
    }
}

