/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.query.handlers;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.config.ClusterCapabilities;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.deps.io.netty.util.CharsetUtil;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.ErrorCodeAndMessage;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.query.QueryChunkRow;
import com.couchbase.client.core.msg.query.QueryRequest;
import com.couchbase.client.core.msg.query.QueryResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.util.Golang;
import com.couchbase.client.core.util.LRUCache;
import com.couchbase.client.scala.HandlerBasicParams;
import com.couchbase.client.scala.codec.JsonDeserializer$JsonObjectSafeConvert$;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.json.JsonObject;
import com.couchbase.client.scala.json.JsonObject$;
import com.couchbase.client.scala.json.JsonObjectSafe;
import com.couchbase.client.scala.query.QueryMetaData;
import com.couchbase.client.scala.query.QueryMetrics;
import com.couchbase.client.scala.query.QueryMetrics$;
import com.couchbase.client.scala.query.QueryOptions;
import com.couchbase.client.scala.query.QueryResult;
import com.couchbase.client.scala.query.QueryStatus;
import com.couchbase.client.scala.query.QueryStatus$Aborted$;
import com.couchbase.client.scala.query.QueryStatus$Closed$;
import com.couchbase.client.scala.query.QueryStatus$Completed$;
import com.couchbase.client.scala.query.QueryStatus$Errors$;
import com.couchbase.client.scala.query.QueryStatus$Fatal$;
import com.couchbase.client.scala.query.QueryStatus$Running$;
import com.couchbase.client.scala.query.QueryStatus$Stopped$;
import com.couchbase.client.scala.query.QueryStatus$Success$;
import com.couchbase.client.scala.query.QueryStatus$Timeout$;
import com.couchbase.client.scala.query.QueryStatus$Unknown$;
import com.couchbase.client.scala.query.QueryWarning;
import com.couchbase.client.scala.query.ReactiveQueryResult;
import com.couchbase.client.scala.query.handlers.QueryCacheEntry;
import com.couchbase.client.scala.transformers.JacksonTransformers;
import com.couchbase.client.scala.util.DurationConversions$;
import com.couchbase.client.scala.util.FutureConversions$;
import com.couchbase.client.scala.util.Validate$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.compat.java8.OptionConverters$;
import scala.compat.java8.OptionConverters$RichOptionalGeneric$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005eg!\u0002\r\u001a\u0001u)\u0003\u0002C\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\t\u0011E\u0002!\u0011!Q\u0001\fIBQ\u0001\u000f\u0001\u0005\u0002eBqa\u0010\u0001C\u0002\u0013%\u0001\t\u0003\u0004G\u0001\u0001\u0006I!\u0011\u0005\b\u000f\u0002\u0011\r\u0011\"\u0003I\u0011\u0019a\u0005\u0001)A\u0005\u0013\"9Q\n\u0001b\u0001\n\u0013q\u0005BB3\u0001A\u0003%q\nC\u0004g\u0001\u0001\u0007I\u0011B4\t\u000f-\u0004\u0001\u0019!C\u0005Y\"1!\u000f\u0001Q!\n!DQa\u001e\u0001\u0005\naDq!!\u0001\u0001\t\u0013\t\u0019\u0001C\u0004\u0002R\u0001!I!a\u0015\t\u000f\u0005\u0015\u0004\u0001\"\u0003\u0002h!9\u0011Q\u0011\u0001\u0005\n\u0005\u001d\u0005bBAG\u0001\u0011%\u0011q\u0012\u0005\b\u0003/\u0003A\u0011BAM\u0011\u001d\t\t\u000b\u0001C\u0005\u0003GCq!a,\u0001\t\u0013\t\t\fC\u0004\u0002\u000e\u0002!\t!a/\t\u000f\u0005\r\u0007\u0001\"\u0001\u0002F\na\u0011+^3ss\"\u000bg\u000e\u001a7fe*\u0011!dG\u0001\tQ\u0006tG\r\\3sg*\u0011A$H\u0001\u0006cV,'/\u001f\u0006\u0003=}\tQa]2bY\u0006T!\u0001I\u0011\u0002\r\rd\u0017.\u001a8u\u0015\t\u00113%A\u0005d_V\u001c\u0007NY1tK*\tA%A\u0002d_6\u001c\"\u0001\u0001\u0014\u0011\u0005\u001dJS\"\u0001\u0015\u000b\u0003yI!A\u000b\u0015\u0003\r\u0005s\u0017PU3g\u0003\tA\u0007o\u0001\u0001\u0011\u00059zS\"A\u000f\n\u0005Aj\"A\u0005%b]\u0012dWM\u001d\"bg&\u001c\u0007+\u0019:b[N\f!!Z2\u0011\u0005M2T\"\u0001\u001b\u000b\u0005UB\u0013AC2p]\u000e,(O]3oi&\u0011q\u0007\u000e\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\fa\u0001P5oSRtDC\u0001\u001e?)\tYT\b\u0005\u0002=\u00015\t\u0011\u0004C\u00032\u0007\u0001\u000f!\u0007C\u0003,\u0007\u0001\u0007Q&\u0001\u0003d_J,W#A!\u0011\u0005\t#U\"A\"\u000b\u0005}z\u0012BA#D\u0005\u0011\u0019uN]3\u0002\u000b\r|'/\u001a\u0011\u0002\u001dE+XM]=DC\u000eDWmU5{KV\t\u0011\n\u0005\u0002(\u0015&\u00111\n\u000b\u0002\u0004\u0013:$\u0018aD)vKJL8)Y2iKNK'0\u001a\u0011\u0002\u0015E,XM]=DC\u000eDW-F\u0001P!\u0011\u0001Vk\u00162\u000e\u0003ES!AU*\u0002\tU$\u0018\u000e\u001c\u0006\u0002)\u0006!!.\u0019<b\u0013\t1\u0016KA\u0002NCB\u0004\"\u0001W0\u000f\u0005ek\u0006C\u0001.)\u001b\u0005Y&B\u0001/-\u0003\u0019a$o\\8u}%\u0011a\fK\u0001\u0007!J,G-\u001a4\n\u0005\u0001\f'AB*ue&twM\u0003\u0002_QA\u0011AhY\u0005\u0003If\u0011q\"U;fef\u001c\u0015m\u00195f\u000b:$(/_\u0001\fcV,'/_\"bG\",\u0007%A\ff]\"\fgnY3e!J,\u0007/\u0019:fI\u0016s\u0017M\u00197fIV\t\u0001\u000e\u0005\u0002(S&\u0011!\u000e\u000b\u0002\b\u0005>|G.Z1o\u0003m)g\u000e[1oG\u0016$\u0007K]3qCJ,G-\u00128bE2,Gm\u0018\u0013fcR\u0011Q\u000e\u001d\t\u0003O9L!a\u001c\u0015\u0003\tUs\u0017\u000e\u001e\u0005\bc.\t\t\u00111\u0001i\u0003\rAH%M\u0001\u0019K:D\u0017M\\2fIB\u0013X\r]1sK\u0012,e.\u00192mK\u0012\u0004\u0003F\u0001\u0007u!\t9S/\u0003\u0002wQ\tAao\u001c7bi&dW-A\u000fva\u0012\fG/Z#oQ\u0006t7-\u001a3Qe\u0016\u0004\u0018M]3e\u000b:\f'\r\\3e)\ti\u0017\u0010C\u0003{\u001b\u0001\u000710\u0001\u0004d_:4\u0017n\u001a\t\u0003yzl\u0011! \u0006\u0003u\u000eK!a`?\u0003\u001b\rcWo\u001d;fe\u000e{gNZ5h\u0003\u001d\u0011X-];fgR,B!!\u0002\u0002@QA\u0011qAA\u0010\u0003G\ty\u0003\u0005\u0004\u0002\n\u00055\u0011\u0011C\u0007\u0003\u0003\u0017Q!A\u0015\u0015\n\t\u0005=\u00111\u0002\u0002\u0004)JL\b\u0003BA\n\u00037i!!!\u0006\u000b\u0007q\t9BC\u0002\u0002\u001a\r\u000b1!\\:h\u0013\u0011\ti\"!\u0006\u0003\u0019E+XM]=SKF,Xm\u001d;\t\r\u0005\u0005b\u00021\u0001X\u0003%\u0019H/\u0019;f[\u0016tG\u000fC\u0004\u0002&9\u0001\r!a\n\u0002\u000f=\u0004H/[8ogB!\u0011\u0011FA\u0016\u001b\u0005Y\u0012bAA\u00177\ta\u0011+^3ss>\u0003H/[8og\"9\u0011\u0011\u0007\bA\u0002\u0005M\u0012aC3om&\u0014xN\\7f]R\u0004B!!\u000e\u0002<5\u0011\u0011q\u0007\u0006\u0004\u0003si\u0012aA3om&!\u0011QHA\u001c\u0005I\u0019E.^:uKJ,eN^5s_:lWM\u001c;\u0005\u000f\u0005\u0005cB1\u0001\u0002D\t\tA+\u0005\u0003\u0002F\u0005-\u0003cA\u0014\u0002H%\u0019\u0011\u0011\n\u0015\u0003\u000f9{G\u000f[5oOB\u0019q%!\u0014\n\u0007\u0005=\u0003FA\u0002B]f\fqbY8om\u0016\u0014HOU3ta>t7/\u001a\u000b\u0005\u0003+\nY\u0006\u0005\u0003\u0002*\u0005]\u0013bAA-7\t\u0019\"+Z1di&4X-U;fef\u0014Vm];mi\"9\u0011QL\bA\u0002\u0005}\u0013\u0001\u0003:fgB|gn]3\u0011\t\u0005M\u0011\u0011M\u0005\u0005\u0003G\n)BA\u0007Rk\u0016\u0014\u0018PU3ta>t7/Z\u0001\u000ecV,'/_%oi\u0016\u0014h.\u00197\u0015\u0011\u0005%\u0014QPA@\u0003\u0003\u0003b!a\u001b\u0002z\u0005}SBAA7\u0015\u0011\ty'!\u001d\u0002\u0013A,(\r\\5tQ\u0016\u0014(b\u0001\u0010\u0002t)\u0019q(!\u001e\u000b\u0005\u0005]\u0014a\u0002:fC\u000e$xN]\u0005\u0005\u0003w\niGA\u0003T\u001b>tw\u000eC\u0004\u0002\u0002A\u0001\r!!\u0005\t\u000f\u0005\u0015\u0002\u00031\u0001\u0002(!1\u00111\u0011\tA\u0002!\fQ!\u00193i_\u000e\fa#\\1zE\u0016\u0004&/\u001a9be\u0016\fe\u000eZ#yK\u000e,H/\u001a\u000b\u0007\u0003S\nI)a#\t\u000f\u0005\u0005\u0011\u00031\u0001\u0002\u0012!9\u0011QE\tA\u0002\u0005\u001d\u0012!D9vKJL(+Z1di&4X\r\u0006\u0004\u0002\u0012\u0006M\u0015Q\u0013\t\u0007\u0003W\nI(!\u0016\t\u000f\u0005\u0005!\u00031\u0001\u0002\u0012!9\u0011Q\u0005\nA\u0002\u0005\u001d\u0012a\u00052vS2$\u0007K]3qCJ,'+Z9vKN$HCBA\t\u00037\u000by\nC\u0004\u0002\u001eN\u0001\r!!\u0005\u0002\u0011=\u0014\u0018nZ5oC2Dq!!\n\u0014\u0001\u0004\t9#A\nck&dG-\u0012=fGV$XMU3rk\u0016\u001cH\u000f\u0006\u0005\u0002\u0012\u0005\u0015\u0016\u0011VAV\u0011\u0019\t9\u000b\u0006a\u0001E\u0006Q1-Y2iK\u0016sGO]=\t\u000f\u0005uE\u00031\u0001\u0002\u0012!9\u0011Q\u0016\u000bA\u0002\u0005\u001d\u0012aD8sS\u001eLg.\u00197PaRLwN\\:\u0002)\r\f7\r[3F]R\u0014\u0018p\u0015;jY24\u0016\r\\5e)\u0015A\u00171WA\\\u0011\u0019\t),\u0006a\u0001E\u0006)QM\u001c;ss\"1\u0011\u0011X\u000bA\u0002!\fq\"\u001a8iC:\u001cW\rZ#oC\ndW\r\u001a\u000b\t\u0003#\u000bi,a0\u0002B\"1\u0011\u0011\u0005\fA\u0002]Cq!!\n\u0017\u0001\u0004\t9\u0003C\u0004\u00022Y\u0001\r!a\r\u0002\u0015E,XM]=Bgft7\r\u0006\u0005\u0002H\u0006M\u0017Q[Al!\u0015\u0019\u0014\u0011ZAg\u0013\r\tY\r\u000e\u0002\u0007\rV$XO]3\u0011\t\u0005%\u0012qZ\u0005\u0004\u0003#\\\"aC)vKJL(+Z:vYRDa!!\t\u0018\u0001\u00049\u0006bBA\u0013/\u0001\u0007\u0011q\u0005\u0005\b\u0003c9\u0002\u0019AA\u001a\u0001")
public class QueryHandler {
    private final HandlerBasicParams hp;
    private final Core core;
    private final int QueryCacheSize;
    private final Map<String, QueryCacheEntry> queryCache;
    private volatile boolean enhancedPreparedEnabled;

    private Core core() {
        return this.core;
    }

    private int QueryCacheSize() {
        return this.QueryCacheSize;
    }

    private Map<String, QueryCacheEntry> queryCache() {
        return this.queryCache;
    }

    private boolean enhancedPreparedEnabled() {
        return this.enhancedPreparedEnabled;
    }

    private void enhancedPreparedEnabled_$eq(boolean x$1) {
        this.enhancedPreparedEnabled = x$1;
    }

    private void updateEnhancedPreparedEnabled(ClusterConfig config) {
        block0: {
            if (this.enhancedPreparedEnabled()) break block0;
            Set caps = (Set)config.clusterCapabilities().get(ServiceType.QUERY);
            this.enhancedPreparedEnabled_$eq(caps != null && caps.contains(ClusterCapabilities.ENHANCED_PREPARED_STATEMENTS));
        }
    }

    private <T> Try<QueryRequest> request(String statement, QueryOptions options, ClusterEnvironment environment) {
        Try try_;
        Try validations = Validate$.MODULE$.notNullOrEmpty(statement, "statement").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.notNull(options, "options").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.optNotNull(options.parameters(), "parameters").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.optNotNull(options.clientContextId(), "clientContextId").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.optNotNull(options.maxParallelism(), "maxParallelism").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.notNull(BoxesRunTime.boxToBoolean((boolean)options.metrics()), "metrics").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.optNotNull(options.pipelineBatch(), "pipelineBatch").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.optNotNull(options.pipelineCap(), "pipelineCap").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.optNotNull(options.profile(), "profile").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.optNotNull(options.readonly(), "readonly").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.optNotNull(options.retryStrategy(), "retryStrategy").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.optNotNull(options.scanCap(), "scanCap").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.optNotNull(options.scanConsistency(), "scanConsistency").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.optNotNull(options.timeout(), "timeout").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.optNotNull(options.parentSpan(), "parentSpan").map((Function1 & Serializable & scala.Serializable)_ -> null)))))))))))))));
        if (validations.isFailure()) {
            try_ = validations;
        } else {
            Failure failure;
            Option<RuntimeException> option = options.deferredException();
            if (option instanceof Some) {
                Some some = (Some)option;
                RuntimeException deferredException = (RuntimeException)some.value();
                failure = new Failure((Throwable)deferredException);
            } else {
                JsonObject params = options.encode();
                params.put("statement", statement);
                failure = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> JacksonTransformers.MAPPER.writeValueAsString((Object)params)).map((Function1 & Serializable & scala.Serializable)queryStr -> {
                    byte[] queryBytes = queryStr.getBytes(CharsetUtil.UTF_8);
                    Duration timeout = (Duration)options.timeout().getOrElse((Function0 & Serializable & scala.Serializable)() -> DurationConversions$.MODULE$.javaDurationToScala(environment.timeoutConfig().queryTimeout()));
                    RetryStrategy retryStrategy = (RetryStrategy)options.retryStrategy().getOrElse((Function0 & Serializable & scala.Serializable)() -> environment.retryStrategy());
                    QueryRequest request = new QueryRequest(DurationConversions$.MODULE$.scalaDurationToJava(timeout), this.core().context(), retryStrategy, this.core().context().authenticator(), statement, queryBytes, BoxesRunTime.unboxToBoolean((Object)options.readonly().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)), params.str("client_context_id"), $this.hp.tracer().internalSpan("query", (RequestSpan)options.parentSpan().orNull(Predef$.MODULE$.$conforms())));
                    return request;
                });
            }
            try_ = failure;
        }
        return try_;
    }

    private ReactiveQueryResult convertResponse(QueryResponse response) {
        SFlux rows = FutureConversions$.MODULE$.javaFluxToScalaFlux(response.rows());
        SMono meta = FutureConversions$.MODULE$.javaMonoToScalaMono(response.trailer()).map((Function1 & Serializable & scala.Serializable)addl -> {
            Seq warnings2 = (Seq)OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(addl.warnings())).map((Function1 & Serializable & scala.Serializable)warnings -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ErrorCodeAndMessage.fromJsonArray((byte[])warnings)).asScala()).map((Function1 & Serializable & scala.Serializable)warning -> new QueryWarning(warning.code(), warning.message()), Buffer$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
            String string = addl.status();
            QueryStatus queryStatus = "running".equals(string) ? QueryStatus$Running$.MODULE$ : ("success".equals(string) ? QueryStatus$Success$.MODULE$ : ("errors".equals(string) ? QueryStatus$Errors$.MODULE$ : ("completed".equals(string) ? QueryStatus$Completed$.MODULE$ : ("stopped".equals(string) ? QueryStatus$Stopped$.MODULE$ : ("timeout".equals(string) ? QueryStatus$Timeout$.MODULE$ : ("closed".equals(string) ? QueryStatus$Closed$.MODULE$ : ("fatal".equals(string) ? QueryStatus$Fatal$.MODULE$ : ("aborted".equals(string) ? QueryStatus$Aborted$.MODULE$ : QueryStatus$Unknown$.MODULE$))))))));
            QueryStatus$Running$ status = queryStatus;
            QueryMetaData out = new QueryMetaData(response.header().requestId(), (String)OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(response.header().clientContextId())).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(response.header().signature())), (Option<QueryMetrics>)OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(addl.metrics())).flatMap((Function1 & Serializable & scala.Serializable)in -> QueryMetrics$.MODULE$.fromBytes((byte[])in)), (Seq<QueryWarning>)warnings2, status, OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(addl.profile())));
            return out;
        });
        return new ReactiveQueryResult(rows, (SMono<QueryMetaData>)meta);
    }

    private SMono<QueryResponse> queryInternal(QueryRequest request, QueryOptions options, boolean adhoc) {
        return adhoc ? SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> {
            this.core().send((Request)request);
            return FutureConversions$.MODULE$.wrap((Request<? extends Response>)request, request.response(), true);
        }) : this.maybePrepareAndExecute(request, options);
    }

    private SMono<QueryResponse> maybePrepareAndExecute(QueryRequest request, QueryOptions options) {
        QueryCacheEntry cacheEntry = this.queryCache().get(request.statement());
        boolean enhancedEnabled = this.enhancedPreparedEnabled();
        return cacheEntry != null && this.cacheEntryStillValid(cacheEntry, enhancedEnabled) ? this.queryInternal(this.buildExecuteRequest(cacheEntry, request, options), options, true) : (enhancedEnabled ? this.queryInternal(this.buildPrepareRequest(request, options), options, true).flatMap((Function1 & Serializable & scala.Serializable)qr -> {
            SMono sMono;
            Optional preparedName = qr.header().prepared();
            if (!preparedName.isPresent()) {
                sMono = SMono$.MODULE$.raiseError((Throwable)new CouchbaseException("No prepared name present but must be, this is a query bug!"));
            } else {
                this.queryCache().put(request.statement(), new QueryCacheEntry((String)preparedName.get(), false, (Option<String>)None$.MODULE$));
                sMono = SMono$.MODULE$.just(qr);
            }
            return sMono;
        }) : SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> {
            QueryRequest req = this.buildPrepareRequest(request, options);
            this.core().send((Request)req);
            return FutureConversions$.MODULE$.wrap((Request<? extends Response>)req, req.response(), true);
        }).flatMapMany((Function1 & Serializable & scala.Serializable)result -> result.rows()).doOnNext((Function1 & Serializable & scala.Serializable)row -> {
            QueryHandler.$anonfun$maybePrepareAndExecute$4(this, enhancedEnabled, request, row);
            return BoxedUnit.UNIT;
        }).then().then(SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> this.maybePrepareAndExecute(request, options))).onErrorResume((Function1 & Serializable & scala.Serializable)err -> this.queryInternal(request, options, true)));
    }

    private SMono<ReactiveQueryResult> queryReactive(QueryRequest request, QueryOptions options) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> this.queryInternal(request, options, options.adhoc()).map((Function1 & Serializable & scala.Serializable)v -> this.convertResponse((QueryResponse)v)));
    }

    private QueryRequest buildPrepareRequest(QueryRequest original, QueryOptions options) {
        Object object;
        String statement = new StringBuilder(8).append("PREPARE ").append(original.statement()).toString();
        JsonObject query = JsonObject$.MODULE$.create();
        query.put("statement", statement);
        query.put("timeout", Golang.encodeDurationToMs((java.time.Duration)original.timeout()));
        if (this.enhancedPreparedEnabled()) {
            query.put("auto_execute", BoxesRunTime.boxToBoolean((boolean)true));
            object = options.encode(query);
        } else {
            object = BoxedUnit.UNIT;
        }
        return new QueryRequest(original.timeout(), (CoreContext)original.context(), original.retryStrategy(), original.credentials(), statement, query.toString().getBytes(StandardCharsets.UTF_8), true, query.str("client_context_id"), this.hp.tracer().internalSpan("query", (RequestSpan)options.parentSpan().orNull(Predef$.MODULE$.$conforms())));
    }

    private QueryRequest buildExecuteRequest(QueryCacheEntry cacheEntry, QueryRequest original, QueryOptions originalOptions) {
        JsonObject query = cacheEntry.export();
        query.put("timeout", Golang.encodeDurationToMs((java.time.Duration)original.timeout()));
        originalOptions.encode(query);
        return new QueryRequest(original.timeout(), (CoreContext)original.context(), original.retryStrategy(), original.credentials(), original.statement(), query.toString().getBytes(StandardCharsets.UTF_8), BoxesRunTime.unboxToBoolean((Object)originalOptions.readonly().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)), query.str("client_context_id"), this.hp.tracer().internalSpan("query", (RequestSpan)originalOptions.parentSpan().orNull(Predef$.MODULE$.$conforms())));
    }

    private boolean cacheEntryStillValid(QueryCacheEntry entry, boolean enhancedEnabled) {
        return enhancedEnabled && !entry.fullPlan() || !enhancedEnabled && entry.fullPlan();
    }

    public SMono<ReactiveQueryResult> queryReactive(String statement, QueryOptions options, ClusterEnvironment environment) {
        SMono sMono;
        Try<QueryRequest> try_ = this.request(statement, options, environment);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            QueryRequest req = (QueryRequest)success.value();
            sMono = this.queryReactive(req, options);
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            sMono = SMono$.MODULE$.raiseError(err);
        } else {
            throw new MatchError(try_);
        }
        return sMono;
    }

    public Future<QueryResult> queryAsync(String statement, QueryOptions options, ClusterEnvironment environment) {
        Future future;
        Try<QueryRequest> try_ = this.request(statement, options, environment);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            QueryRequest req = (QueryRequest)success.value();
            future = this.queryReactive(req, options).flatMap((Function1 & Serializable & scala.Serializable)response -> response.rows().collectSeq().flatMap((Function1 & Serializable & scala.Serializable)rows -> response.metaData().map((Function1 & Serializable & scala.Serializable)meta -> new QueryResult((Seq<QueryChunkRow>)rows, (QueryMetaData)meta)))).toFuture();
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            future = Future$.MODULE$.failed(err);
        } else {
            throw new MatchError(try_);
        }
        return future;
    }

    public static final /* synthetic */ void $anonfun$maybePrepareAndExecute$4(QueryHandler $this, boolean enhancedEnabled$1, QueryRequest request$2, QueryChunkRow row) {
        Try<JsonObjectSafe> json = JsonDeserializer$JsonObjectSafeConvert$.MODULE$.deserialize(row.data());
        Option nameOpt = json.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.str("name")).toOption();
        None$ plan = enhancedEnabled$1 ? None$.MODULE$ : json.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.str("encoded_plan")).toOption();
        Option option = nameOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            String name = (String)some.value();
            QueryCacheEntry entry = new QueryCacheEntry(name, !enhancedEnabled$1, (Option<String>)plan);
            $this.queryCache().put(request$2.statement(), entry);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public QueryHandler(HandlerBasicParams hp, ExecutionContext ec) {
        this.hp = hp;
        this.core = hp.core();
        this.QueryCacheSize = 5000;
        this.queryCache = Collections.synchronizedMap(new LRUCache(this.QueryCacheSize()));
        this.enhancedPreparedEnabled = false;
        this.updateEnhancedPreparedEnabled(this.core().clusterConfig());
        this.core().configurationProvider().configs().subscribe(config -> this.updateEnhancedPreparedEnabled((ClusterConfig)config));
    }
}

