/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.manager.search;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.DefaultFullHttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.FullHttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpHeaderNames;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpHeaderValues;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpVersion;
import com.couchbase.client.core.error.IndexNotFoundException;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.search.GenericSearchRequest;
import com.couchbase.client.core.msg.search.GenericSearchResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.UrlQueryStringBuilder;
import com.couchbase.client.scala.AsyncCluster;
import com.couchbase.client.scala.manager.search.AsyncSearchIndexManager$;
import com.couchbase.client.scala.manager.search.SearchIndex;
import com.couchbase.client.scala.manager.search.SearchIndexWrapper;
import com.couchbase.client.scala.manager.search.SearchIndexWrapper$;
import com.couchbase.client.scala.util.CouchbasePickler$;
import com.couchbase.client.scala.util.DurationConversions$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.Seq;
import scala.compat.java8.FutureConverters$;
import scala.compat.java8.FutureConverters$CompletionStageOps$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import ujson.Obj;
import ujson.Readable;
import ujson.Readable$;

@Stability.Volatile
@ScalaSignature(bytes="\u0006\u0001\tub\u0001B\u0012%\u0001EB\u0011b\u000e\u0001\u0003\u0006\u0004%\t\u0001\u000b\u001d\t\u0011u\u0002!\u0011!Q\u0001\neB\u0001B\u0010\u0001\u0003\u0006\u0004%\u0019a\u0010\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u0001\")q\t\u0001C\u0001\u0011\"9a\n\u0001b\u0001\n\u0013y\u0005BB+\u0001A\u0003%\u0001\u000bC\u0004W\u0001\t\u0007I\u0011B,\t\ry\u0003\u0001\u0015!\u0003Y\u0011\u001dy\u0006A1A\u0005\n\u0001Daa\u001a\u0001!\u0002\u0013\t\u0007\"\u00025\u0001\t\u0013I\u0007bBA\b\u0001\u0011\u0005\u0011\u0011\u0003\u0005\n\u0003S\u0001\u0011\u0013!C\u0001\u0003WA\u0011\"!\u0011\u0001#\u0003%\t!a\u0011\t\u000f\u0005\u001d\u0003\u0001\"\u0001\u0002J!I\u00111\r\u0001\u0012\u0002\u0013\u0005\u00111\u0006\u0005\n\u0003K\u0002\u0011\u0013!C\u0001\u0003\u0007Bq!a\u001a\u0001\t\u0003\tI\u0007C\u0005\u0002|\u0001\t\n\u0011\"\u0001\u0002,!I\u0011Q\u0010\u0001\u0012\u0002\u0013\u0005\u00111\t\u0005\b\u0003\u007f\u0002A\u0011AAA\u0011%\tI\tAI\u0001\n\u0003\tY\u0003C\u0005\u0002\f\u0002\t\n\u0011\"\u0001\u0002D!9\u0011Q\u0012\u0001\u0005\n\u0005=\u0005bBAP\u0001\u0011%\u0011\u0011\u0015\u0005\b\u0003K\u0003A\u0011BAT\u0011\u001d\tY\u000b\u0001C\u0005\u0003[Cq!!0\u0001\t\u0013\ty\fC\u0004\u0002>\u0002!I!!<\b\u000f\t\u0005B\u0005#\u0001\u0003$\u001911\u0005\nE\u0001\u0005KAaa\u0012\u0011\u0005\u0002\t\u001d\u0002\u0002\u0003B\u0015A\u0011\u0005\u0001Fa\u000b\u0003/\u0005\u001b\u0018P\\2TK\u0006\u00148\r[%oI\u0016DX*\u00198bO\u0016\u0014(BA\u0013'\u0003\u0019\u0019X-\u0019:dQ*\u0011q\u0005K\u0001\b[\u0006t\u0017mZ3s\u0015\tI#&A\u0003tG\u0006d\u0017M\u0003\u0002,Y\u000511\r\\5f]RT!!\f\u0018\u0002\u0013\r|Wo\u00195cCN,'\"A\u0018\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001\u0011\u0004CA\u001a6\u001b\u0005!$\"A\u0015\n\u0005Y\"$AB!osJ+g-A\u0004dYV\u001cH/\u001a:\u0016\u0003e\u0002\"AO\u001e\u000e\u0003!J!\u0001\u0010\u0015\u0003\u0019\u0005\u001b\u0018P\\2DYV\u001cH/\u001a:\u0002\u0011\rdWo\u001d;fe\u0002\n!!Z2\u0016\u0003\u0001\u0003\"!\u0011#\u000e\u0003\tS!a\u0011\u001b\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002F\u0005\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0004K\u000e\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002J\u001bR\u0011!\n\u0014\t\u0003\u0017\u0002i\u0011\u0001\n\u0005\u0006}\u0015\u0001\u001d\u0001\u0011\u0005\u0006o\u0015\u0001\r!O\u0001\u0005G>\u0014X-F\u0001Q!\t\t6+D\u0001S\u0015\tq%&\u0003\u0002U%\n!1i\u001c:f\u0003\u0015\u0019wN]3!\u00039!UMZ1vYR$\u0016.\\3pkR,\u0012\u0001\u0017\t\u00033rk\u0011A\u0017\u0006\u00037\n\u000b\u0001\u0002Z;sCRLwN\\\u0005\u0003;j\u0013\u0001\u0002R;sCRLwN\\\u0001\u0010\t\u00164\u0017-\u001e7u)&lWm\\;uA\u0005!B)\u001a4bk2$(+\u001a;ssN#(/\u0019;fOf,\u0012!\u0019\t\u0003E\u0016l\u0011a\u0019\u0006\u0003IJ\u000bQA]3uefL!AZ2\u0003\u001bI+GO]=TiJ\fG/Z4z\u0003U!UMZ1vYR\u0014V\r\u001e:z'R\u0014\u0018\r^3hs\u0002\n1\u0002\u001e:b]N4wN]7feR\u0011!N\u001f\t\u0005g-lW.\u0003\u0002mi\tIa)\u001e8di&|g.\r\t\u0004]F\u001cX\"A8\u000b\u0005A$\u0014\u0001B;uS2L!A]8\u0003\u0007Q\u0013\u0018\u0010\u0005\u0002uq6\tQO\u0003\u0002&m*\u0011qOU\u0001\u0004[N<\u0017BA=v\u0005U9UM\\3sS\u000e\u001cV-\u0019:dQJ+7\u000f]8og\u0016DQa\u001f\u0007A\u0002q\f\u0011\"\u001b8eKbt\u0015-\\3\u0011\u0007u\fIAD\u0002\u007f\u0003\u000b\u0001\"a \u001b\u000e\u0005\u0005\u0005!bAA\u0002a\u00051AH]8pizJ1!a\u00025\u0003\u0019\u0001&/\u001a3fM&!\u00111BA\u0007\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u0001\u001b\u0002\u0011\u001d,G/\u00138eKb$\u0002\"a\u0005\u0002 \u0005\u0005\u0012Q\u0005\t\u0006\u0003\u0006U\u0011\u0011D\u0005\u0004\u0003/\u0011%A\u0002$viV\u0014X\rE\u0002L\u00037I1!!\b%\u0005-\u0019V-\u0019:dQ&sG-\u001a=\t\u000bml\u0001\u0019\u0001?\t\u0011\u0005\rR\u0002%AA\u0002a\u000bq\u0001^5nK>,H\u000f\u0003\u0005\u0002(5\u0001\n\u00111\u0001b\u00035\u0011X\r\u001e:z'R\u0014\u0018\r^3hs\u0006\u0011r-\u001a;J]\u0012,\u0007\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tiCK\u0002Y\u0003_Y#!!\r\u0011\t\u0005M\u0012QH\u0007\u0003\u0003kQA!a\u000e\u0002:\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003w!\u0014AC1o]>$\u0018\r^5p]&!\u0011qHA\u001b\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0013O\u0016$\u0018J\u001c3fq\u0012\"WMZ1vYR$3'\u0006\u0002\u0002F)\u001a\u0011-a\f\u0002\u001b\u001d,G/\u00117m\u0013:$W\r_3t)\u0019\tY%a\u0018\u0002bA)\u0011)!\u0006\u0002NA1\u0011qJA-\u00033qA!!\u0015\u0002V9\u0019q0a\u0015\n\u0003%J1!a\u00165\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0017\u0002^\t\u00191+Z9\u000b\u0007\u0005]C\u0007\u0003\u0005\u0002$A\u0001\n\u00111\u0001Y\u0011!\t9\u0003\u0005I\u0001\u0002\u0004\t\u0017aF4fi\u0006cG.\u00138eKb,7\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0003]9W\r^!mY&sG-\u001a=fg\u0012\"WMZ1vYR$#'A\u0006vaN,'\u000f^%oI\u0016DH\u0003CA6\u0003g\n9(!\u001f\u0011\u000b\u0005\u000b)\"!\u001c\u0011\u0007M\ny'C\u0002\u0002rQ\u0012A!\u00168ji\"9\u0011QO\nA\u0002\u0005e\u0011aD5oI\u0016DH)\u001a4j]&$\u0018n\u001c8\t\u0011\u0005\r2\u0003%AA\u0002aC\u0001\"a\n\u0014!\u0003\u0005\r!Y\u0001\u0016kB\u001cXM\u001d;J]\u0012,\u0007\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0003U)\bo]3si&sG-\u001a=%I\u00164\u0017-\u001e7uIM\n\u0011\u0002\u001a:pa&sG-\u001a=\u0015\u0011\u0005-\u00141QAC\u0003\u000fCQa\u001f\fA\u0002qD\u0001\"a\t\u0017!\u0003\u0005\r\u0001\u0017\u0005\t\u0003O1\u0002\u0013!a\u0001C\u0006\u0019BM]8q\u0013:$W\r\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005\u0019BM]8q\u0013:$W\r\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005Y\u0011N\u001c3fq\u0016\u001c\b+\u0019;i+\t\t\t\n\u0005\u0003\u0002\u0014\u0006uUBAAK\u0015\u0011\t9*!'\u0002\t1\fgn\u001a\u0006\u0003\u00037\u000bAA[1wC&!\u00111BAK\u0003%Ig\u000eZ3y!\u0006$\b\u000e\u0006\u0003\u0002\u0012\u0006\r\u0006\"B>\u001b\u0001\u0004a\u0018AD5oI\u0016D8i\\;oiB\u000bG\u000f\u001b\u000b\u0005\u0003#\u000bI\u000bC\u0003|7\u0001\u0007A0A\bhKRLe\u000eZ3y%\u0016\fX/Z:u)!\ty+!.\u0002:\u0006m\u0006c\u0001;\u00022&\u0019\u00111W;\u0003)\u001d+g.\u001a:jGN+\u0017M]2i%\u0016\fX/Z:u\u0011\u0019\t9\f\ba\u0001y\u0006!a.Y7f\u0011\u0019\t\u0019\u0003\ba\u00011\"1\u0011q\u0005\u000fA\u0002\u0005\fQb]3be\u000eD'+Z9vKN$HCCAX\u0003\u0003\f)/!;\u0002l\"9\u00111Y\u000fA\u0002\u0005\u0015\u0017AB7fi\"|G\r\u0005\u0003\u0002H\u0006\u0005XBAAe\u0015\u0011\tY-!4\u0002\t!$H\u000f\u001d\u0006\u0005\u0003\u001f\f\t.A\u0003d_\u0012,7M\u0003\u0003\u0002T\u0006U\u0017a\u00025b]\u0012dWM\u001d\u0006\u0005\u0003/\fI.A\u0003oKR$\u0018P\u0003\u0003\u0002\\\u0006u\u0017AA5p\u0015\r\tyNU\u0001\u0005I\u0016\u00048/\u0003\u0003\u0002d\u0006%'A\u0003%uiBlU\r\u001e5pI\"1\u0011q]\u000fA\u0002q\fA\u0001]1uQ\"1\u00111E\u000fA\u0002aCa!a\n\u001e\u0001\u0004\tGCCAX\u0003_\fyP!\u0003\u0003\f!A\u0011\u0011\u001f\u0010\u0005\u0002\u0004\t\u00190A\u0006iiR\u0004(+Z9vKN$\b#B\u001a\u0002v\u0006e\u0018bAA|i\tAAHY=oC6,g\b\u0005\u0003\u0002H\u0006m\u0018\u0002BA\u007f\u0003\u0013\u0014qBR;mY\"#H\u000f\u001d*fcV,7\u000f\u001e\u0005\b\u0005\u0003q\u0002\u0019\u0001B\u0002\u0003)IG-Z7q_R,g\u000e\u001e\t\u0004g\t\u0015\u0011b\u0001B\u0004i\t9!i\\8mK\u0006t\u0007BBA\u0012=\u0001\u0007\u0001\f\u0003\u0004\u0002(y\u0001\r!\u0019\u0015\u0004\u0001\t=\u0001\u0003\u0002B\t\u00057qAAa\u0005\u0003\u00185\u0011!Q\u0003\u0006\u0004\u0003w\u0011\u0016\u0002\u0002B\r\u0005+\t\u0011b\u0015;bE&d\u0017\u000e^=\n\t\tu!q\u0004\u0002\t->d\u0017\r^5mK*!!\u0011\u0004B\u000b\u0003]\t5/\u001f8d'\u0016\f'o\u00195J]\u0012,\u00070T1oC\u001e,'\u000f\u0005\u0002LAM\u0011\u0001E\r\u000b\u0003\u0005G\tA\u0002]1sg\u0016Le\u000eZ3yKN$B!!\u0014\u0003.!9!q\u0006\u0012A\u0002\tE\u0012AA5o!\u0015\u0019$1\u0007B\u001c\u0013\r\u0011)\u0004\u000e\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004g\te\u0012b\u0001B\u001ei\t!!)\u001f;f\u0001")
public class AsyncSearchIndexManager {
    private final AsyncCluster cluster;
    private final ExecutionContext ec;
    private final Core core;
    private final Duration DefaultTimeout;
    private final RetryStrategy DefaultRetryStrategy;

    public AsyncCluster cluster() {
        return this.cluster;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    private Core core() {
        return this.core;
    }

    private Duration DefaultTimeout() {
        return this.DefaultTimeout;
    }

    private RetryStrategy DefaultRetryStrategy() {
        return this.DefaultRetryStrategy;
    }

    private Function1<Try<GenericSearchResponse>, Try<GenericSearchResponse>> transformer(String indexName) {
        return (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Success success;
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                Success success2;
                success = success2 = (Success)try_;
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                success = err.getMessage().contains("index not found") ? new Failure((Throwable)new IndexNotFoundException(indexName)) : new Failure(err);
            } else {
                throw new MatchError((Object)try_);
            }
            return success;
        };
    }

    public Future<SearchIndex> getIndex(String indexName, Duration timeout, RetryStrategy retryStrategy) {
        GenericSearchRequest request = this.getIndexRequest(indexName, timeout, retryStrategy);
        this.core().send((Request)request);
        Future out = FutureConverters$CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(request.response())).map((Function1 & Serializable & scala.Serializable)response -> {
            SearchIndexWrapper read = CouchbasePickler$.MODULE$.read((Readable)Readable$.MODULE$.fromByteArray(response.content()), SearchIndexWrapper$.MODULE$.rw());
            int x$1 = read.numPlanPIndexes();
            String x$2 = read.indexDef().copy$default$1();
            String x$3 = read.indexDef().copy$default$2();
            Option<String> x$4 = read.indexDef().copy$default$3();
            Option<String> x$5 = read.indexDef().copy$default$4();
            Option<Obj> x$6 = read.indexDef().copy$default$5();
            Option<String> x$7 = read.indexDef().copy$default$6();
            Option<Obj> x$8 = read.indexDef().copy$default$7();
            Option<String> x$9 = read.indexDef().copy$default$8();
            Option<Obj> x$10 = read.indexDef().copy$default$9();
            return read.indexDef().copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$1);
        }, this.ec()).transform((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Success success;
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                Success success2;
                success = success2 = (Success)try_;
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                success = err.getMessage().contains("index not found") ? new Failure((Throwable)new IndexNotFoundException(indexName)) : new Failure(err);
            } else {
                throw new MatchError((Object)try_);
            }
            return success;
        }, this.ec());
        out.onComplete((Function1 & Serializable & scala.Serializable)x$1 -> request.context().logicallyComplete(), this.ec());
        return out;
    }

    public Duration getIndex$default$2() {
        return this.DefaultTimeout();
    }

    public RetryStrategy getIndex$default$3() {
        return this.DefaultRetryStrategy();
    }

    public Future<Seq<SearchIndex>> getAllIndexes(Duration timeout, RetryStrategy retryStrategy) {
        GenericSearchRequest request = this.searchRequest(HttpMethod.GET, this.indexesPath(), timeout, retryStrategy);
        this.core().send((Request)request);
        Future out = FutureConverters$CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(request.response())).map((Function1 & Serializable & scala.Serializable)response -> AsyncSearchIndexManager$.MODULE$.parseIndexes(response.content()), this.ec());
        out.onComplete((Function1 & Serializable & scala.Serializable)x$2 -> request.context().logicallyComplete(), this.ec());
        return out;
    }

    public Duration getAllIndexes$default$1() {
        return this.DefaultTimeout();
    }

    public RetryStrategy getAllIndexes$default$2() {
        return this.DefaultRetryStrategy();
    }

    public Future<BoxedUnit> upsertIndex(SearchIndex indexDefinition, Duration timeout, RetryStrategy retryStrategy) {
        ByteBuf payload = Unpooled.wrappedBuffer((byte[])indexDefinition.toJson().getBytes(StandardCharsets.UTF_8));
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.PUT, this.indexPath(indexDefinition.name()), payload);
        request.headers().set((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)"no-cache");
        request.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON);
        request.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)BoxesRunTime.boxToInteger((int)payload.readableBytes()));
        DefaultFullHttpRequest req = request;
        GenericSearchRequest request2 = this.searchRequest((Function0<FullHttpRequest>)(Function0 & Serializable & scala.Serializable)() -> req, false, timeout, retryStrategy);
        this.core().send((Request)request2);
        Future out = FutureConverters$CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(request2.response())).transform(this.transformer(indexDefinition.name()), this.ec());
        out.onComplete((Function1 & Serializable & scala.Serializable)x$3 -> request2.context().logicallyComplete(), this.ec());
        return out.map((Function1 & Serializable & scala.Serializable)x$4 -> {
            AsyncSearchIndexManager.$anonfun$upsertIndex$3(x$4);
            return BoxedUnit.UNIT;
        }, this.ec());
    }

    public Duration upsertIndex$default$2() {
        return this.DefaultTimeout();
    }

    public RetryStrategy upsertIndex$default$3() {
        return this.DefaultRetryStrategy();
    }

    public Future<BoxedUnit> dropIndex(String indexName, Duration timeout, RetryStrategy retryStrategy) {
        GenericSearchRequest request = this.searchRequest(HttpMethod.DELETE, this.indexPath(indexName), timeout, retryStrategy);
        this.core().send((Request)request);
        Future out = FutureConverters$CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(request.response()));
        out.onComplete((Function1 & Serializable & scala.Serializable)x$5 -> request.context().logicallyComplete(), this.ec());
        return out.transform(this.transformer(indexName), this.ec()).map((Function1 & Serializable & scala.Serializable)x$6 -> {
            AsyncSearchIndexManager.$anonfun$dropIndex$2(x$6);
            return BoxedUnit.UNIT;
        }, this.ec());
    }

    public Duration dropIndex$default$2() {
        return this.DefaultTimeout();
    }

    public RetryStrategy dropIndex$default$3() {
        return this.DefaultRetryStrategy();
    }

    private String indexesPath() {
        return "/api/index";
    }

    private String indexPath(String indexName) {
        return new StringBuilder(1).append(this.indexesPath()).append("/").append(UrlQueryStringBuilder.urlEncode((String)indexName)).toString();
    }

    private String indexCountPath(String indexName) {
        return new StringBuilder(6).append(this.indexPath(indexName)).append("/count").toString();
    }

    private GenericSearchRequest getIndexRequest(String name, Duration timeout, RetryStrategy retryStrategy) {
        return this.searchRequest(HttpMethod.GET, this.indexPath(name), timeout, retryStrategy);
    }

    private GenericSearchRequest searchRequest(HttpMethod method, String path, Duration timeout, RetryStrategy retryStrategy) {
        HttpMethod httpMethod = method;
        HttpMethod httpMethod2 = HttpMethod.GET;
        return this.searchRequest((Function0<FullHttpRequest>)(Function0 & Serializable & scala.Serializable)() -> new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, path), !(httpMethod != null ? !httpMethod.equals(httpMethod2) : httpMethod2 != null), timeout, retryStrategy);
    }

    private GenericSearchRequest searchRequest(Function0<FullHttpRequest> httpRequest, boolean idempotent, Duration timeout, RetryStrategy retryStrategy) {
        return new GenericSearchRequest(DurationConversions$.MODULE$.scalaDurationToJava(timeout), this.core().context(), retryStrategy, () -> (FullHttpRequest)httpRequest.apply(), idempotent);
    }

    public static final /* synthetic */ void $anonfun$upsertIndex$3(GenericSearchResponse x$4) {
    }

    public static final /* synthetic */ void $anonfun$dropIndex$2(GenericSearchResponse x$6) {
    }

    public AsyncSearchIndexManager(AsyncCluster cluster, ExecutionContext ec) {
        this.cluster = cluster;
        this.ec = ec;
        this.core = cluster.core();
        this.DefaultTimeout = DurationConversions$.MODULE$.javaDurationToScala(this.core().context().environment().timeoutConfig().managementTimeout());
        this.DefaultRetryStrategy = this.core().context().environment().retryStrategy();
    }
}

