/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.manager.bucket;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.core.error.BucketExistsException;
import com.couchbase.client.core.error.BucketNotFoundException;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.manager.GenericManagerResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.UrlQueryStringBuilder;
import com.couchbase.client.scala.manager.ManagerUtil$;
import com.couchbase.client.scala.manager.bucket.BucketSettings;
import com.couchbase.client.scala.manager.bucket.BucketSettings$;
import com.couchbase.client.scala.manager.bucket.CreateBucketSettings;
import com.couchbase.client.scala.util.CouchbasePickler$;
import com.couchbase.client.scala.util.DurationConversions$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Try;
import ujson.Readable;
import ujson.Readable$;

@Stability.Volatile
@ScalaSignature(bytes="\u0006\u0001\u0005Ug\u0001\u0002\u0010 \u00011B\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\u0006q\u0001!\t!\u000f\u0005\t{\u0001\u0011\r\u0011\"\u0001$}!1q\t\u0001Q\u0001\n}B\u0001\u0002\u0013\u0001C\u0002\u0013\u00051%\u0013\u0005\u0007!\u0002\u0001\u000b\u0011\u0002&\t\u000bE\u0003A\u0011\u0002*\t\u000be\u0003A\u0011\u0002.\t\u000b\u001d\u0004A\u0011\u00025\t\u000b)\u0004A\u0011A6\t\u0013\u0005M\u0001!%A\u0005\u0002\u0005U\u0001\"CA\u0016\u0001E\u0005I\u0011AA\u0017\u0011\u001d\t\t\u0004\u0001C\u0005\u0003gAq!!\u0013\u0001\t\u0003\tY\u0005C\u0005\u0002T\u0001\t\n\u0011\"\u0001\u0002\u0016!I\u0011Q\u000b\u0001\u0012\u0002\u0013\u0005\u0011Q\u0006\u0005\b\u0003/\u0002A\u0011BA-\u0011\u001d\tY\u0007\u0001C\u0001\u0003[B\u0011\"!\u001e\u0001#\u0003%\t!!\u0006\t\u0013\u0005]\u0004!%A\u0005\u0002\u00055\u0002bBA=\u0001\u0011\u0005\u00111\u0010\u0005\n\u0003\u0017\u0003\u0011\u0013!C\u0001\u0003+A\u0011\"!$\u0001#\u0003%\t!!\f\t\u000f\u0005=\u0005\u0001\"\u0001\u0002\u0012\"I\u0011Q\u0014\u0001\u0012\u0002\u0013\u0005\u0011Q\u0003\u0005\n\u0003?\u0003\u0011\u0013!C\u0001\u0003[Aq!!)\u0001\t\u0003\t\u0019\u000bC\u0005\u0002,\u0002\t\n\u0011\"\u0001\u0002\u0016!I\u0011Q\u0016\u0001\u0012\u0002\u0013\u0005\u0011Q\u0006\u0002\u0016%\u0016\f7\r^5wK\n+8m[3u\u001b\u0006t\u0017mZ3s\u0015\t\u0001\u0013%\u0001\u0004ck\u000e\\W\r\u001e\u0006\u0003E\r\nq!\\1oC\u001e,'O\u0003\u0002%K\u0005)1oY1mC*\u0011aeJ\u0001\u0007G2LWM\u001c;\u000b\u0005!J\u0013!C2pk\u000eD'-Y:f\u0015\u0005Q\u0013aA2p[\u000e\u00011C\u0001\u0001.!\tq\u0003'D\u00010\u0015\u0005!\u0013BA\u00190\u0005\u0019\te.\u001f*fM\u0006!1m\u001c:f!\t!d'D\u00016\u0015\t\u0011T%\u0003\u00028k\t!1i\u001c:f\u0003\u0019a\u0014N\\5u}Q\u0011!\b\u0010\t\u0003w\u0001i\u0011a\b\u0005\u0006e\t\u0001\raM\u0001\u0016I\u00164\u0017-\u001e7u\u001b\u0006t\u0017mZ3s)&lWm\\;u+\u0005y\u0004C\u0001!F\u001b\u0005\t%B\u0001\"D\u0003\u0011!\u0018.\\3\u000b\u0003\u0011\u000bAA[1wC&\u0011a)\u0011\u0002\t\tV\u0014\u0018\r^5p]\u00061B-\u001a4bk2$X*\u00198bO\u0016\u0014H+[7f_V$\b%\u0001\u000beK\u001a\fW\u000f\u001c;SKR\u0014\u0018p\u0015;sCR,w-_\u000b\u0002\u0015B\u00111JT\u0007\u0002\u0019*\u0011Q*N\u0001\u0006e\u0016$(/_\u0005\u0003\u001f2\u0013QBU3uef\u001cFO]1uK\u001eL\u0018!\u00063fM\u0006,H\u000e\u001e*fiJL8\u000b\u001e:bi\u0016<\u0017\u0010I\u0001\u000fa\u0006$\bNR8s\u0005V\u001c7.\u001a;t+\u0005\u0019\u0006C\u0001+X\u001b\u0005)&B\u0001,D\u0003\u0011a\u0017M\\4\n\u0005a+&AB*ue&tw-A\u0007qCRDgi\u001c:Ck\u000e\\W\r\u001e\u000b\u0003'nCQ\u0001\u0018\u0005A\u0002u\u000b!BY;dW\u0016$h*Y7f!\tqVM\u0004\u0002`GB\u0011\u0001mL\u0007\u0002C*\u0011!mK\u0001\u0007yI|w\u000e\u001e \n\u0005\u0011|\u0013A\u0002)sK\u0012,g-\u0003\u0002YM*\u0011AmL\u0001\u0013a\u0006$\bNR8s\u0005V\u001c7.\u001a;GYV\u001c\b\u000e\u0006\u0002TS\")A,\u0003a\u0001;\u000611M]3bi\u0016$R\u0001\\=\u007f\u0003\u001f\u00012!\u001c;w\u001b\u0005q'BA8q\u0003%\u0001XO\u00197jg\",'O\u0003\u0002%c*\u0011!G\u001d\u0006\u0002g\u00069!/Z1di>\u0014\u0018BA;o\u0005\u0015\u0019Vj\u001c8p!\tqs/\u0003\u0002y_\t!QK\\5u\u0011\u0015Q(\u00021\u0001|\u0003!\u0019X\r\u001e;j]\u001e\u001c\bCA\u001e}\u0013\tixD\u0001\u000bDe\u0016\fG/\u001a\"vG.,GoU3ui&twm\u001d\u0005\t\u007f*\u0001\n\u00111\u0001\u0002\u0002\u00059A/[7f_V$\b\u0003BA\u0002\u0003\u001bi!!!\u0002\u000b\t\u0005\u001d\u0011\u0011B\u0001\tIV\u0014\u0018\r^5p]*\u0019\u00111B\u0018\u0002\u0015\r|gnY;se\u0016tG/C\u0002G\u0003\u000bA\u0001\"!\u0005\u000b!\u0003\u0005\rAS\u0001\u000ee\u0016$(/_*ue\u0006$XmZ=\u0002!\r\u0014X-\u0019;fI\u0011,g-Y;mi\u0012\u0012TCAA\fU\u0011\t\t!!\u0007,\u0005\u0005m\u0001\u0003BA\u000f\u0003Oi!!a\b\u000b\t\u0005\u0005\u00121E\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\n0\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003S\tyBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0001c\u0019:fCR,G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005=\"f\u0001&\u0002\u001a\u0005A2M]3bi\u0016,\u0006\u000fZ1uK\n+8m[3u'\"\f'/\u001a3\u0015\u00171\f)$a\u000e\u0002<\u0005u\u0012q\b\u0005\u0006u6\u0001\ra\u001f\u0005\u0007\u0003si\u0001\u0019A/\u0002\tA\fG\u000f\u001b\u0005\u0007\u007f6\u0001\r!!\u0001\t\r\u0005EQ\u00021\u0001K\u0011\u001d\t\t%\u0004a\u0001\u0003\u0007\na!\u001e9eCR,\u0007c\u0001\u0018\u0002F%\u0019\u0011qI\u0018\u0003\u000f\t{w\u000e\\3b]\u0006aQ\u000f\u001d3bi\u0016\u0014UoY6fiR9A.!\u0014\u0002P\u0005E\u0003\"\u0002>\u000f\u0001\u0004Y\b\u0002C@\u000f!\u0003\u0005\r!!\u0001\t\u0011\u0005Ea\u0002%AA\u0002)\u000ba#\u001e9eCR,')^2lKR$C-\u001a4bk2$HEM\u0001\u0017kB$\u0017\r^3Ck\u000e\\W\r\u001e\u0013eK\u001a\fW\u000f\u001c;%g\u000592m\u001c8wKJ$8+\u001a;uS:<7\u000fV8QCJ\fWn\u001d\u000b\u0007\u00037\n9'!\u001b\u0011\t\u0005u\u00131M\u0007\u0003\u0003?R1!!\u00196\u0003\u0011)H/\u001b7\n\t\u0005\u0015\u0014q\f\u0002\u0016+Jd\u0017+^3ssN#(/\u001b8h\u0005VLG\u000eZ3s\u0011\u0015Q\u0018\u00031\u0001|\u0011\u001d\t\t%\u0005a\u0001\u0003\u0007\n!\u0002\u001a:pa\n+8m[3u)\u001da\u0017qNA9\u0003gBQ\u0001\u0018\nA\u0002uC\u0001b \n\u0011\u0002\u0003\u0007\u0011\u0011\u0001\u0005\t\u0003#\u0011\u0002\u0013!a\u0001\u0015\u0006!BM]8q\u0005V\u001c7.\u001a;%I\u00164\u0017-\u001e7uII\nA\u0003\u001a:pa\n+8m[3uI\u0011,g-Y;mi\u0012\u001a\u0014!C4fi\n+8m[3u)!\ti(!\"\u0002\b\u0006%\u0005\u0003B7u\u0003\u007f\u00022aOAA\u0013\r\t\u0019i\b\u0002\u000f\u0005V\u001c7.\u001a;TKR$\u0018N\\4t\u0011\u0015aV\u00031\u0001^\u0011!yX\u0003%AA\u0002\u0005\u0005\u0001\u0002CA\t+A\u0005\t\u0019\u0001&\u0002'\u001d,GOQ;dW\u0016$H\u0005Z3gCVdG\u000f\n\u001a\u0002'\u001d,GOQ;dW\u0016$H\u0005Z3gCVdG\u000fJ\u001a\u0002\u001b\u001d,G/\u00117m\u0005V\u001c7.\u001a;t)\u0019\t\u0019*!'\u0002\u001cB)Q.!&\u0002\u0000%\u0019\u0011q\u00138\u0003\u000bM3E.\u001e=\t\u0011}D\u0002\u0013!a\u0001\u0003\u0003A\u0001\"!\u0005\u0019!\u0003\u0005\rAS\u0001\u0018O\u0016$\u0018\t\u001c7Ck\u000e\\W\r^:%I\u00164\u0017-\u001e7uIE\nqcZ3u\u00032d')^2lKR\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0002\u0017\u0019dWo\u001d5Ck\u000e\\W\r\u001e\u000b\bY\u0006\u0015\u0016qUAU\u0011\u0015a6\u00041\u0001^\u0011!y8\u0004%AA\u0002\u0005\u0005\u0001\u0002CA\t7A\u0005\t\u0019\u0001&\u0002+\u0019dWo\u001d5Ck\u000e\\W\r\u001e\u0013eK\u001a\fW\u000f\u001c;%e\u0005)b\r\\;tQ\n+8m[3uI\u0011,g-Y;mi\u0012\u001a\u0004f\u0001\u0001\u00022B!\u00111WAh\u001d\u0011\t),!3\u000f\t\u0005]\u0016q\u0019\b\u0005\u0003s\u000b)M\u0004\u0003\u0002<\u0006\rg\u0002BA_\u0003\u0003t1\u0001YA`\u0013\u0005Q\u0013B\u0001\u0015*\u0013\t1s%\u0003\u00023K%\u0019\u0011QE\u001b\n\t\u0005-\u0017QZ\u0001\n'R\f'-\u001b7jifT1!!\n6\u0013\u0011\t\t.a5\u0003\u0011Y{G.\u0019;jY\u0016TA!a3\u0002N\u0002")
public class ReactiveBucketManager {
    private final Core core;
    private final java.time.Duration defaultManagerTimeout;
    private final RetryStrategy defaultRetryStrategy;

    public java.time.Duration defaultManagerTimeout() {
        return this.defaultManagerTimeout;
    }

    public RetryStrategy defaultRetryStrategy() {
        return this.defaultRetryStrategy;
    }

    private String pathForBuckets() {
        return "/pools/default/buckets/";
    }

    private String pathForBucket(String bucketName) {
        return new StringBuilder(0).append(this.pathForBuckets()).append(UrlQueryStringBuilder.urlEncode((String)bucketName)).toString();
    }

    private String pathForBucketFlush(String bucketName) {
        return new StringBuilder(42).append("/pools/default/buckets/").append(UrlQueryStringBuilder.urlEncode((String)bucketName)).append("/controller/doFlush").toString();
    }

    public SMono<BoxedUnit> create(CreateBucketSettings settings, Duration timeout, RetryStrategy retryStrategy) {
        return this.createUpdateBucketShared(settings, this.pathForBuckets(), timeout, retryStrategy, false);
    }

    public Duration create$default$2() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy create$default$3() {
        return this.defaultRetryStrategy();
    }

    private SMono<BoxedUnit> createUpdateBucketShared(CreateBucketSettings settings, String path, Duration timeout, RetryStrategy retryStrategy, boolean update) {
        UrlQueryStringBuilder params = this.convertSettingsToParams(settings, update);
        return ManagerUtil$.MODULE$.sendRequest(this.core, HttpMethod.POST, path, params, timeout, retryStrategy).flatMap((Function1 & Serializable & scala.Serializable)response -> {
            SMono sMono;
            ResponseStatus responseStatus = response.status();
            ResponseStatus responseStatus2 = ResponseStatus.INVALID_ARGS;
            if (!(responseStatus != null ? !responseStatus.equals(responseStatus2) : responseStatus2 != null) && response.content() != null) {
                String content = new String(response.content(), StandardCharsets.UTF_8);
                sMono = content.contains("Bucket with given name already exists") ? SMono$.MODULE$.raiseError((Throwable)BucketExistsException.forBucket((String)settings.name())) : SMono$.MODULE$.raiseError((Throwable)new CouchbaseException(content));
            } else {
                SMono sMono2;
                Try<BoxedUnit> try_ = ManagerUtil$.MODULE$.checkStatus((GenericManagerResponse)response, new StringBuilder(16).append("create bucket [").append(RedactableArgument.redactMeta((Object)settings)).append("]").toString());
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable err = failure.exception();
                    sMono2 = SMono$.MODULE$.raiseError(err);
                } else {
                    sMono2 = SMono$.MODULE$.just((Object)BoxedUnit.UNIT);
                }
                sMono = sMono2;
            }
            return sMono;
        });
    }

    public SMono<BoxedUnit> updateBucket(CreateBucketSettings settings, Duration timeout, RetryStrategy retryStrategy) {
        return this.getAllBuckets(timeout, retryStrategy).collectSeq().map((Function1 & Serializable & scala.Serializable)buckets -> BoxesRunTime.boxToBoolean((boolean)buckets.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ReactiveBucketManager.$anonfun$updateBucket$2(settings$2, x$1))))).flatMap((Function1 & Serializable & scala.Serializable)bucketExists -> this.createUpdateBucketShared(settings, this.pathForBucket(settings.name()), timeout, retryStrategy, BoxesRunTime.unboxToBoolean((Object)bucketExists)));
    }

    public Duration updateBucket$default$2() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy updateBucket$default$3() {
        return this.defaultRetryStrategy();
    }

    /*
     * WARNING - void declaration
     */
    private UrlQueryStringBuilder convertSettingsToParams(CreateBucketSettings settings, boolean update) {
        void var3_3;
        block0: {
            UrlQueryStringBuilder params = UrlQueryStringBuilder.createForUrlSafeNames();
            params.add("ramQuotaMB", settings.ramQuotaMB());
            settings.numReplicas().foreach((Function1 & Serializable & scala.Serializable)v -> params.add("replicaNumber", BoxesRunTime.unboxToInt((Object)v)));
            settings.flushEnabled().foreach((Function1 & Serializable & scala.Serializable)v -> params.add("flushEnabled", BoxesRunTime.unboxToBoolean((Object)v) ? 1 : 0));
            settings.maxTTL().foreach((Function1 & Serializable & scala.Serializable)v -> params.add("maxTTL", BoxesRunTime.unboxToInt((Object)v)));
            settings.ejectionMethod().foreach((Function1 & Serializable & scala.Serializable)v -> params.add("evictionPolicy", v.alias()));
            settings.compressionMode().foreach((Function1 & Serializable & scala.Serializable)v -> params.add("compressionMode", v.alias()));
            if (update) break block0;
            params.add("name", settings.name());
            settings.bucketType().foreach((Function1 & Serializable & scala.Serializable)v -> params.add("bucketType", v.alias()));
            settings.conflictResolutionType().foreach((Function1 & Serializable & scala.Serializable)v -> params.add("conflictResolutionType", v.alias()));
            settings.replicaIndexes().foreach((Function1 & Serializable & scala.Serializable)v -> params.add("replicaIndex", BoxesRunTime.unboxToBoolean((Object)v) ? 1 : 0));
        }
        return var3_3;
    }

    public SMono<BoxedUnit> dropBucket(String bucketName, Duration timeout, RetryStrategy retryStrategy) {
        return ManagerUtil$.MODULE$.sendRequest(this.core, HttpMethod.DELETE, this.pathForBucket(bucketName), timeout, retryStrategy).flatMap((Function1 & Serializable & scala.Serializable)response -> {
            SMono sMono;
            ResponseStatus responseStatus = response.status();
            ResponseStatus responseStatus2 = ResponseStatus.NOT_FOUND;
            if (!(responseStatus != null ? !responseStatus.equals(responseStatus2) : responseStatus2 != null)) {
                sMono = SMono$.MODULE$.raiseError((Throwable)BucketNotFoundException.forBucket((String)bucketName));
            } else {
                SMono sMono2;
                Try<BoxedUnit> try_ = ManagerUtil$.MODULE$.checkStatus((GenericManagerResponse)response, new StringBuilder(14).append("drop bucket [").append(RedactableArgument.redactMeta((Object)bucketName)).append("]").toString());
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable err = failure.exception();
                    sMono2 = SMono$.MODULE$.raiseError(err);
                } else {
                    sMono2 = SMono$.MODULE$.just((Object)BoxedUnit.UNIT);
                }
                sMono = sMono2;
            }
            return sMono;
        });
    }

    public Duration dropBucket$default$2() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy dropBucket$default$3() {
        return this.defaultRetryStrategy();
    }

    public SMono<BucketSettings> getBucket(String bucketName, Duration timeout, RetryStrategy retryStrategy) {
        return ManagerUtil$.MODULE$.sendRequest(this.core, HttpMethod.GET, this.pathForBucket(bucketName), timeout, retryStrategy).flatMap((Function1 & Serializable & scala.Serializable)response -> {
            SMono sMono;
            ResponseStatus responseStatus = response.status();
            ResponseStatus responseStatus2 = ResponseStatus.NOT_FOUND;
            if (!(responseStatus != null ? !responseStatus.equals(responseStatus2) : responseStatus2 != null)) {
                sMono = SMono$.MODULE$.raiseError((Throwable)BucketNotFoundException.forBucket((String)bucketName));
            } else {
                SMono sMono2;
                Try<BoxedUnit> try_ = ManagerUtil$.MODULE$.checkStatus((GenericManagerResponse)response, new StringBuilder(13).append("get bucket [").append(RedactableArgument.redactMeta((Object)bucketName)).append("]").toString());
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable err = failure.exception();
                    sMono2 = SMono$.MODULE$.raiseError(err);
                } else {
                    BucketSettings value = CouchbasePickler$.MODULE$.read((Readable)Readable$.MODULE$.fromByteArray(response.content()), BucketSettings$.MODULE$.rw());
                    sMono2 = SMono$.MODULE$.just((Object)value);
                }
                sMono = sMono2;
            }
            return sMono;
        });
    }

    public Duration getBucket$default$2() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy getBucket$default$3() {
        return this.defaultRetryStrategy();
    }

    public SFlux<BucketSettings> getAllBuckets(Duration timeout, RetryStrategy retryStrategy) {
        return ManagerUtil$.MODULE$.sendRequest(this.core, HttpMethod.GET, this.pathForBuckets(), timeout, retryStrategy).flatMapMany((Function1 & Serializable & scala.Serializable)response -> {
            SFlux sFlux;
            Try<BoxedUnit> try_ = ManagerUtil$.MODULE$.checkStatus((GenericManagerResponse)response, "get all buckets");
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                sFlux = SFlux$.MODULE$.raiseError(err, SFlux$.MODULE$.raiseError$default$2());
            } else {
                Seq value = (Seq)CouchbasePickler$.MODULE$.read((Readable)Readable$.MODULE$.fromByteArray(response.content()), CouchbasePickler$.MODULE$.SeqLikeReader(BucketSettings$.MODULE$.rw(), Predef$.MODULE$.fallbackStringCanBuildFrom()));
                sFlux = SFlux$.MODULE$.fromIterable((Iterable)value);
            }
            return sFlux;
        });
    }

    public Duration getAllBuckets$default$1() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy getAllBuckets$default$2() {
        return this.defaultRetryStrategy();
    }

    public SMono<BoxedUnit> flushBucket(String bucketName, Duration timeout, RetryStrategy retryStrategy) {
        return ManagerUtil$.MODULE$.sendRequest(this.core, HttpMethod.POST, this.pathForBucketFlush(bucketName), timeout, retryStrategy).flatMap((Function1 & Serializable & scala.Serializable)response -> {
            SMono sMono;
            ResponseStatus responseStatus = response.status();
            ResponseStatus responseStatus2 = ResponseStatus.NOT_FOUND;
            if (!(responseStatus != null ? !responseStatus.equals(responseStatus2) : responseStatus2 != null)) {
                sMono = SMono$.MODULE$.raiseError((Throwable)BucketNotFoundException.forBucket((String)bucketName));
            } else {
                SMono sMono2;
                Try<BoxedUnit> try_ = ManagerUtil$.MODULE$.checkStatus((GenericManagerResponse)response, new StringBuilder(15).append("flush bucket [").append(RedactableArgument.redactMeta((Object)bucketName)).append("]").toString());
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable err = failure.exception();
                    sMono2 = SMono$.MODULE$.raiseError(err);
                } else {
                    sMono2 = SMono$.MODULE$.just((Object)BoxedUnit.UNIT);
                }
                sMono = sMono2;
            }
            return sMono;
        });
    }

    public Duration flushBucket$default$2() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy flushBucket$default$3() {
        return this.defaultRetryStrategy();
    }

    public static final /* synthetic */ boolean $anonfun$updateBucket$2(CreateBucketSettings settings$2, BucketSettings x$1) {
        String string = x$1.name();
        String string2 = settings$2.name();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public ReactiveBucketManager(Core core) {
        this.core = core;
        this.defaultManagerTimeout = core.context().environment().timeoutConfig().managementTimeout();
        this.defaultRetryStrategy = core.context().environment().retryStrategy();
    }
}

