/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.kv.handlers;

import com.couchbase.client.core.cnc.InternalSpan;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.error.EncodingFailureException;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.KeyValueRequest;
import com.couchbase.client.core.msg.kv.UpsertRequest;
import com.couchbase.client.core.msg.kv.UpsertResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.scala.HandlerParams;
import com.couchbase.client.scala.codec.EncodedValue;
import com.couchbase.client.scala.codec.JsonSerializer;
import com.couchbase.client.scala.codec.Transcoder;
import com.couchbase.client.scala.codec.TranscoderWithSerializer;
import com.couchbase.client.scala.codec.TranscoderWithoutSerializer;
import com.couchbase.client.scala.durability.Durability;
import com.couchbase.client.scala.kv.DefaultErrors$;
import com.couchbase.client.scala.kv.MutationResult;
import com.couchbase.client.scala.kv.handlers.KeyValueRequestHandler;
import com.couchbase.client.scala.util.Validate$;
import java.io.Serializable;
import java.time.Duration;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.compat.java8.OptionConverters$;
import scala.compat.java8.OptionConverters$RichOptionalGeneric$;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005%b!B\u0003\u0007\u0001)\u0011\u0002\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\t\u000b=\u0002A\u0011\u0001\u0019\t\u000bM\u0002A\u0011\u0001\u001b\t\u000f\u0005e\u0001\u0001\"\u0001\u0002\u001c\tiQ\u000b]:feRD\u0015M\u001c3mKJT!a\u0002\u0005\u0002\u0011!\fg\u000e\u001a7feNT!!\u0003\u0006\u0002\u0005-4(BA\u0006\r\u0003\u0015\u00198-\u00197b\u0015\tia\"\u0001\u0004dY&,g\u000e\u001e\u0006\u0003\u001fA\t\u0011bY8vG\"\u0014\u0017m]3\u000b\u0003E\t1aY8n'\r\u00011\u0003\u0007\t\u0003)Yi\u0011!\u0006\u0006\u0002\u0017%\u0011q#\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\teQB$J\u0007\u0002\r%\u00111D\u0002\u0002\u0017\u0017\u0016Lh+\u00197vKJ+\u0017/^3ti\"\u000bg\u000e\u001a7feB\u0011QdI\u0007\u0002=)\u0011\u0011b\b\u0006\u0003A\u0005\n1!\\:h\u0015\t\u0011C\"\u0001\u0003d_J,\u0017B\u0001\u0013\u001f\u00059)\u0006o]3siJ+7\u000f]8og\u0016\u0004\"AJ\u0014\u000e\u0003!I!\u0001\u000b\u0005\u0003\u001d5+H/\u0019;j_:\u0014Vm];mi\u0006\u0011\u0001\u000e]\u0002\u0001!\taS&D\u0001\u000b\u0013\tq#BA\u0007IC:$G.\u001a:QCJ\fWn]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005E\u0012\u0004CA\r\u0001\u0011\u0015I#\u00011\u0001,\u0003\u001d\u0011X-];fgR,\"!\u000e)\u0015\u0017YzD*\u00171kYRd\u00181\u0001\t\u0004oibT\"\u0001\u001d\u000b\u0005e*\u0012\u0001B;uS2L!a\u000f\u001d\u0003\u0007Q\u0013\u0018\u0010\u0005\u0002\u001e{%\u0011aH\b\u0002\u000e+B\u001cXM\u001d;SKF,Xm\u001d;\t\u000b\u0001\u001b\u0001\u0019A!\u0002\u0005%$\u0007C\u0001\"J\u001d\t\u0019u\t\u0005\u0002E+5\tQI\u0003\u0002GU\u00051AH]8pizJ!\u0001S\u000b\u0002\rA\u0013X\rZ3g\u0013\tQ5J\u0001\u0004TiJLgn\u001a\u0006\u0003\u0011VAQ!T\u0002A\u00029\u000bqaY8oi\u0016tG\u000f\u0005\u0002P!2\u0001A!B)\u0004\u0005\u0004\u0011&!\u0001+\u0012\u0005M3\u0006C\u0001\u000bU\u0013\t)VCA\u0004O_RD\u0017N\\4\u0011\u0005Q9\u0016B\u0001-\u0016\u0005\r\te.\u001f\u0005\u00065\u000e\u0001\raW\u0001\u000bIV\u0014\u0018MY5mSRL\bC\u0001/_\u001b\u0005i&B\u0001.\u000b\u0013\tyVL\u0001\u0006EkJ\f'-\u001b7jifDQ!Y\u0002A\u0002\t\f!\"\u001a=qSJ\fG/[8o!\t\u0019\u0007.D\u0001e\u0015\t)g-\u0001\u0003uS6,'\"A4\u0002\t)\fg/Y\u0005\u0003S\u0012\u0014\u0001\u0002R;sCRLwN\u001c\u0005\u0006W\u000e\u0001\rAY\u0001\bi&lWm\\;u\u0011\u0015i7\u00011\u0001o\u00035\u0011X\r\u001e:z'R\u0014\u0018\r^3hsB\u0011qN]\u0007\u0002a*\u0011\u0011/I\u0001\u0006e\u0016$(/_\u0005\u0003gB\u0014QBU3uef\u001cFO]1uK\u001eL\b\"B;\u0004\u0001\u00041\u0018A\u0003;sC:\u001c8m\u001c3feB\u0011qO_\u0007\u0002q*\u0011\u0011PC\u0001\u0006G>$WmY\u0005\u0003wb\u0014!\u0002\u0016:b]N\u001cw\u000eZ3s\u0011\u0015i8\u00011\u0001\u007f\u0003)\u0019XM]5bY&TXM\u001d\t\u0004o~t\u0015bAA\u0001q\nq!j]8o'\u0016\u0014\u0018.\u00197ju\u0016\u0014\bbBA\u0003\u0007\u0001\u0007\u0011qA\u0001\u000ba\u0006\u0014XM\u001c;Ta\u0006t\u0007#\u0002\u000b\u0002\n\u00055\u0011bAA\u0006+\t1q\n\u001d;j_:\u0004B!a\u0004\u0002\u00165\u0011\u0011\u0011\u0003\u0006\u0004\u0003'\t\u0013aA2oG&!\u0011qCA\t\u0005-\u0011V-];fgR\u001c\u0006/\u00198\u0002\u0011I,7\u000f]8og\u0016$r!JA\u000f\u0003K\t9\u0003\u0003\u00044\t\u0001\u0007\u0011q\u0004\t\u0005;\u0005\u0005B$C\u0002\u0002$y\u0011qbS3z-\u0006dW/\u001a*fcV,7\u000f\u001e\u0005\u0006\u0001\u0012\u0001\r!\u0011\u0005\u0007\u00033!\u0001\u0019\u0001\u000f")
public class UpsertHandler
implements KeyValueRequestHandler<UpsertResponse, MutationResult> {
    private final HandlerParams hp;

    public <T> Try<UpsertRequest> request(String id, T content, Durability durability, Duration expiration, Duration timeout, RetryStrategy retryStrategy, Transcoder transcoder, JsonSerializer<T> serializer, Option<RequestSpan> parentSpan) {
        Try try_;
        Try validations = Validate$.MODULE$.notNullOrEmpty(id, "id").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.notNull(content, "content").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.notNull(durability, "durability").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.notNull(expiration, "expiration").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.notNull(timeout, "timeout").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.notNull(retryStrategy, "retryStrategy").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.notNull(parentSpan, "parentSpan").map((Function1 & Serializable & scala.Serializable)_ -> null)))))));
        if (validations.isFailure()) {
            try_ = validations;
        } else {
            Failure failure;
            Try<EncodedValue> try_2;
            InternalSpan span = this.hp.tracer().internalSpan("upsert", (RequestSpan)parentSpan.orNull(Predef$.MODULE$.$conforms()));
            long start = System.nanoTime();
            span.startPayloadEncoding();
            Transcoder transcoder2 = transcoder;
            if (transcoder2 instanceof TranscoderWithSerializer) {
                TranscoderWithSerializer transcoderWithSerializer = (TranscoderWithSerializer)transcoder2;
                try_2 = transcoderWithSerializer.encode(content, serializer);
            } else if (transcoder2 instanceof TranscoderWithoutSerializer) {
                TranscoderWithoutSerializer transcoderWithoutSerializer = (TranscoderWithoutSerializer)transcoder2;
                try_2 = transcoderWithoutSerializer.encode(content);
            } else {
                throw new MatchError((Object)transcoder2);
            }
            Try<EncodedValue> encoded = try_2;
            span.stopPayloadEncoding();
            long end = System.nanoTime();
            Try<EncodedValue> try_3 = encoded;
            if (try_3 instanceof Success) {
                Success success = (Success)try_3;
                EncodedValue en = (EncodedValue)success.value();
                UpsertRequest out = new UpsertRequest(id, en.encoded(), expiration.getSeconds(), en.flags(), timeout, this.hp.core().context(), this.hp.collectionIdentifier(), retryStrategy, durability.toDurabilityLevel(), span);
                out.context().encodeLatency(end - start);
                failure = new Success((Object)out);
            } else if (try_3 instanceof Failure) {
                Failure failure2 = (Failure)try_3;
                Throwable err = failure2.exception();
                failure = new Failure((Throwable)new EncodingFailureException(err));
            } else {
                throw new MatchError(try_3);
            }
            try_ = failure;
        }
        return try_;
    }

    @Override
    public MutationResult response(KeyValueRequest<UpsertResponse> request, String id, UpsertResponse response) {
        ResponseStatus responseStatus = response.status();
        if (!ResponseStatus.SUCCESS.equals(responseStatus)) {
            throw DefaultErrors$.MODULE$.throwOnBadResult(request, (Response)response);
        }
        MutationResult mutationResult = new MutationResult(response.cas(), OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(response.mutationToken())));
        return mutationResult;
    }

    public UpsertHandler(HandlerParams hp) {
        this.hp = hp;
    }
}

