/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.kv.handlers;

import com.couchbase.client.core.cnc.InternalSpan;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.error.EncodingFailureException;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.KeyValueRequest;
import com.couchbase.client.core.msg.kv.ReplaceRequest;
import com.couchbase.client.core.msg.kv.ReplaceResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.scala.HandlerParams;
import com.couchbase.client.scala.codec.EncodedValue;
import com.couchbase.client.scala.codec.JsonSerializer;
import com.couchbase.client.scala.codec.Transcoder;
import com.couchbase.client.scala.codec.TranscoderWithSerializer;
import com.couchbase.client.scala.codec.TranscoderWithoutSerializer;
import com.couchbase.client.scala.durability.Durability;
import com.couchbase.client.scala.kv.DefaultErrors$;
import com.couchbase.client.scala.kv.MutationResult;
import com.couchbase.client.scala.kv.handlers.KeyValueRequestHandler;
import com.couchbase.client.scala.util.Validate$;
import java.io.Serializable;
import java.time.Duration;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.compat.java8.OptionConverters$;
import scala.compat.java8.OptionConverters$RichOptionalGeneric$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005Mb!B\u0003\u0007\u0001)\u0011\u0002\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\t\u000b=\u0002A\u0011\u0001\u0019\t\u000bM\u0002A\u0011\u0001\u001b\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&\tq!+\u001a9mC\u000e,\u0007*\u00198eY\u0016\u0014(BA\u0004\t\u0003!A\u0017M\u001c3mKJ\u001c(BA\u0005\u000b\u0003\tYgO\u0003\u0002\f\u0019\u0005)1oY1mC*\u0011QBD\u0001\u0007G2LWM\u001c;\u000b\u0005=\u0001\u0012!C2pk\u000eD'-Y:f\u0015\u0005\t\u0012aA2p[N\u0019\u0001a\u0005\r\u0011\u0005Q1R\"A\u000b\u000b\u0003-I!aF\u000b\u0003\r\u0005s\u0017PU3g!\u0011I\"\u0004H\u0013\u000e\u0003\u0019I!a\u0007\u0004\u0003--+\u0017PV1mk\u0016\u0014V-];fgRD\u0015M\u001c3mKJ\u0004\"!H\u0012\u000e\u0003yQ!!C\u0010\u000b\u0005\u0001\n\u0013aA7tO*\u0011!\u0005D\u0001\u0005G>\u0014X-\u0003\u0002%=\ty!+\u001a9mC\u000e,'+Z:q_:\u001cX\r\u0005\u0002'O5\t\u0001\"\u0003\u0002)\u0011\tqQ*\u001e;bi&|gNU3tk2$\u0018A\u00015q\u0007\u0001\u0001\"\u0001L\u0017\u000e\u0003)I!A\f\u0006\u0003\u001b!\u000bg\u000e\u001a7feB\u000b'/Y7t\u0003\u0019a\u0014N\\5u}Q\u0011\u0011G\r\t\u00033\u0001AQ!\u000b\u0002A\u0002-\nqA]3rk\u0016\u001cH/\u0006\u00026!Riag\u0010'Z=\u0016|\u0017/_A\u0002\u0003\u001b\u00012a\u000e\u001e=\u001b\u0005A$BA\u001d\u0016\u0003\u0011)H/\u001b7\n\u0005mB$a\u0001+ssB\u0011Q$P\u0005\u0003}y\u0011aBU3qY\u0006\u001cWMU3rk\u0016\u001cH\u000fC\u0003A\u0007\u0001\u0007\u0011)\u0001\u0002jIB\u0011!)\u0013\b\u0003\u0007\u001e\u0003\"\u0001R\u000b\u000e\u0003\u0015S!A\u0012\u0016\u0002\rq\u0012xn\u001c;?\u0013\tAU#\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0015.\u0013aa\u0015;sS:<'B\u0001%\u0016\u0011\u0015i5\u00011\u0001O\u0003\u001d\u0019wN\u001c;f]R\u0004\"a\u0014)\r\u0001\u0011)\u0011k\u0001b\u0001%\n\tA+\u0005\u0002T-B\u0011A\u0003V\u0005\u0003+V\u0011qAT8uQ&tw\r\u0005\u0002\u0015/&\u0011\u0001,\u0006\u0002\u0004\u0003:L\b\"\u0002.\u0004\u0001\u0004Y\u0016aA2bgB\u0011A\u0003X\u0005\u0003;V\u0011A\u0001T8oO\")ql\u0001a\u0001A\u0006QA-\u001e:bE&d\u0017\u000e^=\u0011\u0005\u0005\u001cW\"\u00012\u000b\u0005}S\u0011B\u00013c\u0005)!UO]1cS2LG/\u001f\u0005\u0006M\u000e\u0001\raZ\u0001\u000bKb\u0004\u0018N]1uS>t\u0007C\u00015n\u001b\u0005I'B\u00016l\u0003\u0011!\u0018.\\3\u000b\u00031\fAA[1wC&\u0011a.\u001b\u0002\t\tV\u0014\u0018\r^5p]\")\u0001o\u0001a\u0001O\u00069A/[7f_V$\b\"\u0002:\u0004\u0001\u0004\u0019\u0018!\u0004:fiJL8\u000b\u001e:bi\u0016<\u0017\u0010\u0005\u0002uo6\tQO\u0003\u0002wC\u0005)!/\u001a;ss&\u0011\u00010\u001e\u0002\u000e%\u0016$(/_*ue\u0006$XmZ=\t\u000bi\u001c\u0001\u0019A>\u0002\u0015Q\u0014\u0018M\\:d_\u0012,'\u000f\u0005\u0002}\u007f6\tQP\u0003\u0002\u007f\u0015\u0005)1m\u001c3fG&\u0019\u0011\u0011A?\u0003\u0015Q\u0013\u0018M\\:d_\u0012,'\u000fC\u0004\u0002\u0006\r\u0001\r!a\u0002\u0002\u0015M,'/[1mSj,'\u000f\u0005\u0003}\u0003\u0013q\u0015bAA\u0006{\nq!j]8o'\u0016\u0014\u0018.\u00197ju\u0016\u0014\bbBA\b\u0007\u0001\u0007\u0011\u0011C\u0001\u000ba\u0006\u0014XM\u001c;Ta\u0006t\u0007#\u0002\u000b\u0002\u0014\u0005]\u0011bAA\u000b+\t1q\n\u001d;j_:\u0004B!!\u0007\u0002 5\u0011\u00111\u0004\u0006\u0004\u0003;\t\u0013aA2oG&!\u0011\u0011EA\u000e\u0005-\u0011V-];fgR\u001c\u0006/\u00198\u0002\u0011I,7\u000f]8og\u0016$r!JA\u0014\u0003_\t\t\u0004\u0003\u00044\t\u0001\u0007\u0011\u0011\u0006\t\u0005;\u0005-B$C\u0002\u0002.y\u0011qbS3z-\u0006dW/\u001a*fcV,7\u000f\u001e\u0005\u0006\u0001\u0012\u0001\r!\u0011\u0005\u0007\u0003G!\u0001\u0019\u0001\u000f")
public class ReplaceHandler
implements KeyValueRequestHandler<ReplaceResponse, MutationResult> {
    private final HandlerParams hp;

    public <T> Try<ReplaceRequest> request(String id, T content, long cas, Durability durability, Duration expiration, Duration timeout, RetryStrategy retryStrategy, Transcoder transcoder, JsonSerializer<T> serializer, Option<RequestSpan> parentSpan) {
        Try try_;
        Try validations = Validate$.MODULE$.notNullOrEmpty(id, "id").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.notNull(content, "content").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.notNull(BoxesRunTime.boxToLong((long)cas), "cas").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.notNull(durability, "durability").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.notNull(expiration, "expiration").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.notNull(timeout, "timeout").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.notNull(retryStrategy, "retryStrategy").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.notNull(parentSpan, "parentSpan").map((Function1 & Serializable & scala.Serializable)_ -> null))))))));
        if (validations.isFailure()) {
            try_ = validations;
        } else {
            Failure failure;
            Try<EncodedValue> try_2;
            InternalSpan span = this.hp.tracer().internalSpan("replace", (RequestSpan)parentSpan.orNull(Predef$.MODULE$.$conforms()));
            long start = System.nanoTime();
            span.startPayloadEncoding();
            Transcoder transcoder2 = transcoder;
            if (transcoder2 instanceof TranscoderWithSerializer) {
                TranscoderWithSerializer transcoderWithSerializer = (TranscoderWithSerializer)transcoder2;
                try_2 = transcoderWithSerializer.encode(content, serializer);
            } else if (transcoder2 instanceof TranscoderWithoutSerializer) {
                TranscoderWithoutSerializer transcoderWithoutSerializer = (TranscoderWithoutSerializer)transcoder2;
                try_2 = transcoderWithoutSerializer.encode(content);
            } else {
                throw new MatchError((Object)transcoder2);
            }
            Try<EncodedValue> encoded = try_2;
            span.stopPayloadEncoding();
            long end = System.nanoTime();
            Try<EncodedValue> try_3 = encoded;
            if (try_3 instanceof Success) {
                Success success = (Success)try_3;
                EncodedValue en = (EncodedValue)success.value();
                ReplaceRequest out = new ReplaceRequest(id, en.encoded(), expiration.getSeconds(), en.flags(), timeout, cas, this.hp.core().context(), this.hp.collectionIdentifier(), retryStrategy, durability.toDurabilityLevel(), span);
                out.context().encodeLatency(end - start);
                failure = new Success((Object)out);
            } else if (try_3 instanceof Failure) {
                Failure failure2 = (Failure)try_3;
                Throwable err = failure2.exception();
                failure = new Failure((Throwable)new EncodingFailureException(err));
            } else {
                throw new MatchError(try_3);
            }
            try_ = failure;
        }
        return try_;
    }

    @Override
    public MutationResult response(KeyValueRequest<ReplaceResponse> request, String id, ReplaceResponse response) {
        ResponseStatus responseStatus = response.status();
        if (!ResponseStatus.SUCCESS.equals(responseStatus)) {
            throw DefaultErrors$.MODULE$.throwOnBadResult(request, (Response)response);
        }
        MutationResult mutationResult = new MutationResult(response.cas(), OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(response.mutationToken())));
        return mutationResult;
    }

    public ReplaceHandler(HandlerParams hp) {
        this.hp = hp;
    }
}

