/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.kv.handlers;

import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.CouchbaseBucketConfig;
import com.couchbase.client.core.error.CommonExceptions;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.GetRequest;
import com.couchbase.client.core.msg.kv.GetResponse;
import com.couchbase.client.core.msg.kv.KeyValueRequest;
import com.couchbase.client.core.msg.kv.ReplicaGetRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.scala.HandlerParams;
import com.couchbase.client.scala.codec.Transcoder;
import com.couchbase.client.scala.json.JsonObject;
import com.couchbase.client.scala.kv.DefaultErrors$;
import com.couchbase.client.scala.kv.GetReplicaResult;
import com.couchbase.client.scala.util.Validate$;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq$;
import scala.concurrent.duration.Duration;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005}a!B\u0003\u0007\u0001)\u0011\u0002\u0002\u0003\r\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000e\t\u000by\u0001A\u0011A\u0010\t\u000b\r\u0002A\u0011\u0001\u0013\t\u000bE\u0004A\u0011\u0001:\u0003+\u001d+GO\u0012:p[J+\u0007\u000f\\5dC\"\u000bg\u000e\u001a7fe*\u0011q\u0001C\u0001\tQ\u0006tG\r\\3sg*\u0011\u0011BC\u0001\u0003WZT!a\u0003\u0007\u0002\u000bM\u001c\u0017\r\\1\u000b\u00055q\u0011AB2mS\u0016tGO\u0003\u0002\u0010!\u0005I1m\\;dQ\n\f7/\u001a\u0006\u0002#\u0005\u00191m\\7\u0014\u0005\u0001\u0019\u0002C\u0001\u000b\u0017\u001b\u0005)\"\"A\u0006\n\u0005])\"AB!osJ+g-\u0001\u0002ia\u000e\u0001\u0001CA\u000e\u001d\u001b\u0005Q\u0011BA\u000f\u000b\u00055A\u0015M\u001c3mKJ\u0004\u0016M]1ng\u00061A(\u001b8jiz\"\"\u0001\t\u0012\u0011\u0005\u0005\u0002Q\"\u0001\u0004\t\u000ba\u0011\u0001\u0019\u0001\u000e\u0002\u0015I,\u0017/^3ti\u0006cG.\u0006\u0002&QR)a%Q&V;B\u0019qE\u000b\u0017\u000e\u0003!R!!K\u000b\u0002\tU$\u0018\u000e\\\u0005\u0003W!\u00121\u0001\u0016:z!\riS\u0007\u000f\b\u0003]Mr!a\f\u001a\u000e\u0003AR!!M\r\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0011B\u0001\u001b\u0016\u0003\u001d\u0001\u0018mY6bO\u0016L!AN\u001c\u0003\u0007M+\u0017O\u0003\u00025+A\u0011\u0011hP\u0007\u0002u)\u0011\u0011b\u000f\u0006\u0003yu\n1!\\:h\u0015\tqD\"\u0001\u0003d_J,\u0017B\u0001!;\u0005)9U\r\u001e*fcV,7\u000f\u001e\u0005\u0006\u0005\u000e\u0001\raQ\u0001\u0003S\u0012\u0004\"\u0001\u0012%\u000f\u0005\u00153\u0005CA\u0018\u0016\u0013\t9U#\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0013*\u0013aa\u0015;sS:<'BA$\u0016\u0011\u0015a5\u00011\u0001N\u0003\u001d!\u0018.\\3pkR\u0004\"AT*\u000e\u0003=S!\u0001U)\u0002\tQLW.\u001a\u0006\u0002%\u0006!!.\u0019<b\u0013\t!vJ\u0001\u0005EkJ\fG/[8o\u0011\u001516\u00011\u0001X\u00035\u0011X\r\u001e:z'R\u0014\u0018\r^3hsB\u0011\u0001lW\u0007\u00023*\u0011!,P\u0001\u0006e\u0016$(/_\u0005\u00039f\u0013QBU3uef\u001cFO]1uK\u001eL\b\"\u00020\u0004\u0001\u0004y\u0016A\u00039be\u0016tGo\u00159b]B\u0019A\u0003\u00192\n\u0005\u0005,\"AB(qi&|g\u000e\u0005\u0002dM6\tAM\u0003\u0002f{\u0005\u00191M\\2\n\u0005\u001d$'a\u0003*fcV,7\u000f^*qC:$Q![\u0002C\u0002)\u0014\u0011\u0001V\t\u0003W:\u0004\"\u0001\u00067\n\u00055,\"a\u0002(pi\"Lgn\u001a\t\u0003)=L!\u0001]\u000b\u0003\u0007\u0005s\u00170\u0001\u0005sKN\u0004xN\\:f))\u0019\b0!\u0001\u0002\u0004\u0005\u0015\u0011q\u0002\t\u0004)\u0001$\bCA;w\u001b\u0005A\u0011BA<\t\u0005A9U\r\u001e*fa2L7-\u0019*fgVdG\u000fC\u0003z\t\u0001\u0007!0A\u0004sKF,Xm\u001d;\u0011\u0007eZX0\u0003\u0002}u\ty1*Z=WC2,XMU3rk\u0016\u001cH\u000f\u0005\u0002:}&\u0011qP\u000f\u0002\f\u000f\u0016$(+Z:q_:\u001cX\rC\u0003C\t\u0001\u00071\tC\u0003r\t\u0001\u0007Q\u0010C\u0004\u0002\b\u0011\u0001\r!!\u0003\u0002\u0013%\u001c(+\u001a9mS\u000e\f\u0007c\u0001\u000b\u0002\f%\u0019\u0011QB\u000b\u0003\u000f\t{w\u000e\\3b]\"9\u0011\u0011\u0003\u0003A\u0002\u0005M\u0011A\u0003;sC:\u001c8m\u001c3feB!\u0011QCA\u000e\u001b\t\t9BC\u0002\u0002\u001a)\tQaY8eK\u000eLA!!\b\u0002\u0018\tQAK]1og\u000e|G-\u001a:")
public class GetFromReplicaHandler {
    private final HandlerParams hp;

    public <T> Try<Seq<GetRequest>> requestAll(String id, java.time.Duration timeout, RetryStrategy retryStrategy, Option<RequestSpan> parentSpan) {
        Try try_;
        Try validations = Validate$.MODULE$.notNullOrEmpty(id, "id").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.notNull(timeout, "timeout").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.notNull(retryStrategy, "retryStrategy").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.notNull(parentSpan, "parentSpan").map((Function1 & Serializable & scala.Serializable)_ -> null))));
        if (validations.isFailure()) {
            try_ = validations;
        } else {
            Failure failure;
            BucketConfig bucketConfig = this.hp.core().clusterConfig().bucketConfig(this.hp.bucketName());
            if (bucketConfig instanceof CouchbaseBucketConfig) {
                GetRequest activeRequest;
                CouchbaseBucketConfig couchbaseBucketConfig = (CouchbaseBucketConfig)bucketConfig;
                int numReplicas = couchbaseBucketConfig.numberOfReplicas();
                Seq replicaRequests = (Seq)package$.MODULE$.Range().apply(0, numReplicas).map((Function1 & Serializable & scala.Serializable)replicaIndex -> GetFromReplicaHandler.$anonfun$requestAll$5(this, id, timeout, retryStrategy, parentSpan, BoxesRunTime.unboxToInt((Object)replicaIndex)), IndexedSeq$.MODULE$.canBuildFrom());
                GetRequest getRequest = activeRequest = new GetRequest(id, timeout, this.hp.core().context(), this.hp.collectionIdentifier(), retryStrategy, this.hp.tracer().internalSpan("get", (RequestSpan)parentSpan.orNull(Predef$.MODULE$.$conforms())));
                Seq requests = (Seq)replicaRequests.$plus$colon((Object)getRequest, Seq$.MODULE$.canBuildFrom());
                failure = new Success((Object)requests);
            } else {
                failure = new Failure((Throwable)CommonExceptions.getFromReplicaNotCouchbaseBucket());
            }
            try_ = failure;
        }
        return try_;
    }

    public Option<GetReplicaResult> response(KeyValueRequest<GetResponse> request, String id, GetResponse response, boolean isReplica, Transcoder transcoder) {
        None$ none$;
        ResponseStatus responseStatus = response.status();
        if (ResponseStatus.SUCCESS.equals(responseStatus)) {
            none$ = new Some((Object)new GetReplicaResult(id, (Either<byte[], JsonObject>)package$.MODULE$.Left().apply((Object)response.content()), response.flags(), response.cas(), (Option<Duration>)Option$.MODULE$.empty(), isReplica, transcoder));
        } else if (ResponseStatus.NOT_FOUND.equals(responseStatus)) {
            none$ = None$.MODULE$;
        } else {
            throw DefaultErrors$.MODULE$.throwOnBadResult(request, (Response)response);
        }
        return none$;
    }

    public static final /* synthetic */ ReplicaGetRequest $anonfun$requestAll$5(GetFromReplicaHandler $this, String id$1, java.time.Duration timeout$1, RetryStrategy retryStrategy$1, Option parentSpan$1, int replicaIndex) {
        return new ReplicaGetRequest(id$1, timeout$1, $this.hp.core().context(), $this.hp.collectionIdentifier(), retryStrategy$1, Predef$.MODULE$.int2Integer(replicaIndex + 1).shortValue(), $this.hp.tracer().internalSpan("replica_get", (RequestSpan)parentSpan$1.orNull(Predef$.MODULE$.$conforms())));
    }

    public GetFromReplicaHandler(HandlerParams hp) {
        this.hp = hp;
    }
}

