/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.diagnostics.DiagnosticsResult;
import com.couchbase.client.core.diagnostics.PingResult;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.scala.AsyncCluster;
import com.couchbase.client.scala.Bucket;
import com.couchbase.client.scala.Cluster$;
import com.couchbase.client.scala.ClusterOptions;
import com.couchbase.client.scala.ReactiveCluster;
import com.couchbase.client.scala.analytics.AnalyticsOptions;
import com.couchbase.client.scala.analytics.AnalyticsParameters;
import com.couchbase.client.scala.analytics.AnalyticsParameters$None$;
import com.couchbase.client.scala.analytics.AnalyticsResult;
import com.couchbase.client.scala.diagnostics.DiagnosticsOptions;
import com.couchbase.client.scala.diagnostics.PingOptions;
import com.couchbase.client.scala.diagnostics.WaitUntilReadyOptions;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.env.SeedNode;
import com.couchbase.client.scala.manager.analytics.AnalyticsIndexManager;
import com.couchbase.client.scala.manager.bucket.BucketManager;
import com.couchbase.client.scala.manager.query.QueryIndexManager;
import com.couchbase.client.scala.manager.search.SearchIndexManager;
import com.couchbase.client.scala.manager.user.UserManager;
import com.couchbase.client.scala.query.QueryOptions;
import com.couchbase.client.scala.query.QueryParameters;
import com.couchbase.client.scala.query.QueryParameters$None$;
import com.couchbase.client.scala.query.QueryResult;
import com.couchbase.client.scala.search.SearchOptions;
import com.couchbase.client.scala.search.queries.SearchQuery;
import com.couchbase.client.scala.search.result.SearchResult;
import com.couchbase.client.scala.util.AsyncUtils$;
import com.couchbase.client.scala.util.DurationConversions$;
import java.util.UUID;
import reactor.core.scala.publisher.SMono;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\t\u001dh\u0001\u0002\u0017.\u0001YB\u0001\u0002\u0010\u0001\u0003\u0002\u0013\u0006I!\u0010\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\"AQ\n\u0001B\u0001B\u0003%a\n\u0003\u0004]\u0001\u0011\u0005Q&\u0018\u0005\tG\u0002\u0011\r\u0011b\u0001.I\"11\u000e\u0001Q\u0001\n\u0015Dq\u0001\u001c\u0001C\u0002\u0013\u0005Q\u000e\u0003\u0004r\u0001\u0001\u0006IA\u001c\u0005\te\u0002A)\u0019!C\u0001g\"Aq\u000f\u0001EC\u0002\u0013\u0005\u0001\u0010\u0003\u0006\u0002\u001a\u0001A)\u0019!C\u0001\u00037A!\"a\u000b\u0001\u0011\u000b\u0007I\u0011AA\u0017\u0011)\ti\u0004\u0001EC\u0002\u0013\u0005\u0011q\b\u0005\u000b\u0003\u001f\u0002\u0001R1A\u0005\u0002\u0005E\u0003bBA\u0012\u0001\u0011\u0005\u0011\u0011\r\u0005\b\u0003k\u0001A\u0011AA:\u0011\u001d\t)\u0004\u0001C\u0001\u00033C\u0011\"!1\u0001#\u0003%\t!a1\t\u0013\u0005]\u0007!%A\u0005\u0002\u0005e\u0007\"CAo\u0001E\u0005I\u0011AAp\u0011\u001d\t\u0019\u000f\u0001C\u0001\u0003KDq!a9\u0001\t\u0003\ti\u0010C\u0005\u0003\f\u0001\t\n\u0011\"\u0001\u0003\u000e!I!\u0011\u0003\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u001c\u0005\b\u0005'\u0001A\u0011\u0001B\u000b\u0011\u001d\u0011\u0019\u0002\u0001C\u0001\u0005\u0007B\u0011Ba\u0013\u0001#\u0003%\t!!7\t\u000f\t5\u0003\u0001\"\u0001\u0003P!I!\u0011\f\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u001c\u0005\b\u00057\u0002A\u0011\u0001B/\u0011%\u0011y\u0007AI\u0001\n\u0003\u0011\t\bC\u0004\u0003\\\u0001!\tA!\u001e\t\u000f\t\r\u0005\u0001\"\u0001\u0003\u0006\"I!q\u0013\u0001\u0012\u0002\u0013\u0005!\u0011\u0014\u0005\b\u0005\u0007\u0003A\u0011\u0001BO\u0011\u001d\u00119\u000b\u0001C\u0001\u0005SCqAa*\u0001\t\u0003\u0011ykB\u0004\u0003<6B\tA!0\u0007\r1j\u0003\u0012\u0001B`\u0011\u0019av\u0005\"\u0001\u0003B\"9!1Y\u0014\u0005\u0002\t\u0015\u0007b\u0002BbO\u0011\u0005!Q\u001b\u0005\b\u0005\u0007<C\u0011\u0001Bq\u0005\u001d\u0019E.^:uKJT!AL\u0018\u0002\u000bM\u001c\u0017\r\\1\u000b\u0005A\n\u0014AB2mS\u0016tGO\u0003\u00023g\u0005I1m\\;dQ\n\f7/\u001a\u0006\u0002i\u0005\u00191m\\7\u0004\u0001M\u0011\u0001a\u000e\t\u0003qij\u0011!\u000f\u0006\u0002]%\u00111(\u000f\u0002\u0007\u0003:L(+\u001a4\u0002\u0007\u0015tg\u000fE\u00029}\u0001K!aP\u001d\u0003\u0011q\u0012\u0017P\\1nKz\u0002\"!Q\"\u000e\u0003\tS!\u0001P\u0017\n\u0005\u0011\u0013%AE\"mkN$XM]#om&\u0014xN\\7f]R\fQ\"Y;uQ\u0016tG/[2bi>\u0014\bCA$L\u001b\u0005A%B\u0001\u001fJ\u0015\tQu&\u0001\u0003d_J,\u0017B\u0001'I\u00055\tU\u000f\u001e5f]RL7-\u0019;pe\u0006I1/Z3e\u001d>$Wm\u001d\t\u0004\u001fZKfB\u0001)U!\t\t\u0016(D\u0001S\u0015\t\u0019V'\u0001\u0004=e>|GOP\u0005\u0003+f\na\u0001\u0015:fI\u00164\u0017BA,Y\u0005\r\u0019V\r\u001e\u0006\u0003+f\u0002\"!\u0011.\n\u0005m\u0013%\u0001C*fK\u0012tu\u000eZ3\u0002\rqJg.\u001b;?)\u0011q\u0006-\u00192\u0011\u0005}\u0003Q\"A\u0017\t\rq\"A\u00111\u0001>\u0011\u0015)E\u00011\u0001G\u0011\u0015iE\u00011\u0001O\u0003\t)7-F\u0001f!\t1\u0017.D\u0001h\u0015\tA\u0017(\u0001\u0006d_:\u001cWO\u001d:f]RL!A[4\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018aA3dA\u0005)\u0011m]=oGV\ta\u000e\u0005\u0002`_&\u0011\u0001/\f\u0002\r\u0003NLhnY\"mkN$XM]\u0001\u0007CNLhn\u0019\u0011\u0002\u0011I,\u0017m\u0019;jm\u0016,\u0012\u0001\u001e\t\u0003?VL!A^\u0017\u0003\u001fI+\u0017m\u0019;jm\u0016\u001cE.^:uKJ\fQ!^:feN,\u0012!\u001f\t\u0003u~l\u0011a\u001f\u0006\u0003yv\fA!^:fe*\u0011a0L\u0001\b[\u0006t\u0017mZ3s\u0013\r\t\ta\u001f\u0002\f+N,'/T1oC\u001e,'\u000fK\u0002\u000b\u0003\u000b\u0001B!a\u0002\u0002\u00149!\u0011\u0011BA\b\u001b\t\tYAC\u0002\u0002\u000e%\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t\t\"a\u0003\u0002\u0013M#\u0018MY5mSRL\u0018\u0002BA\u000b\u0003/\u0011\u0001BV8mCRLG.\u001a\u0006\u0005\u0003#\tY!A\u0004ck\u000e\\W\r^:\u0016\u0005\u0005u\u0001\u0003BA\u0010\u0003Ki!!!\t\u000b\u0007\u0005\rR0\u0001\u0004ck\u000e\\W\r^\u0005\u0005\u0003O\t\tCA\u0007Ck\u000e\\W\r^'b]\u0006<WM\u001d\u0015\u0004\u0017\u0005\u0015\u0011\u0001D9vKJL\u0018J\u001c3fq\u0016\u001cXCAA\u0018!\u0011\t\t$a\u000e\u000e\u0005\u0005M\"bAA\u001b{\u0006)\u0011/^3ss&!\u0011\u0011HA\u001a\u0005E\tV/\u001a:z\u0013:$W\r_'b]\u0006<WM\u001d\u0015\u0004\u0019\u0005\u0015\u0011!D:fCJ\u001c\u0007.\u00138eKb,7/\u0006\u0002\u0002BA!\u00111IA%\u001b\t\t)EC\u0002\u0002Hu\faa]3be\u000eD\u0017\u0002BA&\u0003\u000b\u0012!cU3be\u000eD\u0017J\u001c3fq6\u000bg.Y4fe\"\u001aQ\"!\u0002\u0002!\u0005t\u0017\r\\=uS\u000e\u001c\u0018J\u001c3fq\u0016\u001cXCAA*!\u0011\t)&a\u0017\u000e\u0005\u0005]#bAA-{\u0006I\u0011M\\1msRL7m]\u0005\u0005\u0003;\n9FA\u000bB]\u0006d\u0017\u0010^5dg&sG-\u001a=NC:\fw-\u001a:)\u00079\t)\u0001\u0006\u0003\u0002d\u0005%\u0004cA0\u0002f%\u0019\u0011qM\u0017\u0003\r\t+8m[3u\u0011\u001d\tYg\u0004a\u0001\u0003[\n!BY;dW\u0016$h*Y7f!\ry\u0015qN\u0005\u0004\u0003cB&AB*ue&tw\r\u0006\u0004\u0002v\u0005-\u0015q\u0012\t\u0007\u0003o\ni(!!\u000e\u0005\u0005e$bAA>s\u0005!Q\u000f^5m\u0013\u0011\ty(!\u001f\u0003\u0007Q\u0013\u0018\u0010\u0005\u0003\u0002\u0004\u0006\u001dUBAAC\u0015\r\t)$L\u0005\u0005\u0003\u0013\u000b)IA\u0006Rk\u0016\u0014\u0018PU3tk2$\bbBAG!\u0001\u0007\u0011QN\u0001\ngR\fG/Z7f]RDq!!%\u0011\u0001\u0004\t\u0019*A\u0004paRLwN\\:\u0011\t\u0005\r\u0015QS\u0005\u0005\u0003/\u000b)I\u0001\u0007Rk\u0016\u0014\u0018p\u00149uS>t7\u000f\u0006\u0006\u0002v\u0005m\u0015QTAT\u0003oCq!!$\u0012\u0001\u0004\ti\u0007C\u0005\u0002 F\u0001\n\u00111\u0001\u0002\"\u0006Q\u0001/\u0019:b[\u0016$XM]:\u0011\t\u0005\r\u00151U\u0005\u0005\u0003K\u000b)IA\bRk\u0016\u0014\u0018\u0010U1sC6,G/\u001a:t\u0011%\tI+\u0005I\u0001\u0002\u0004\tY+A\u0004uS6,w.\u001e;\u0011\t\u00055\u00161W\u0007\u0003\u0003_S1!!-h\u0003!!WO]1uS>t\u0017\u0002BA[\u0003_\u0013\u0001\u0002R;sCRLwN\u001c\u0005\n\u0003s\u000b\u0002\u0013!a\u0001\u0003w\u000bQ!\u00193i_\u000e\u00042\u0001OA_\u0013\r\ty,\u000f\u0002\b\u0005>|G.Z1o\u0003=\tX/\u001a:zI\u0011,g-Y;mi\u0012\u0012TCAAcU\u0011\t\t+a2,\u0005\u0005%\u0007\u0003BAf\u0003'l!!!4\u000b\t\u0005=\u0017\u0011[\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0004:\u0013\u0011\t).!4\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\brk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\tYN\u000b\u0003\u0002,\u0006\u001d\u0017aD9vKJLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005\u0005(\u0006BA^\u0003\u000f\fa\"\u00198bYf$\u0018nY:Rk\u0016\u0014\u0018\u0010\u0006\u0004\u0002h\u0006M\u0018Q\u001f\t\u0007\u0003o\ni(!;\u0011\t\u0005-\u0018q^\u0007\u0003\u0003[T1!!\u0017.\u0013\u0011\t\t0!<\u0003\u001f\u0005s\u0017\r\\=uS\u000e\u001c(+Z:vYRDq!!$\u0016\u0001\u0004\ti\u0007C\u0004\u0002\u0012V\u0001\r!a>\u0011\t\u0005-\u0018\u0011`\u0005\u0005\u0003w\fiO\u0001\tB]\u0006d\u0017\u0010^5dg>\u0003H/[8ogRA\u0011q]A\u0000\u0005\u0003\u0011I\u0001C\u0004\u0002\u000eZ\u0001\r!!\u001c\t\u0013\u0005}e\u0003%AA\u0002\t\r\u0001\u0003BAv\u0005\u000bIAAa\u0002\u0002n\n\u0019\u0012I\\1msRL7m\u001d)be\u0006lW\r^3sg\"I\u0011\u0011\u0016\f\u0011\u0002\u0003\u0007\u00111V\u0001\u0019C:\fG.\u001f;jGN\fV/\u001a:zI\u0011,g-Y;mi\u0012\u0012TC\u0001B\bU\u0011\u0011\u0019!a2\u00021\u0005t\u0017\r\\=uS\u000e\u001c\u0018+^3ss\u0012\"WMZ1vYR$3'A\u0006tK\u0006\u00148\r[)vKJLH\u0003\u0003B\f\u0005O\u0011YC!\u000f\u0011\r\u0005]\u0014Q\u0010B\r!\u0011\u0011YBa\t\u000e\u0005\tu!\u0002\u0002B\u0010\u0005C\taA]3tk2$(bAA$[%!!Q\u0005B\u000f\u00051\u0019V-\u0019:dQJ+7/\u001e7u\u0011\u001d\u0011I#\u0007a\u0001\u0003[\n\u0011\"\u001b8eKbt\u0015-\\3\t\u000f\u0005U\u0012\u00041\u0001\u0003.A!!q\u0006B\u001b\u001b\t\u0011\tD\u0003\u0003\u00034\t\u0005\u0012aB9vKJLWm]\u0005\u0005\u0005o\u0011\tDA\u0006TK\u0006\u00148\r[)vKJL\bbBAI3\u0001\u0007!1\b\t\u0005\u0005{\u0011y$\u0004\u0002\u0003\"%!!\u0011\tB\u0011\u00055\u0019V-\u0019:dQ>\u0003H/[8ogRA!q\u0003B#\u0005\u000f\u0012I\u0005C\u0004\u0003*i\u0001\r!!\u001c\t\u000f\u0005U\"\u00041\u0001\u0003.!I\u0011\u0011\u0016\u000e\u0011\u0002\u0003\u0007\u00111V\u0001\u0016g\u0016\f'o\u00195Rk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0003)!\u0017n]2p]:,7\r\u001e\u000b\u0005\u0005#\u00129\u0006E\u00029\u0005'J1A!\u0016:\u0005\u0011)f.\u001b;\t\u0013\u0005%F\u0004%AA\u0002\u0005-\u0016\u0001\u00063jg\u000e|gN\\3di\u0012\"WMZ1vYR$\u0013'A\u0006eS\u0006<gn\\:uS\u000e\u001cH\u0003\u0002B0\u0005W\u0002b!a\u001e\u0002~\t\u0005\u0004\u0003\u0002B2\u0005Oj!A!\u001a\u000b\u0007\tm\u0013*\u0003\u0003\u0003j\t\u0015$!\u0005#jC\u001etwn\u001d;jGN\u0014Vm];mi\"I!Q\u000e\u0010\u0011\u0002\u0003\u0007\u0011QN\u0001\te\u0016\u0004xN\u001d;JI\u0006)B-[1h]>\u001cH/[2tI\u0011,g-Y;mi\u0012\nTC\u0001B:U\u0011\ti'a2\u0015\t\t}#q\u000f\u0005\b\u0003#\u0003\u0003\u0019\u0001B=!\u0011\u0011YHa \u000e\u0005\tu$b\u0001B.[%!!\u0011\u0011B?\u0005I!\u0015.Y4o_N$\u0018nY:PaRLwN\\:\u0002\tALgn\u001a\u000b\u0005\u0005\u000f\u0013y\t\u0005\u0004\u0002x\u0005u$\u0011\u0012\t\u0005\u0005G\u0012Y)\u0003\u0003\u0003\u000e\n\u0015$A\u0003)j]\u001e\u0014Vm];mi\"I\u0011\u0011V\u0011\u0011\u0002\u0003\u0007!\u0011\u0013\t\u0006q\tM\u00151V\u0005\u0004\u0005+K$AB(qi&|g.\u0001\bqS:<G\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tm%\u0006\u0002BI\u0003\u000f$BAa\"\u0003 \"9\u0011\u0011S\u0012A\u0002\t\u0005\u0006\u0003\u0002B>\u0005GKAA!*\u0003~\tY\u0001+\u001b8h\u001fB$\u0018n\u001c8t\u000399\u0018-\u001b;V]RLGNU3bIf$BAa+\u0003.B1\u0011qOA?\u0005#Bq!!+%\u0001\u0004\tY\u000b\u0006\u0004\u0003,\nE&1\u0017\u0005\b\u0003S+\u0003\u0019AAV\u0011\u001d\t\t*\na\u0001\u0005k\u0003BAa\u001f\u00038&!!\u0011\u0018B?\u0005U9\u0016-\u001b;V]RLGNU3bIf|\u0005\u000f^5p]N\fqa\u00117vgR,'\u000f\u0005\u0002`OM\u0011qe\u000e\u000b\u0003\u0005{\u000bqaY8o]\u0016\u001cG\u000f\u0006\u0005\u0003H\n%'Q\u001aBi!\u0015\t9(! _\u0011\u001d\u0011Y-\u000ba\u0001\u0003[\n\u0001cY8o]\u0016\u001cG/[8o'R\u0014\u0018N\\4\t\u000f\t=\u0017\u00061\u0001\u0002n\u0005AQo]3s]\u0006lW\rC\u0004\u0003T&\u0002\r!!\u001c\u0002\u0011A\f7o]<pe\u0012$bAa2\u0003X\ne\u0007b\u0002BfU\u0001\u0007\u0011Q\u000e\u0005\b\u0003#S\u0003\u0019\u0001Bn!\ry&Q\\\u0005\u0004\u0005?l#AD\"mkN$XM](qi&|gn\u001d\u000b\u0007\u0005\u000f\u0014\u0019O!:\t\u000b5[\u0003\u0019\u0001(\t\u000f\u0005E5\u00061\u0001\u0003\\\u0002")
public class Cluster {
    private ReactiveCluster reactive;
    @Stability.Volatile
    private UserManager users;
    @Stability.Volatile
    private BucketManager buckets;
    @Stability.Volatile
    private QueryIndexManager queryIndexes;
    @Stability.Volatile
    private SearchIndexManager searchIndexes;
    @Stability.Volatile
    private AnalyticsIndexManager analyticsIndexes;
    private final Function0<ClusterEnvironment> env;
    private final ExecutionContext ec;
    private final AsyncCluster async;
    private volatile byte bitmap$0;

    public static Try<Cluster> connect(Set<SeedNode> set, ClusterOptions clusterOptions) {
        return Cluster$.MODULE$.connect(set, clusterOptions);
    }

    public static Try<Cluster> connect(String string, ClusterOptions clusterOptions) {
        return Cluster$.MODULE$.connect(string, clusterOptions);
    }

    public static Try<Cluster> connect(String string, String string2, String string3) {
        return Cluster$.MODULE$.connect(string, string2, string3);
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public AsyncCluster async() {
        return this.async;
    }

    private ReactiveCluster reactive$lzycompute() {
        Cluster cluster = this;
        synchronized (cluster) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.reactive = new ReactiveCluster(this.async());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.reactive;
    }

    public ReactiveCluster reactive() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.reactive$lzycompute() : this.reactive;
    }

    private UserManager users$lzycompute() {
        Cluster cluster = this;
        synchronized (cluster) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.users = new UserManager(this.async().users(), this.reactive().users());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.users;
    }

    public UserManager users() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.users$lzycompute() : this.users;
    }

    private BucketManager buckets$lzycompute() {
        Cluster cluster = this;
        synchronized (cluster) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.buckets = new BucketManager(this.async().buckets());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.buckets;
    }

    public BucketManager buckets() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.buckets$lzycompute() : this.buckets;
    }

    private QueryIndexManager queryIndexes$lzycompute() {
        Cluster cluster = this;
        synchronized (cluster) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.queryIndexes = new QueryIndexManager(this.async().queryIndexes(), this.ec());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.queryIndexes;
    }

    public QueryIndexManager queryIndexes() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.queryIndexes$lzycompute() : this.queryIndexes;
    }

    private SearchIndexManager searchIndexes$lzycompute() {
        Cluster cluster = this;
        synchronized (cluster) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.searchIndexes = new SearchIndexManager(this.async().searchIndexes());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.searchIndexes;
    }

    public SearchIndexManager searchIndexes() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.searchIndexes$lzycompute() : this.searchIndexes;
    }

    private AnalyticsIndexManager analyticsIndexes$lzycompute() {
        Cluster cluster = this;
        synchronized (cluster) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.analyticsIndexes = new AnalyticsIndexManager(this.reactive().analyticsIndexes());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.analyticsIndexes;
    }

    public AnalyticsIndexManager analyticsIndexes() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.analyticsIndexes$lzycompute() : this.analyticsIndexes;
    }

    public Bucket bucket(String bucketName) {
        return new Bucket(this.async().bucket(bucketName));
    }

    public Try<QueryResult> query(String statement, QueryOptions options) {
        java.time.Duration duration;
        Option<Duration> option = options.timeout();
        if (option instanceof Some) {
            Some some = (Some)option;
            Duration v = (Duration)some.value();
            duration = DurationConversions$.MODULE$.scalaDurationToJava(v);
        } else {
            duration = ((ClusterEnvironment)this.env.apply()).timeoutConfig().queryTimeout();
        }
        java.time.Duration timeout = duration;
        return AsyncUtils$.MODULE$.block(this.async().query(statement, options), AsyncUtils$.MODULE$.block$default$2());
    }

    public Try<QueryResult> query(String statement, QueryParameters parameters, Duration timeout, boolean adhoc) {
        return AsyncUtils$.MODULE$.block(this.async().query(statement, parameters, timeout, adhoc), AsyncUtils$.MODULE$.block$default$2());
    }

    public QueryParameters query$default$2() {
        return QueryParameters$None$.MODULE$;
    }

    public Duration query$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(((ClusterEnvironment)this.env.apply()).timeoutConfig().queryTimeout());
    }

    public boolean query$default$4() {
        return true;
    }

    public Try<AnalyticsResult> analyticsQuery(String statement, AnalyticsOptions options) {
        return AsyncUtils$.MODULE$.block(this.async().analyticsQuery(statement, options), AsyncUtils$.MODULE$.block$default$2());
    }

    public Try<AnalyticsResult> analyticsQuery(String statement, AnalyticsParameters parameters, Duration timeout) {
        return AsyncUtils$.MODULE$.block(this.async().analyticsQuery(statement, parameters, timeout), AsyncUtils$.MODULE$.block$default$2());
    }

    public AnalyticsParameters analyticsQuery$default$2() {
        return AnalyticsParameters$None$.MODULE$;
    }

    public Duration analyticsQuery$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(((ClusterEnvironment)this.env.apply()).timeoutConfig().queryTimeout());
    }

    public Try<SearchResult> searchQuery(String indexName, SearchQuery query, SearchOptions options) {
        return AsyncUtils$.MODULE$.block(this.async().searchQuery(indexName, query, options), AsyncUtils$.MODULE$.block$default$2());
    }

    public Try<SearchResult> searchQuery(String indexName, SearchQuery query, Duration timeout) {
        return AsyncUtils$.MODULE$.block(this.async().searchQuery(indexName, query, timeout), AsyncUtils$.MODULE$.block$default$2());
    }

    public Duration searchQuery$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.async().env().timeoutConfig().searchTimeout());
    }

    public void disconnect(Duration timeout) {
        SMono<BoxedUnit> qual$1 = this.reactive().disconnect(timeout);
        Duration x$1 = qual$1.block$default$1();
        qual$1.block(x$1);
    }

    public Duration disconnect$default$1() {
        return DurationConversions$.MODULE$.javaDurationToScala(((ClusterEnvironment)this.env.apply()).timeoutConfig().disconnectTimeout());
    }

    public Try<DiagnosticsResult> diagnostics(String reportId) {
        return AsyncUtils$.MODULE$.block(this.async().diagnostics(reportId), AsyncUtils$.MODULE$.block$default$2());
    }

    public Try<DiagnosticsResult> diagnostics(DiagnosticsOptions options) {
        return AsyncUtils$.MODULE$.block(this.async().diagnostics(options), AsyncUtils$.MODULE$.block$default$2());
    }

    public String diagnostics$default$1() {
        return UUID.randomUUID().toString();
    }

    public Try<PingResult> ping(Option<Duration> timeout) {
        return AsyncUtils$.MODULE$.block(this.async().ping(timeout), AsyncUtils$.MODULE$.block$default$2());
    }

    public Try<PingResult> ping(PingOptions options) {
        return AsyncUtils$.MODULE$.block(this.async().ping(options), AsyncUtils$.MODULE$.block$default$2());
    }

    public Option<Duration> ping$default$1() {
        return None$.MODULE$;
    }

    public Try<BoxedUnit> waitUntilReady(Duration timeout) {
        return AsyncUtils$.MODULE$.block(this.async().waitUntilReady(timeout), AsyncUtils$.MODULE$.block$default$2());
    }

    public Try<BoxedUnit> waitUntilReady(Duration timeout, WaitUntilReadyOptions options) {
        return AsyncUtils$.MODULE$.block(this.async().waitUntilReady(timeout, options), AsyncUtils$.MODULE$.block$default$2());
    }

    public Cluster(Function0<ClusterEnvironment> env, Authenticator authenticator, Set<SeedNode> seedNodes) {
        this.env = env;
        this.ec = ((ClusterEnvironment)env.apply()).ec();
        this.async = new AsyncCluster(env, authenticator, seedNodes);
    }
}

