/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.diagnostics.ClusterState;
import com.couchbase.client.core.diagnostics.DiagnosticsResult;
import com.couchbase.client.core.diagnostics.HealthPinger;
import com.couchbase.client.core.diagnostics.PingResult;
import com.couchbase.client.core.diagnostics.WaitUntilReadyHelper;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.error.ErrorCodeAndMessage;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.analytics.AnalyticsChunkRow;
import com.couchbase.client.core.msg.analytics.AnalyticsRequest;
import com.couchbase.client.core.msg.search.SearchRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.scala.AsyncBucket;
import com.couchbase.client.scala.AsyncCluster$;
import com.couchbase.client.scala.ClusterOptions;
import com.couchbase.client.scala.HandlerBasicParams;
import com.couchbase.client.scala.ReactiveCluster;
import com.couchbase.client.scala.analytics.AnalyticsMetaData;
import com.couchbase.client.scala.analytics.AnalyticsMetrics$;
import com.couchbase.client.scala.analytics.AnalyticsOptions;
import com.couchbase.client.scala.analytics.AnalyticsOptions$;
import com.couchbase.client.scala.analytics.AnalyticsParameters;
import com.couchbase.client.scala.analytics.AnalyticsParameters$None$;
import com.couchbase.client.scala.analytics.AnalyticsResult;
import com.couchbase.client.scala.analytics.AnalyticsStatus$;
import com.couchbase.client.scala.analytics.AnalyticsWarning;
import com.couchbase.client.scala.diagnostics.DiagnosticsOptions;
import com.couchbase.client.scala.diagnostics.PingOptions;
import com.couchbase.client.scala.diagnostics.PingOptions$;
import com.couchbase.client.scala.diagnostics.WaitUntilReadyOptions;
import com.couchbase.client.scala.diagnostics.WaitUntilReadyOptions$;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.env.SeedNode;
import com.couchbase.client.scala.json.JsonArray;
import com.couchbase.client.scala.manager.analytics.AsyncAnalyticsIndexManager;
import com.couchbase.client.scala.manager.analytics.ReactiveAnalyticsIndexManager;
import com.couchbase.client.scala.manager.bucket.AsyncBucketManager;
import com.couchbase.client.scala.manager.bucket.ReactiveBucketManager;
import com.couchbase.client.scala.manager.query.AsyncQueryIndexManager;
import com.couchbase.client.scala.manager.search.AsyncSearchIndexManager;
import com.couchbase.client.scala.manager.user.AsyncUserManager;
import com.couchbase.client.scala.manager.user.ReactiveUserManager;
import com.couchbase.client.scala.query.QueryOptions;
import com.couchbase.client.scala.query.QueryOptions$;
import com.couchbase.client.scala.query.QueryParameters;
import com.couchbase.client.scala.query.QueryParameters$None$;
import com.couchbase.client.scala.query.QueryResult;
import com.couchbase.client.scala.query.handlers.AnalyticsHandler;
import com.couchbase.client.scala.query.handlers.QueryHandler;
import com.couchbase.client.scala.query.handlers.SearchHandler;
import com.couchbase.client.scala.search.HighlightStyle;
import com.couchbase.client.scala.search.SearchOptions;
import com.couchbase.client.scala.search.SearchOptions$;
import com.couchbase.client.scala.search.SearchScanConsistency;
import com.couchbase.client.scala.search.facet.SearchFacet;
import com.couchbase.client.scala.search.queries.SearchQuery;
import com.couchbase.client.scala.search.result.SearchResult;
import com.couchbase.client.scala.util.DurationConversions$;
import com.couchbase.client.scala.util.FutureConversions$;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.compat.java8.OptionConverters$;
import scala.compat.java8.OptionConverters$RichOptionForJava8$;
import scala.compat.java8.OptionConverters$RichOptionalGeneric$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\rmh\u0001B%K\u0001MC\u0001\"\u0017\u0001\u0003\u0002\u0013\u0006IA\u0017\u0005\nG\u0002\u0011)\u0019!C\u0001\u0015\u0012D\u0001\u0002\u001c\u0001\u0003\u0002\u0003\u0006I!\u001a\u0005\n[\u0002\u0011)\u0019!C\u0001\u0015:D\u0001\" \u0001\u0003\u0002\u0003\u0006Ia\u001c\u0005\u0006}\u0002!\ta \u0005\u000b\u0003\u0017\u0001!\u0019!C\u0002\u0015\u00065\u0001\u0002CA\u000e\u0001\u0001\u0006I!a\u0004\t\u0013%\u0004!\u0019!C\u0001\u0015\u0006u\u0001\u0002CA\u0014\u0001\u0001\u0006I!a\b\t\u0013\u0001\u0004!\u0019!C\u0001\u0015\u0006%\u0002bBA\u0016\u0001\u0001\u0006I!\u0018\u0005\u000b\u0003[\u0001!\u0019!C\u0001\u0015\u0006=\u0002\u0002CA\u001c\u0001\u0001\u0006I!!\r\t\u0015\u0005e\u0002A1A\u0005\u0002)\u000bY\u0004\u0003\u0005\u0002J\u0001\u0001\u000b\u0011BA\u001f\u0011)\tY\u0005\u0001b\u0001\n\u0003Q\u00151\b\u0005\t\u0003\u001b\u0002\u0001\u0015!\u0003\u0002>!Q\u0011q\n\u0001C\u0002\u0013\u0005!*!\u0015\t\u0011\u0005}\u0003\u0001)A\u0005\u0003'B!\"!\u0019\u0001\u0005\u0004%\tASA2\u0011!\t)\b\u0001Q\u0001\n\u0005\u0015\u0004BCA<\u0001\t\u0007I\u0011\u0001&\u0002z!A\u0011\u0011\u0011\u0001!\u0002\u0013\tY\b\u0003\u0006\u0002\u0004\u0002\u0011\r\u0011\"\u0001K\u0003\u000bC\u0001\"!$\u0001A\u0003%\u0011q\u0011\u0005\f\u0003\u001f\u0003\u0001R1A\u0005\u0002)\u000b\t\nC\u0006\u0002$\u0002A)\u0019!C\u0001\u0015\u0006\u0015\u0006bCAZ\u0001!\u0015\r\u0011\"\u0001K\u0003kC!\"a1\u0001\u0005\u0004%\tASAc\u0011!\t\u0019\u000f\u0001Q\u0001\n\u0005\u001d\u0007BCAs\u0001\t\u0007I\u0011\u0001&\u0002h\"A\u0011\u0011\u001f\u0001!\u0002\u0013\tI\u000f\u0003\u0006\u0002t\u0002A)\u0019!C\u0001\u0003kD!Ba\u0005\u0001\u0011\u000b\u0007I\u0011\u0001B\u000b\u0011)\u0011y\u0002\u0001EC\u0002\u0013\u0005!\u0011\u0005\u0005\u000b\u0005_\u0001\u0001R1A\u0005\u0002\tE\u0002B\u0003B!\u0001!\u0015\r\u0011\"\u0001\u0003D!9\u0011Q\u0016\u0001\u0005\u0002\t5\u0003bBA8\u0001\u0011\u0005!\u0011\f\u0005\b\u0003_\u0002A\u0011\u0001B<\u0011%\u0011\u0019\nAI\u0001\n\u0003\u0011)\nC\u0005\u0003*\u0002\t\n\u0011\"\u0001\u0003,\"I!q\u0016\u0001\u0012\u0002\u0013\u0005!\u0011\u0017\u0005\b\u0005k\u0003A\u0011\u0001B\\\u0011\u001d\u0011)\f\u0001C\u0001\u0005\u001fD\u0011B!8\u0001#\u0003%\tAa8\t\u0013\t\r\b!%A\u0005\u0002\t-\u0006b\u0002Bs\u0001\u0011\u0005!q\u001d\u0005\b\u0005K\u0004A\u0011AB\u000b\u0011%\u0019i\u0002AI\u0001\n\u0003\u0011Y\u000bC\u0004\u0004 \u0001!\ta!\t\t\u0013\r5\u0002!%A\u0005\u0002\t-\u0006bBB\u0018\u0001\u0011\u00051\u0011\u0007\u0005\n\u0007\u0007\u0002\u0011\u0013!C\u0001\u0007\u000bBqaa\f\u0001\t\u0003\u0019I\u0005C\u0004\u0004X\u0001!\ta!\u0017\t\u0013\r-\u0004!%A\u0005\u0002\r5\u0004bBB,\u0001\u0011\u00051\u0011\u000f\u0005\b\u0007w\u0002A\u0011AB?\u0011\u001d\u0019Y\b\u0001C\u0001\u0007\u0003C\u0001b!$\u0001\t\u0003Q5qR\u0004\b\u0007#S\u0005\u0012ABJ\r\u0019I%\n#\u0001\u0004\u0016\"1a\u0010\u0011C\u0001\u0007/Cqa!'A\t\u0003\u0019Y\nC\u0004\u0004\u001a\u0002#\ta!.\t\u000f\re\u0005\t\"\u0001\u0004B\"A!Q\u001d!\u0005\u00021\u001b9\r\u0003\u0005\u0004b\u0002#\t\u0001TBr\u0011!\u0019\t\u000f\u0011C\u0001\u0019\u000e5\b\u0002CBy\u0001\u0012\u0005Aja=\u0003\u0019\u0005\u001b\u0018P\\2DYV\u001cH/\u001a:\u000b\u0005-c\u0015!B:dC2\f'BA'O\u0003\u0019\u0019G.[3oi*\u0011q\nU\u0001\nG>,8\r\u001b2bg\u0016T\u0011!U\u0001\u0004G>l7\u0001A\n\u0003\u0001Q\u0003\"!V,\u000e\u0003YS\u0011aS\u0005\u00031Z\u0013a!\u00118z%\u00164\u0017aC3om&\u0014xN\\7f]R\u00042!V.^\u0013\tafK\u0001\u0005=Eft\u0017-\\3?!\tq\u0016-D\u0001`\u0015\t\u0001'*A\u0002f]ZL!AY0\u0003%\rcWo\u001d;fe\u0016sg/\u001b:p]6,g\u000e^\u0001\u000eCV$\b.\u001a8uS\u000e\fGo\u001c:\u0016\u0003\u0015\u0004\"A\u001a6\u000e\u0003\u001dT!\u0001\u00195\u000b\u0005%d\u0015\u0001B2pe\u0016L!a[4\u0003\u001b\u0005+H\u000f[3oi&\u001c\u0017\r^8s\u00039\tW\u000f\u001e5f]RL7-\u0019;pe\u0002\n\u0011b]3fI:{G-Z:\u0016\u0003=\u00042\u0001]<{\u001d\t\tX\u000f\u0005\u0002s-6\t1O\u0003\u0002u%\u00061AH]8pizJ!A\u001e,\u0002\rA\u0013X\rZ3g\u0013\tA\u0018PA\u0002TKRT!A\u001e,\u0011\u0005y[\u0018B\u0001?`\u0005!\u0019V-\u001a3O_\u0012,\u0017AC:fK\u0012tu\u000eZ3tA\u00051A(\u001b8jiz\"\u0002\"!\u0001\u0002\u0006\u0005\u001d\u0011\u0011\u0002\t\u0004\u0003\u0007\u0001Q\"\u0001&\t\re3A\u00111\u0001[\u0011\u0015\u0019g\u00011\u0001f\u0011\u0015ig\u00011\u0001p\u0003\t)7-\u0006\u0002\u0002\u0010A!\u0011\u0011CA\f\u001b\t\t\u0019BC\u0002\u0002\u0016Y\u000b!bY8oGV\u0014(/\u001a8u\u0013\u0011\tI\"a\u0005\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018aA3dAU\u0011\u0011q\u0004\t\u0005\u0003C\t\u0019#D\u0001i\u0013\r\t)\u0003\u001b\u0002\u0005\u0007>\u0014X-A\u0003d_J,\u0007%F\u0001^\u0003\u0011)gN\u001e\u0011\u0002\u0005!\u0004XCAA\u0019!\u0011\t\u0019!a\r\n\u0007\u0005U\"J\u0001\nIC:$G.\u001a:CCNL7\rU1sC6\u001c\u0018a\u00015qA\u0005i1/Z1sG\"$\u0016.\\3pkR,\"!!\u0010\u0011\t\u0005}\u0012QI\u0007\u0003\u0003\u0003RA!a\u0011\u0002\u0014\u0005AA-\u001e:bi&|g.\u0003\u0003\u0002H\u0005\u0005#\u0001\u0003#ve\u0006$\u0018n\u001c8\u0002\u001dM,\u0017M]2i)&lWm\\;uA\u0005\u0001\u0012M\\1msRL7m\u001d+j[\u0016|W\u000f^\u0001\u0012C:\fG.\u001f;jGN$\u0016.\\3pkR\u0004\u0013!\u0004:fiJL8\u000b\u001e:bi\u0016<\u00170\u0006\u0002\u0002TA!\u0011QKA.\u001b\t\t9FC\u0002\u0002Z!\fQA]3uefLA!!\u0018\u0002X\ti!+\u001a;ssN#(/\u0019;fOf\faB]3uef\u001cFO]1uK\u001eL\b%\u0001\u0007rk\u0016\u0014\u0018\u0010S1oI2,'/\u0006\u0002\u0002fA!\u0011qMA9\u001b\t\tIG\u0003\u0003\u0002l\u00055\u0014\u0001\u00035b]\u0012dWM]:\u000b\u0007\u0005=$*A\u0003rk\u0016\u0014\u00180\u0003\u0003\u0002t\u0005%$\u0001D)vKJL\b*\u00198eY\u0016\u0014\u0018!D9vKJL\b*\u00198eY\u0016\u0014\b%\u0001\tb]\u0006d\u0017\u0010^5dg\"\u000bg\u000e\u001a7feV\u0011\u00111\u0010\t\u0005\u0003O\ni(\u0003\u0003\u0002\u0000\u0005%$\u0001E!oC2LH/[2t\u0011\u0006tG\r\\3s\u0003E\tg.\u00197zi&\u001c7\u000fS1oI2,'\u000fI\u0001\u000eg\u0016\f'o\u00195IC:$G.\u001a:\u0016\u0005\u0005\u001d\u0005\u0003BA4\u0003\u0013KA!a#\u0002j\ti1+Z1sG\"D\u0015M\u001c3mKJ\fab]3be\u000eD\u0007*\u00198eY\u0016\u0014\b%A\nsK\u0006\u001cG/\u001b<f+N,'/T1oC\u001e,'/\u0006\u0002\u0002\u0014B!\u0011QSAP\u001b\t\t9J\u0003\u0003\u0002\u001a\u0006m\u0015\u0001B;tKJT1!!(K\u0003\u001di\u0017M\\1hKJLA!!)\u0002\u0018\n\u0019\"+Z1di&4X-V:fe6\u000bg.Y4fe\u0006)\"/Z1di&4XMQ;dW\u0016$X*\u00198bO\u0016\u0014XCAAT!\u0011\tI+a,\u000e\u0005\u0005-&\u0002BAW\u00037\u000baAY;dW\u0016$\u0018\u0002BAY\u0003W\u0013QCU3bGRLg/\u001a\"vG.,G/T1oC\u001e,'/A\u000fsK\u0006\u001cG/\u001b<f\u0003:\fG.\u001f;jGNLe\u000eZ3y\u001b\u0006t\u0017mZ3s+\t\t9\f\u0005\u0003\u0002:\u0006}VBAA^\u0015\u0011\ti,a'\u0002\u0013\u0005t\u0017\r\\=uS\u000e\u001c\u0018\u0002BAa\u0003w\u0013QDU3bGRLg/Z!oC2LH/[2t\u0013:$W\r_'b]\u0006<WM]\u0001\u0015\u000b6\u0004H/\u001f(b[\u0016$\u0007+\u0019:b[\u0016$XM]:\u0016\u0005\u0005\u001d\u0007\u0003CAe\u0003'\f9.!8\u000e\u0005\u0005-'\u0002BAg\u0003\u001f\f\u0011\"[7nkR\f'\r\\3\u000b\u0007\u0005Eg+\u0001\u0006d_2dWm\u0019;j_:LA!!6\u0002L\n\u0019Q*\u00199\u0011\u0007A\fI.C\u0002\u0002\\f\u0014aa\u0015;sS:<\u0007cA+\u0002`&\u0019\u0011\u0011\u001d,\u0003\u0007\u0005s\u00170A\u000bF[B$\u0018PT1nK\u0012\u0004\u0016M]1nKR,'o\u001d\u0011\u00023\u0015k\u0007\u000f^=Q_NLG/[8oC2\u0004\u0016M]1nKR,'o]\u000b\u0003\u0003S\u0004b!a;\u0002n\u0006uWBAAh\u0013\u0011\ty/a4\u0003\u0007M+\u0017/\u0001\u000eF[B$\u0018\u0010U8tSRLwN\\1m!\u0006\u0014\u0018-\\3uKJ\u001c\b%A\u0004ck\u000e\\W\r^:\u0016\u0005\u0005]\b\u0003BAU\u0003sLA!a?\u0002,\n\u0011\u0012i]=oG\n+8m[3u\u001b\u0006t\u0017mZ3sQ\r\u0011\u0013q \t\u0005\u0005\u0003\u0011iA\u0004\u0003\u0003\u0004\t%QB\u0001B\u0003\u0015\r\u00119\u0001[\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0006\u0005\u000b\t\u0011b\u0015;bE&d\u0017\u000e^=\n\t\t=!\u0011\u0003\u0002\t->d\u0017\r^5mK*!!1\u0002B\u0003\u0003\u0015)8/\u001a:t+\t\u00119\u0002\u0005\u0003\u0002\u0016\ne\u0011\u0002\u0002B\u000e\u0003/\u0013\u0001#Q:z]\u000e,6/\u001a:NC:\fw-\u001a:)\u0007\r\ny0\u0001\u0007rk\u0016\u0014\u00180\u00138eKb,7/\u0006\u0002\u0003$A!!Q\u0005B\u0015\u001b\t\u00119C\u0003\u0003\u0002p\u0005m\u0015\u0002\u0002B\u0016\u0005O\u0011a#Q:z]\u000e\fV/\u001a:z\u0013:$W\r_'b]\u0006<WM\u001d\u0015\u0004I\u0005}\u0018!D:fCJ\u001c\u0007.\u00138eKb,7/\u0006\u0002\u00034A!!Q\u0007B\u001e\u001b\t\u00119D\u0003\u0003\u0003:\u0005m\u0015AB:fCJ\u001c\u0007.\u0003\u0003\u0003>\t]\"aF!ts:\u001c7+Z1sG\"Le\u000eZ3y\u001b\u0006t\u0017mZ3sQ\r)\u0013q`\u0001\u0011C:\fG.\u001f;jGNLe\u000eZ3yKN,\"A!\u0012\u0011\t\u0005e&qI\u0005\u0005\u0005\u0013\nYL\u0001\u000eBgft7-\u00118bYf$\u0018nY:J]\u0012,\u00070T1oC\u001e,'\u000fK\u0002'\u0003\u007f$BAa\u0014\u0003VA!\u00111\u0001B)\u0013\r\u0011\u0019F\u0013\u0002\f\u0003NLhn\u0019\"vG.,G\u000fC\u0004\u0003X\u001d\u0002\r!a6\u0002\u0015\t,8m[3u\u001d\u0006lW\r\u0006\u0004\u0003\\\t%$Q\u000e\t\u0007\u0003#\u0011iF!\u0019\n\t\t}\u00131\u0003\u0002\u0007\rV$XO]3\u0011\t\t\r$QM\u0007\u0003\u0003[JAAa\u001a\u0002n\tY\u0011+^3ssJ+7/\u001e7u\u0011\u001d\u0011Y\u0007\u000ba\u0001\u0003/\f\u0011b\u001d;bi\u0016lWM\u001c;\t\u000f\t=\u0004\u00061\u0001\u0003r\u00059q\u000e\u001d;j_:\u001c\b\u0003\u0002B2\u0005gJAA!\u001e\u0002n\ta\u0011+^3ss>\u0003H/[8ogRQ!1\fB=\u0005w\u0012)I!#\t\u000f\t-\u0014\u00061\u0001\u0002X\"I!QP\u0015\u0011\u0002\u0003\u0007!qP\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\b\u0003\u0002B2\u0005\u0003KAAa!\u0002n\ty\u0011+^3ssB\u000b'/Y7fi\u0016\u00148\u000fC\u0005\u0003\b&\u0002\n\u00111\u0001\u0002>\u00059A/[7f_V$\b\"\u0003BFSA\u0005\t\u0019\u0001BG\u0003\u0015\tG\r[8d!\r)&qR\u0005\u0004\u0005#3&a\u0002\"p_2,\u0017M\\\u0001\u0010cV,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!q\u0013\u0016\u0005\u0005\u007f\u0012Ij\u000b\u0002\u0003\u001cB!!Q\u0014BS\u001b\t\u0011yJ\u0003\u0003\u0003\"\n\r\u0016!C;oG\",7m[3e\u0015\r\u00119AV\u0005\u0005\u0005O\u0013yJA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fq\"];fef$C-\u001a4bk2$HeM\u000b\u0003\u0005[SC!!\u0010\u0003\u001a\u0006y\u0011/^3ss\u0012\"WMZ1vYR$C'\u0006\u0002\u00034*\"!Q\u0012BM\u00039\tg.\u00197zi&\u001c7/U;fef$bA!/\u0003F\n\u001d\u0007CBA\t\u0005;\u0012Y\f\u0005\u0003\u0003>\n\u0005WB\u0001B`\u0015\r\tiLS\u0005\u0005\u0005\u0007\u0014yLA\bB]\u0006d\u0017\u0010^5dgJ+7/\u001e7u\u0011\u001d\u0011Y'\fa\u0001\u0003/DqAa\u001c.\u0001\u0004\u0011I\r\u0005\u0003\u0003>\n-\u0017\u0002\u0002Bg\u0005\u007f\u0013\u0001#\u00118bYf$\u0018nY:PaRLwN\\:\u0015\u0011\te&\u0011\u001bBj\u00057DqAa\u001b/\u0001\u0004\t9\u000eC\u0005\u0003~9\u0002\n\u00111\u0001\u0003VB!!Q\u0018Bl\u0013\u0011\u0011INa0\u0003'\u0005s\u0017\r\\=uS\u000e\u001c\b+\u0019:b[\u0016$XM]:\t\u0013\t\u001de\u0006%AA\u0002\u0005u\u0012\u0001G1oC2LH/[2t#V,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!\u0011\u001d\u0016\u0005\u0005+\u0014I*\u0001\rb]\u0006d\u0017\u0010^5dgF+XM]=%I\u00164\u0017-\u001e7uIM\n1b]3be\u000eD\u0017+^3ssRA!\u0011\u001eB}\u0005{\u001cY\u0001\u0005\u0004\u0002\u0012\tu#1\u001e\t\u0005\u0005[\u0014)0\u0004\u0002\u0003p*!!\u0011\u001fBz\u0003\u0019\u0011Xm];mi*\u0019!\u0011\b&\n\t\t](q\u001e\u0002\r'\u0016\f'o\u00195SKN,H\u000e\u001e\u0005\b\u0005w\f\u0004\u0019AAl\u0003%Ig\u000eZ3y\u001d\u0006lW\rC\u0004\u0002pE\u0002\rAa@\u0011\t\r\u00051qA\u0007\u0003\u0007\u0007QAa!\u0002\u0003t\u00069\u0011/^3sS\u0016\u001c\u0018\u0002BB\u0005\u0007\u0007\u00111bU3be\u000eD\u0017+^3ss\"9!qN\u0019A\u0002\r5\u0001\u0003BB\b\u0007#i!Aa=\n\t\rM!1\u001f\u0002\u000e'\u0016\f'o\u00195PaRLwN\\:\u0015\u0011\t%8qCB\r\u00077AqAa?3\u0001\u0004\t9\u000eC\u0004\u0002pI\u0002\rAa@\t\u0013\t\u001d%\u0007%AA\u0002\u0005u\u0012!F:fCJ\u001c\u0007.U;fef$C-\u001a4bk2$HeM\u0001\u000bI&\u001c8m\u001c8oK\u000e$H\u0003BB\u0012\u0007W\u0001b!!\u0005\u0003^\r\u0015\u0002cA+\u0004(%\u00191\u0011\u0006,\u0003\tUs\u0017\u000e\u001e\u0005\n\u0005\u000f#\u0004\u0013!a\u0001\u0003{\tA\u0003Z5tG>tg.Z2uI\u0011,g-Y;mi\u0012\n\u0014a\u00033jC\u001etwn\u001d;jGN$Baa\r\u0004@A1\u0011\u0011\u0003B/\u0007k\u0001Baa\u000e\u0004<5\u00111\u0011\b\u0006\u0004\u0007_A\u0017\u0002BB\u001f\u0007s\u0011\u0011\u0003R5bO:|7\u000f^5dgJ+7/\u001e7u\u0011%\u0019\tE\u000eI\u0001\u0002\u0004\t9.\u0001\u0005sKB|'\u000f^%e\u0003U!\u0017.Y4o_N$\u0018nY:%I\u00164\u0017-\u001e7uIE*\"aa\u0012+\t\u0005]'\u0011\u0014\u000b\u0005\u0007g\u0019Y\u0005C\u0004\u0003pa\u0002\ra!\u0014\u0011\t\r=31K\u0007\u0003\u0007#R1aa\fK\u0013\u0011\u0019)f!\u0015\u0003%\u0011K\u0017m\u001a8pgRL7m](qi&|gn]\u0001\u0005a&tw\r\u0006\u0003\u0004\\\r\r\u0004CBA\t\u0005;\u001ai\u0006\u0005\u0003\u00048\r}\u0013\u0002BB1\u0007s\u0011!\u0002U5oOJ+7/\u001e7u\u0011%\u00119)\u000fI\u0001\u0002\u0004\u0019)\u0007E\u0003V\u0007O\ni$C\u0002\u0004jY\u0013aa\u00149uS>t\u0017A\u00049j]\u001e$C-\u001a4bk2$H%M\u000b\u0003\u0007_RCa!\u001a\u0003\u001aR!11LB:\u0011\u001d\u0011yg\u000fa\u0001\u0007k\u0002Baa\u0014\u0004x%!1\u0011PB)\u0005-\u0001\u0016N\\4PaRLwN\\:\u0002\u001d]\f\u0017\u000e^+oi&d'+Z1esR!11EB@\u0011\u001d\u00119\t\u0010a\u0001\u0003{!baa\t\u0004\u0004\u000e\u0015\u0005b\u0002BD{\u0001\u0007\u0011Q\b\u0005\b\u0005_j\u0004\u0019ABD!\u0011\u0019ye!#\n\t\r-5\u0011\u000b\u0002\u0016/\u0006LG/\u00168uS2\u0014V-\u00193z\u001fB$\u0018n\u001c8t\u0003Q\u0001XM\u001d4pe6<En\u001c2bY\u000e{gN\\3diR\u00111QE\u0001\r\u0003NLhnY\"mkN$XM\u001d\t\u0004\u0003\u0007\u00015C\u0001!U)\t\u0019\u0019*A\u0004d_:tWm\u0019;\u0015\u0011\ru5\u0011VBW\u0007c\u0003baa(\u0004&\u0006\u0005QBABQ\u0015\r\u0019\u0019KV\u0001\u0005kRLG.\u0003\u0003\u0004(\u000e\u0005&a\u0001+ss\"911\u0016\"A\u0002\u0005]\u0017\u0001E2p]:,7\r^5p]N#(/\u001b8h\u0011\u001d\u0019yK\u0011a\u0001\u0003/\f\u0001\"^:fe:\fW.\u001a\u0005\b\u0007g\u0013\u0005\u0019AAl\u0003!\u0001\u0018m]:x_J$GCBBO\u0007o\u001bI\fC\u0004\u0004,\u000e\u0003\r!a6\t\u000f\t=4\t1\u0001\u0004<B!\u00111AB_\u0013\r\u0019yL\u0013\u0002\u000f\u00072,8\u000f^3s\u001fB$\u0018n\u001c8t)\u0019\u0019ija1\u0004F\")Q\u000e\u0012a\u0001_\"9!q\u000e#A\u0002\rmFCBBe\u0007\u001b\u001cy\u000e\u0006\u0003\u0003j\u000e-\u0007bBA\u0006\u000b\u0002\u000f\u0011q\u0002\u0005\b\u0007\u001f,\u0005\u0019ABi\u0003\u001d\u0011X-];fgR\u0004Baa5\u0004\\6\u00111Q\u001b\u0006\u0005\u0005s\u00199NC\u0002\u0004Z\"\f1!\\:h\u0013\u0011\u0019in!6\u0003\u001bM+\u0017M]2i%\u0016\fX/Z:u\u0011\u0019IW\t1\u0001\u0002 \u0005IR\r\u001f;sC\u000e$8\t\\;ti\u0016\u0014XI\u001c<je>tW.\u001a8u)\u0019\u0019)oa:\u0004jB)1qTBS;\"911\u0016$A\u0002\u0005]\u0007bBBv\r\u0002\u000711X\u0001\u0005_B$8\u000f\u0006\u0003\u0004f\u000e=\bbBBv\u000f\u0002\u000711X\u0001\u001eg\u0016,GMT8eKN4%o\\7D_:tWm\u0019;j_:\u001cFO]5oOR)qn!>\u0004z\"91q\u001f%A\u0002\u0005]\u0017AA2t\u0011\u0015I\u0006\n1\u0001^\u0001")
public class AsyncCluster {
    private ReactiveUserManager reactiveUserManager;
    private ReactiveBucketManager reactiveBucketManager;
    private ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager;
    @Stability.Volatile
    private AsyncBucketManager buckets;
    @Stability.Volatile
    private AsyncUserManager users;
    @Stability.Volatile
    private AsyncQueryIndexManager queryIndexes;
    @Stability.Volatile
    private AsyncSearchIndexManager searchIndexes;
    @Stability.Volatile
    private AsyncAnalyticsIndexManager analyticsIndexes;
    private final Function0<ClusterEnvironment> environment;
    private final Authenticator authenticator;
    private final scala.collection.immutable.Set<SeedNode> seedNodes;
    private final ExecutionContext ec;
    private final Core core;
    private final ClusterEnvironment env;
    private final HandlerBasicParams hp;
    private final Duration searchTimeout;
    private final Duration analyticsTimeout;
    private final RetryStrategy retryStrategy;
    private final QueryHandler queryHandler;
    private final AnalyticsHandler analyticsHandler;
    private final SearchHandler searchHandler;
    private final Map<String, Object> EmptyNamedParameters;
    private final Seq<Object> EmptyPositionalParameters;
    private volatile byte bitmap$0;

    public static Try<AsyncCluster> connect(scala.collection.immutable.Set<SeedNode> set, ClusterOptions clusterOptions) {
        return AsyncCluster$.MODULE$.connect(set, clusterOptions);
    }

    public static Try<AsyncCluster> connect(String string, ClusterOptions clusterOptions) {
        return AsyncCluster$.MODULE$.connect(string, clusterOptions);
    }

    public static Try<AsyncCluster> connect(String string, String string2, String string3) {
        return AsyncCluster$.MODULE$.connect(string, string2, string3);
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public scala.collection.immutable.Set<SeedNode> seedNodes() {
        return this.seedNodes;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public Core core() {
        return this.core;
    }

    public ClusterEnvironment env() {
        return this.env;
    }

    public HandlerBasicParams hp() {
        return this.hp;
    }

    public Duration searchTimeout() {
        return this.searchTimeout;
    }

    public Duration analyticsTimeout() {
        return this.analyticsTimeout;
    }

    public RetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    public QueryHandler queryHandler() {
        return this.queryHandler;
    }

    public AnalyticsHandler analyticsHandler() {
        return this.analyticsHandler;
    }

    public SearchHandler searchHandler() {
        return this.searchHandler;
    }

    private ReactiveUserManager reactiveUserManager$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.reactiveUserManager = new ReactiveUserManager(this.core());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.reactiveUserManager;
    }

    public ReactiveUserManager reactiveUserManager() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.reactiveUserManager$lzycompute() : this.reactiveUserManager;
    }

    private ReactiveBucketManager reactiveBucketManager$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.reactiveBucketManager = new ReactiveBucketManager(this.core());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.reactiveBucketManager;
    }

    public ReactiveBucketManager reactiveBucketManager() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.reactiveBucketManager$lzycompute() : this.reactiveBucketManager;
    }

    private ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.reactiveAnalyticsIndexManager = new ReactiveAnalyticsIndexManager(new ReactiveCluster(this));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.reactiveAnalyticsIndexManager;
    }

    public ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.reactiveAnalyticsIndexManager$lzycompute() : this.reactiveAnalyticsIndexManager;
    }

    public Map<String, Object> EmptyNamedParameters() {
        return this.EmptyNamedParameters;
    }

    public Seq<Object> EmptyPositionalParameters() {
        return this.EmptyPositionalParameters;
    }

    private AsyncBucketManager buckets$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.buckets = new AsyncBucketManager(this.reactiveBucketManager(), this.ec());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.buckets;
    }

    public AsyncBucketManager buckets() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.buckets$lzycompute() : this.buckets;
    }

    private AsyncUserManager users$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.users = new AsyncUserManager(this.reactiveUserManager());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.users;
    }

    public AsyncUserManager users() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.users$lzycompute() : this.users;
    }

    private AsyncQueryIndexManager queryIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.queryIndexes = new AsyncQueryIndexManager(this, this.ec());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.queryIndexes;
    }

    public AsyncQueryIndexManager queryIndexes() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.queryIndexes$lzycompute() : this.queryIndexes;
    }

    private AsyncSearchIndexManager searchIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                this.searchIndexes = new AsyncSearchIndexManager(this, this.ec());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
            }
        }
        return this.searchIndexes;
    }

    public AsyncSearchIndexManager searchIndexes() {
        return (byte)(this.bitmap$0 & 0x40) == 0 ? this.searchIndexes$lzycompute() : this.searchIndexes;
    }

    private AsyncAnalyticsIndexManager analyticsIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((byte)(this.bitmap$0 & 0x80) == 0) {
                this.analyticsIndexes = new AsyncAnalyticsIndexManager(this.reactiveAnalyticsIndexManager());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x80);
            }
        }
        return this.analyticsIndexes;
    }

    public AsyncAnalyticsIndexManager analyticsIndexes() {
        return (byte)(this.bitmap$0 & 0x80) == 0 ? this.analyticsIndexes$lzycompute() : this.analyticsIndexes;
    }

    public AsyncBucket bucket(String bucketName) {
        this.core().openBucket(bucketName);
        return new AsyncBucket(bucketName, this.core(), (ClusterEnvironment)this.environment.apply());
    }

    public Future<QueryResult> query(String statement, QueryOptions options) {
        return this.queryHandler().queryAsync(statement, options, this.env());
    }

    public Future<QueryResult> query(String statement, QueryParameters parameters, Duration timeout, boolean adhoc) {
        QueryOptions opts = QueryOptions$.MODULE$.apply().adhoc(adhoc).timeout(timeout).parameters(parameters);
        return this.query(statement, opts);
    }

    public QueryParameters query$default$2() {
        return QueryParameters$None$.MODULE$;
    }

    public Duration query$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().queryTimeout());
    }

    public boolean query$default$4() {
        return true;
    }

    public Future<AnalyticsResult> analyticsQuery(String statement, AnalyticsOptions options) {
        Future future;
        Try<AnalyticsRequest> try_ = this.analyticsHandler().request(statement, options, this.core(), (ClusterEnvironment)this.environment.apply());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            AnalyticsRequest request = (AnalyticsRequest)success.value();
            this.core().send((Request)request);
            Future ret = FutureConversions$.MODULE$.javaCFToScalaMono((Request<?>)request, request.response(), true).flatMap((Function1 & Serializable & scala.Serializable)response -> FutureConversions$.MODULE$.javaFluxToScalaFlux(response.rows()).collectSeq().flatMap((Function1 & Serializable & scala.Serializable)rows -> FutureConversions$.MODULE$.javaMonoToScalaMono(response.trailer()).map((Function1 & Serializable & scala.Serializable)trailer -> {
                Seq warnings2 = (Seq)OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(trailer.warnings())).map((Function1 & Serializable & scala.Serializable)warnings -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ErrorCodeAndMessage.fromJsonArray((byte[])warnings)).asScala()).map((Function1 & Serializable & scala.Serializable)codeAndMessage -> new AnalyticsWarning((ErrorCodeAndMessage)codeAndMessage), Buffer$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
                return new AnalyticsResult((Seq<AnalyticsChunkRow>)rows, new AnalyticsMetaData(response.header().requestId(), response.header().clientContextId().orElse(""), OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(response.header().signature())), AnalyticsMetrics$.MODULE$.fromBytes(trailer.metrics()), (Seq<AnalyticsWarning>)warnings2, AnalyticsStatus$.MODULE$.from(trailer.status())));
            }))).toFuture();
            ret.onComplete((Function1 & Serializable & scala.Serializable)x$2 -> request.context().logicallyComplete(), this.ec());
            future = ret;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            future = Future$.MODULE$.failed(err);
        } else {
            throw new MatchError(try_);
        }
        return future;
    }

    public Future<AnalyticsResult> analyticsQuery(String statement, AnalyticsParameters parameters, Duration timeout) {
        AnalyticsOptions opts = new AnalyticsOptions(AnalyticsOptions$.MODULE$.apply$default$1(), AnalyticsOptions$.MODULE$.apply$default$2(), AnalyticsOptions$.MODULE$.apply$default$3(), AnalyticsOptions$.MODULE$.apply$default$4(), AnalyticsOptions$.MODULE$.apply$default$5(), AnalyticsOptions$.MODULE$.apply$default$6(), AnalyticsOptions$.MODULE$.apply$default$7(), AnalyticsOptions$.MODULE$.apply$default$8(), AnalyticsOptions$.MODULE$.apply$default$9()).timeout(timeout).parameters(parameters);
        return this.analyticsQuery(statement, opts);
    }

    public AnalyticsParameters analyticsQuery$default$2() {
        return AnalyticsParameters$None$.MODULE$;
    }

    public Duration analyticsQuery$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().queryTimeout());
    }

    public Future<SearchResult> searchQuery(String indexName, SearchQuery query, SearchOptions options) {
        Future<SearchResult> future;
        Try<SearchRequest> try_ = this.searchHandler().request(indexName, query, options, this.core(), (ClusterEnvironment)this.environment.apply());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            SearchRequest request = (SearchRequest)success.value();
            future = AsyncCluster$.MODULE$.searchQuery(request, this.core(), this.ec());
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            future = Future$.MODULE$.failed(err);
        } else {
            throw new MatchError(try_);
        }
        return future;
    }

    public Future<SearchResult> searchQuery(String indexName, SearchQuery query, Duration timeout) {
        Some x$1 = new Some((Object)timeout);
        Option<Object> x$2 = SearchOptions$.MODULE$.apply$default$1();
        Option<Object> x$3 = SearchOptions$.MODULE$.apply$default$2();
        Option<Object> x$4 = SearchOptions$.MODULE$.apply$default$3();
        Option<HighlightStyle> x$5 = SearchOptions$.MODULE$.apply$default$4();
        Option<Seq<String>> x$6 = SearchOptions$.MODULE$.apply$default$5();
        Option<Seq<String>> x$7 = SearchOptions$.MODULE$.apply$default$6();
        Option<JsonArray> x$8 = SearchOptions$.MODULE$.apply$default$7();
        Option<Map<String, SearchFacet>> x$9 = SearchOptions$.MODULE$.apply$default$8();
        Option<Duration> x$10 = SearchOptions$.MODULE$.apply$default$9();
        Option<RuntimeException> x$11 = SearchOptions$.MODULE$.apply$default$10();
        Option<SearchScanConsistency> x$12 = SearchOptions$.MODULE$.apply$default$11();
        Option<RetryStrategy> x$13 = SearchOptions$.MODULE$.apply$default$13();
        Option<RequestSpan> x$14 = SearchOptions$.MODULE$.apply$default$14();
        Option<Map<String, Object>> x$15 = SearchOptions$.MODULE$.apply$default$15();
        return this.searchQuery(indexName, query, new SearchOptions(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, (Option<Duration>)x$1, x$13, x$14, x$15));
    }

    public Duration searchQuery$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(((ClusterEnvironment)this.environment.apply()).timeoutConfig().searchTimeout());
    }

    public Future<BoxedUnit> disconnect(Duration timeout) {
        return FutureConversions$.MODULE$.javaMonoToScalaMono(this.core().shutdown(DurationConversions$.MODULE$.scalaDurationToJava(timeout))).then(SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> this.env().owned() ? this.env().shutdownReactive(timeout) : SMono$.MODULE$.empty())).toFuture();
    }

    public Duration disconnect$default$1() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().disconnectTimeout());
    }

    public Future<DiagnosticsResult> diagnostics(String reportId) {
        return this.diagnostics(new DiagnosticsOptions((Option<String>)new Some((Object)reportId)));
    }

    public Future<DiagnosticsResult> diagnostics(DiagnosticsOptions options) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new DiagnosticsResult(this.core().diagnostics().collect(Collectors.groupingBy(v1 -> v1.type())), this.core().context().environment().userAgent().formattedShort(), (String)options.reportId().getOrElse((Function0 & Serializable & scala.Serializable)() -> UUID.randomUUID().toString())), this.ec());
    }

    public String diagnostics$default$1() {
        return UUID.randomUUID().toString();
    }

    public Future<PingResult> ping(Option<Duration> timeout) {
        ObjectRef opts = ObjectRef.create((Object)new PingOptions(PingOptions$.MODULE$.apply$default$1(), PingOptions$.MODULE$.apply$default$2(), PingOptions$.MODULE$.apply$default$3(), PingOptions$.MODULE$.apply$default$4()));
        timeout.foreach((Function1 & Serializable & scala.Serializable)v -> {
            opts.elem = ((PingOptions)opts.elem).timeout(v);
            return BoxedUnit.UNIT;
        });
        return this.ping((PingOptions)opts.elem);
    }

    public Future<PingResult> ping(PingOptions options) {
        CompletableFuture future = HealthPinger.ping((Core)this.core(), OptionConverters$RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(options.timeout().map((Function1 & Serializable & scala.Serializable)in -> DurationConversions$.MODULE$.scalaDurationToJava((Duration)in)))), (RetryStrategy)((RetryStrategy)options.retryStrategy().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.env().retryStrategy())), (java.util.Set)(options.serviceTypes().isEmpty() ? null : (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter(options.serviceTypes()).asJava()), OptionConverters$RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(options.reportId())), (boolean)true).toFuture();
        return FutureConversions$.MODULE$.javaCFToScalaFuture(future);
    }

    public Option<Duration> ping$default$1() {
        return None$.MODULE$;
    }

    public Future<BoxedUnit> waitUntilReady(Duration timeout) {
        return this.waitUntilReady(timeout, new WaitUntilReadyOptions(WaitUntilReadyOptions$.MODULE$.apply$default$1(), WaitUntilReadyOptions$.MODULE$.apply$default$2()));
    }

    public Future<BoxedUnit> waitUntilReady(Duration timeout, WaitUntilReadyOptions options) {
        return FutureConversions$.MODULE$.javaCFToScalaFuture(WaitUntilReadyHelper.waitUntilReady((Core)this.core(), (java.util.Set)(options.serviceTypes().isEmpty() ? null : (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter(options.serviceTypes()).asJava()), (java.time.Duration)DurationConversions$.MODULE$.scalaDurationToJava(timeout), (ClusterState)options.desiredState(), (boolean)true)).map((Function1 & Serializable & scala.Serializable)x$3 -> {
            AsyncCluster.$anonfun$waitUntilReady$1(x$3);
            return BoxedUnit.UNIT;
        }, this.ec());
    }

    public void performGlobalConnect() {
        this.core().initGlobalConfig();
    }

    public static final /* synthetic */ void $anonfun$waitUntilReady$1(Void x$3) {
    }

    public AsyncCluster(Function0<ClusterEnvironment> environment, Authenticator authenticator, scala.collection.immutable.Set<SeedNode> seedNodes) {
        this.environment = environment;
        this.authenticator = authenticator;
        this.seedNodes = seedNodes;
        this.ec = ((ClusterEnvironment)environment.apply()).ec();
        this.core = Core.create((CoreEnvironment)((ClusterEnvironment)environment.apply()).coreEnv(), (Authenticator)authenticator, (java.util.Set)((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)seedNodes.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toCore(), Set$.MODULE$.canBuildFrom())).asJava()));
        this.env = (ClusterEnvironment)environment.apply();
        this.hp = new HandlerBasicParams(this.core(), this.env());
        this.searchTimeout = DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().searchTimeout());
        this.analyticsTimeout = DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().analyticsTimeout());
        this.retryStrategy = this.env().retryStrategy();
        this.queryHandler = new QueryHandler(this.hp(), this.ec());
        this.analyticsHandler = new AnalyticsHandler(this.hp());
        this.searchHandler = new SearchHandler(this.hp());
        this.EmptyNamedParameters = Predef$.MODULE$.Map().empty();
        this.EmptyPositionalParameters = (Seq)Seq$.MODULE$.empty();
    }
}

