/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.search;

import com.couchbase.client.core.msg.search.SearchChunkHeader;
import com.couchbase.client.core.msg.search.SearchChunkTrailer;
import com.couchbase.client.kotlin.search.DateFacet;
import com.couchbase.client.kotlin.search.DateFacetResult;
import com.couchbase.client.kotlin.search.FacetResult;
import com.couchbase.client.kotlin.search.FacetResultAccessor;
import com.couchbase.client.kotlin.search.NumericFacet;
import com.couchbase.client.kotlin.search.NumericFacetResult;
import com.couchbase.client.kotlin.search.ParsedSearchHeader;
import com.couchbase.client.kotlin.search.SearchFlowItem;
import com.couchbase.client.kotlin.search.SearchFlowItemKt;
import com.couchbase.client.kotlin.search.SearchMetrics;
import com.couchbase.client.kotlin.search.TermFacet;
import com.couchbase.client.kotlin.search.TermFacetResult;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0096\u0002J\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001a\u001a\u00020\u001dH\u0096\u0002J\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001a\u001a\u00020\u001fH\u0096\u0002J\b\u0010 \u001a\u00020\nH\u0016R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/couchbase/client/kotlin/search/SearchMetadata;", "Lcom/couchbase/client/kotlin/search/SearchFlowItem;", "Lcom/couchbase/client/kotlin/search/FacetResultAccessor;", "header", "Lcom/couchbase/client/core/msg/search/SearchChunkHeader;", "trailer", "Lcom/couchbase/client/core/msg/search/SearchChunkTrailer;", "(Lcom/couchbase/client/core/msg/search/SearchChunkHeader;Lcom/couchbase/client/core/msg/search/SearchChunkTrailer;)V", "errors", "", "", "getErrors", "()Ljava/util/Map;", "facets", "", "Lcom/couchbase/client/kotlin/search/FacetResult;", "getFacets", "()Ljava/util/List;", "metrics", "Lcom/couchbase/client/kotlin/search/SearchMetrics;", "getMetrics", "()Lcom/couchbase/client/kotlin/search/SearchMetrics;", "parsedHeader", "Lcom/couchbase/client/kotlin/search/ParsedSearchHeader;", "get", "Lcom/couchbase/client/kotlin/search/DateFacetResult;", "facet", "Lcom/couchbase/client/kotlin/search/DateFacet;", "Lcom/couchbase/client/kotlin/search/NumericFacetResult;", "Lcom/couchbase/client/kotlin/search/NumericFacet;", "Lcom/couchbase/client/kotlin/search/TermFacetResult;", "Lcom/couchbase/client/kotlin/search/TermFacet;", "toString", "kotlin-client"})
public final class SearchMetadata
extends SearchFlowItem
implements FacetResultAccessor {
    @NotNull
    private final SearchChunkHeader header;
    @NotNull
    private final SearchChunkTrailer trailer;
    @NotNull
    private final ParsedSearchHeader parsedHeader;
    @NotNull
    private final SearchMetrics metrics;
    @NotNull
    private final Map<String, String> errors;
    @NotNull
    private final List<FacetResult<?>> facets;

    public SearchMetadata(@NotNull SearchChunkHeader header, @NotNull SearchChunkTrailer trailer) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)trailer, (String)"trailer");
        super(null);
        this.header = header;
        this.trailer = trailer;
        this.parsedHeader = SearchFlowItemKt.parse(this.header);
        this.metrics = new SearchMetrics(this.parsedHeader, this.trailer);
        this.errors = this.parsedHeader.getErrors();
        this.facets = SearchFlowItemKt.parseFacets(this.trailer);
    }

    @NotNull
    public final SearchMetrics getMetrics() {
        return this.metrics;
    }

    @NotNull
    public final Map<String, String> getErrors() {
        return this.errors;
    }

    @Override
    @NotNull
    public List<FacetResult<?>> getFacets() {
        return this.facets;
    }

    @Override
    @Nullable
    public TermFacetResult get(@NotNull TermFacet facet) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
            Iterable iterable = this.getFacets();
            for (Object t : iterable) {
                FacetResult it = (FacetResult)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)facet.getName())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Object var2_7 = v0;
        return var2_7 instanceof TermFacetResult ? (TermFacetResult)var2_7 : null;
    }

    @Override
    @Nullable
    public NumericFacetResult get(@NotNull NumericFacet facet) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
            Iterable iterable = this.getFacets();
            for (Object t : iterable) {
                FacetResult it = (FacetResult)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)facet.getName())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Object var2_7 = v0;
        return var2_7 instanceof NumericFacetResult ? (NumericFacetResult)var2_7 : null;
    }

    @Override
    @Nullable
    public DateFacetResult get(@NotNull DateFacet facet) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
            Iterable iterable = this.getFacets();
            for (Object t : iterable) {
                FacetResult it = (FacetResult)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)facet.getName())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Object var2_7 = v0;
        return var2_7 instanceof DateFacetResult ? (DateFacetResult)var2_7 : null;
    }

    @NotNull
    public String toString() {
        return "SearchMetadata(metrics=" + this.metrics + ", errors=" + this.errors + ", facets=" + this.getFacets() + ", rawHeader=" + this.header + ", rawTrailer=" + this.trailer + ')';
    }
}

