/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.facet;

import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.search.facet.DateRange;
import com.couchbase.client.java.search.facet.DateRangeFacet;
import com.couchbase.client.java.search.facet.NumericRange;
import com.couchbase.client.java.search.facet.NumericRangeFacet;
import com.couchbase.client.java.search.facet.TermFacet;
import java.util.List;

public abstract class SearchFacet {
    private final String field;
    private final int size;

    SearchFacet(String field, int size) {
        this.field = field;
        this.size = size;
    }

    public static TermFacet term(String field, int size) {
        return new TermFacet(field, size);
    }

    public static NumericRangeFacet numericRange(String field, int size, List<NumericRange> ranges) {
        return new NumericRangeFacet(field, size, ranges);
    }

    public static DateRangeFacet dateRange(String field, int size, List<DateRange> ranges) {
        return new DateRangeFacet(field, size, ranges);
    }

    public void injectParams(JsonObject queryJson) {
        queryJson.put("size", this.size);
        queryJson.put("field", this.field);
    }
}

