/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.eventing;

import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.manager.eventing.EventingFunctionUrlAuth;

public class EventingFunctionUrlBinding {
    private final String hostname;
    private final String alias;
    private final boolean allowCookies;
    private final boolean validateSslCertificates;
    private final EventingFunctionUrlAuth auth;

    public static EventingFunctionUrlBinding create(String hostname, String alias) {
        return EventingFunctionUrlBinding.builder(hostname, alias).build();
    }

    public static Builder builder(String hostname, String alias) {
        return new Builder(hostname, alias);
    }

    private EventingFunctionUrlBinding(Builder builder) {
        this.hostname = builder.hostname;
        this.alias = builder.alias;
        this.allowCookies = builder.allowCookies;
        this.validateSslCertificates = builder.validateSslCertificates;
        this.auth = builder.auth;
    }

    public String hostname() {
        return this.hostname;
    }

    public String alias() {
        return this.alias;
    }

    public boolean allowCookies() {
        return this.allowCookies;
    }

    public boolean validateSslCertificates() {
        return this.validateSslCertificates;
    }

    public EventingFunctionUrlAuth auth() {
        return this.auth;
    }

    public String toString() {
        return "EventingFunctionUrlBinding{hostname='" + RedactableArgument.redactMeta((Object)this.hostname) + '\'' + ", alias='" + RedactableArgument.redactMeta((Object)this.alias) + '\'' + ", allowCookies=" + this.allowCookies + ", validateSslCertificates=" + this.validateSslCertificates + ", auth=" + this.auth + '}';
    }

    public static class Builder {
        private final String hostname;
        private final String alias;
        private boolean allowCookies;
        private boolean validateSslCertificates;
        private EventingFunctionUrlAuth auth = EventingFunctionUrlAuth.noAuth();

        private Builder(String hostname, String alias) {
            this.hostname = Validators.notNullOrEmpty((String)hostname, (String)"Hostname");
            this.alias = Validators.notNullOrEmpty((String)alias, (String)"Alias");
        }

        public Builder allowCookies(boolean allowCookies) {
            this.allowCookies = allowCookies;
            return this;
        }

        public Builder validateSslCertificates(boolean validateSslCertificates) {
            this.validateSslCertificates = validateSslCertificates;
            return this;
        }

        public Builder auth(EventingFunctionUrlAuth auth) {
            this.auth = (EventingFunctionUrlAuth)Validators.notNull((Object)auth, (String)"EventingFunctionUrlAuth");
            return this;
        }

        public EventingFunctionUrlBinding build() {
            return new EventingFunctionUrlBinding(this);
        }
    }
}

