/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.analytics.link;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonProperty;
import com.couchbase.client.java.manager.analytics.link.AnalyticsLink;
import com.couchbase.client.java.manager.analytics.link.AnalyticsLinkType;

@Stability.Volatile
public class AzureBlobExternalAnalyticsLink
extends AnalyticsLink {
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    private String connectionString;
    @JsonProperty
    private String accountName;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    private String accountKey;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    private String sharedAccessSignature;
    @JsonProperty
    private String blobEndpoint;
    @JsonProperty
    private String endpointSuffix;

    public AzureBlobExternalAnalyticsLink(String name, String dataverse) {
        super(name, dataverse);
    }

    private AzureBlobExternalAnalyticsLink() {
        super("", "");
    }

    public String connectionString() {
        return this.connectionString;
    }

    public AzureBlobExternalAnalyticsLink connectionString(String connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public String accountName() {
        return this.accountName;
    }

    public AzureBlobExternalAnalyticsLink accountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    public String accountKey() {
        return this.accountKey;
    }

    public AzureBlobExternalAnalyticsLink accountKey(String accountKey) {
        this.accountKey = accountKey;
        return this;
    }

    public String sharedAccessSignature() {
        return this.sharedAccessSignature;
    }

    public AzureBlobExternalAnalyticsLink sharedAccessSignature(String sharedAccessSignature) {
        this.sharedAccessSignature = sharedAccessSignature;
        return this;
    }

    public String blobEndpoint() {
        return this.blobEndpoint;
    }

    public AzureBlobExternalAnalyticsLink blobEndpoint(String blobEndpoint) {
        this.blobEndpoint = blobEndpoint;
        return this;
    }

    public String endpointSuffix() {
        return this.endpointSuffix;
    }

    public AzureBlobExternalAnalyticsLink endpointSuffix(String endpointSuffix) {
        this.endpointSuffix = endpointSuffix;
        return this;
    }

    @Override
    public AnalyticsLinkType type() {
        return AnalyticsLinkType.AZURE_BLOB_EXTERNAL;
    }

    public String toString() {
        return "AzureBlobExternalAnalyticsLink{dataverse='" + this.dataverse() + '\'' + ", name='" + this.name() + '\'' + ", hasConnectionString=" + (this.connectionString != null) + ", accountName='" + this.accountName + '\'' + ", hasAccountKey=" + (this.accountKey != null) + ", hasSharedAccessSignature=" + (this.sharedAccessSignature != null) + ", blobEndpoint='" + this.blobEndpoint + '\'' + ", endpointSuffix='" + this.endpointSuffix + '\'' + '}';
    }
}

