/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.kv;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.client.core.error.InvalidArgumentException;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

@Stability.Internal
public class Expiry {
    private static final int RELATIVE_EXPIRY_CUTOFF_SECONDS = (int)TimeUnit.DAYS.toSeconds(30L);
    private static final int LATEST_VALID_EXPIRY_DURATION = (int)TimeUnit.DAYS.toSeconds(365L) * 50;
    private static final Instant EARLIEST_VALID_EXPIRY_INSTANT = Instant.ofEpochSecond(TimeUnit.DAYS.toSeconds(31L));
    private static final long UNSIGNED_INT_MAX_VALUE = 0xFFFFFFFFL;
    private static final Instant LATEST_VALID_EXPIRY_INSTANT = Instant.ofEpochSecond(0xFFFFFFFFL);
    private static final Expiry NONE = Expiry.absolute(Instant.ofEpochSecond(0L));
    private final Duration duration;
    private final Instant instant;
    private static final Supplier<Long> systemClock = System::currentTimeMillis;

    private Expiry(Duration duration, Instant instant) {
        this.duration = duration;
        this.instant = instant;
    }

    public static Expiry none() {
        return NONE;
    }

    public static Expiry relative(Duration expiry) {
        Objects.requireNonNull(expiry);
        if (expiry.isZero()) {
            return Expiry.none();
        }
        long seconds = expiry.getSeconds();
        if (seconds <= 0L) {
            throw InvalidArgumentException.fromMessage((String)("When specifying expiry as a Duration, it must be either zero (to explicitly disable expiration) or at least 1 second, but got " + expiry + ". If for some reason you want the document to expire immediately, use Instant.ofEpochSecond(DAYS.toSeconds(31))"));
        }
        if (seconds > (long)LATEST_VALID_EXPIRY_DURATION) {
            throw InvalidArgumentException.fromMessage((String)("When specifying expiry as a Duration, it must not be longer than " + LATEST_VALID_EXPIRY_DURATION + ", but got " + expiry + ". If you truly require a longer expiry, please specify it as an Instant instead."));
        }
        return new Expiry(expiry, null);
    }

    public static Expiry absolute(Instant expiry) {
        Objects.requireNonNull(expiry);
        if (expiry.isBefore(EARLIEST_VALID_EXPIRY_INSTANT) && !expiry.equals(Instant.EPOCH)) {
            throw InvalidArgumentException.fromMessage((String)("Expiry instant must be zero (for no expiry) or later than " + EARLIEST_VALID_EXPIRY_INSTANT + ", but got " + expiry));
        }
        if (expiry.isAfter(LATEST_VALID_EXPIRY_INSTANT)) {
            throw InvalidArgumentException.fromMessage((String)("Expiry instant must be no later than " + LATEST_VALID_EXPIRY_DURATION + ", but got " + expiry));
        }
        return new Expiry(null, expiry);
    }

    public long encode() {
        return this.encode(systemClock);
    }

    long encode(Supplier<Long> millisClock) {
        if (this.instant != null) {
            return this.instant.getEpochSecond();
        }
        long seconds = this.duration.getSeconds();
        if (seconds < (long)RELATIVE_EXPIRY_CUTOFF_SECONDS) {
            return seconds;
        }
        long epochSecond = millisClock.get() / 1000L + seconds;
        if (epochSecond > LATEST_VALID_EXPIRY_INSTANT.getEpochSecond()) {
            throw InvalidArgumentException.fromMessage((String)("Document would expire sooner than requested, since the end of duration " + this.duration + " is after " + LATEST_VALID_EXPIRY_INSTANT));
        }
        return epochSecond;
    }

    @Deprecated
    public long encode(EventBus eventBus) {
        return this.encode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Expiry{");
        if (this.duration != null) {
            sb.append(this.duration.isZero() ? "none" : this.duration);
        } else {
            sb.append(this.instant.getEpochSecond() == 0L ? "none" : this.instant);
        }
        return sb.append("}").toString();
    }
}

