/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.codec;

import com.couchbase.client.core.error.DecodingFailureException;
import com.couchbase.client.core.error.EncodingFailureException;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.json.JacksonTransformers;
import com.couchbase.client.java.json.JsonValue;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class JsonValueSerializerWrapper
implements JsonSerializer {
    private final JsonSerializer wrapped;

    public JsonValueSerializerWrapper(JsonSerializer wrapped) {
        this.wrapped = Objects.requireNonNull(wrapped);
    }

    @Override
    public byte[] serialize(Object input) {
        if (input instanceof JsonValue) {
            try {
                return JacksonTransformers.MAPPER.writeValueAsBytes(input);
            }
            catch (Exception e) {
                throw new EncodingFailureException("Serializing of content + " + RedactableArgument.redactUser((Object)input) + " to JSON failed.", (Throwable)e);
            }
        }
        return this.wrapped.serialize(input);
    }

    @Override
    public <T> T deserialize(Class<T> target, byte[] input) {
        if (JsonValue.class.isAssignableFrom(target)) {
            try {
                return (T)JacksonTransformers.MAPPER.readValue(input, target);
            }
            catch (Exception e) {
                throw new DecodingFailureException("Deserialization of content into target " + target + " failed; encoded = " + RedactableArgument.redactUser((Object)new String(input, StandardCharsets.UTF_8)), (Throwable)e);
            }
        }
        return this.wrapped.deserialize(target, input);
    }
}

