/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.analytics;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.DecodingFailureException;
import com.couchbase.client.core.error.ErrorCodeAndMessage;
import com.couchbase.client.core.msg.analytics.AnalyticsChunkHeader;
import com.couchbase.client.core.msg.analytics.AnalyticsChunkTrailer;
import com.couchbase.client.java.analytics.AnalyticsMetrics;
import com.couchbase.client.java.analytics.AnalyticsStatus;
import com.couchbase.client.java.analytics.AnalyticsWarning;
import com.couchbase.client.java.json.JacksonTransformers;
import com.couchbase.client.java.json.JsonObject;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class AnalyticsMetaData {
    private final AnalyticsChunkHeader header;
    private final AnalyticsChunkTrailer trailer;

    private AnalyticsMetaData(AnalyticsChunkHeader header, AnalyticsChunkTrailer trailer) {
        this.header = header;
        this.trailer = trailer;
    }

    @Stability.Internal
    static AnalyticsMetaData from(AnalyticsChunkHeader header, AnalyticsChunkTrailer trailer) {
        return new AnalyticsMetaData(header, trailer);
    }

    public String requestId() {
        return this.header.requestId();
    }

    public String clientContextId() {
        return this.header.clientContextId().orElse("");
    }

    public AnalyticsStatus status() {
        return AnalyticsStatus.from(this.trailer.status());
    }

    public Optional<JsonObject> signature() {
        return this.header.signature().map(bytes -> {
            try {
                return (JsonObject)JacksonTransformers.MAPPER.readValue(bytes, JsonObject.class);
            }
            catch (IOException e) {
                throw new DecodingFailureException("Could not decode Analytics signature", (Throwable)e);
            }
        });
    }

    public AnalyticsMetrics metrics() {
        return new AnalyticsMetrics(this.trailer.metrics());
    }

    public List<AnalyticsWarning> warnings() {
        return this.trailer.warnings().map(warnings -> ErrorCodeAndMessage.fromJsonArray((byte[])warnings).stream().map(AnalyticsWarning::new).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public String toString() {
        return "AnalyticsMetaData{header=" + this.header + ", trailer=" + this.trailer + '}';
    }
}

