/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.view;

import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.view.DefaultView;
import com.couchbase.client.java.view.SpatialView;
import com.couchbase.client.java.view.View;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DesignDocument {
    private final String name;
    private final List<View> views;
    private final Map<Option, Long> options;

    protected DesignDocument(String name, List<View> views, Map<Option, Long> options) {
        this.name = name;
        this.views = views;
        this.options = options;
    }

    public static DesignDocument create(String name, List<View> views) {
        return DesignDocument.create(name, views, new HashMap<Option, Long>());
    }

    public static DesignDocument create(String name, List<View> views, Map<Option, Long> options) {
        return new DesignDocument(name, views, options);
    }

    public static DesignDocument from(String name, JsonObject raw) {
        JsonObject spatialViews;
        String map;
        ArrayList<View> views = new ArrayList<View>();
        JsonObject rawViews = raw.getObject("views");
        if (rawViews != null) {
            for (String string : rawViews.getNames()) {
                JsonObject viewContent = rawViews.getObject(string);
                map = viewContent.getString("map");
                String reduce = viewContent.getString("reduce");
                views.add(DefaultView.create(string, map, reduce));
            }
        }
        if ((spatialViews = raw.getObject("spatial")) != null) {
            for (String viewName : spatialViews.getNames()) {
                map = spatialViews.getString(viewName);
                views.add(SpatialView.create(viewName, map));
            }
        }
        JsonObject jsonObject = raw.getObject("options");
        HashMap<Option, Long> options = new HashMap<Option, Long>();
        if (jsonObject != null) {
            for (String key : jsonObject.getNames()) {
                options.put(Option.fromName(key), jsonObject.getLong(key));
            }
        }
        return new DesignDocument(name, views, options);
    }

    public String name() {
        return this.name;
    }

    public List<View> views() {
        return this.views;
    }

    public Map<Option, Long> options() {
        return this.options;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DesignDocument{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", views=").append(this.views);
        sb.append(", options=").append(this.options);
        sb.append('}');
        return sb.toString();
    }

    public JsonObject toJsonObject() {
        JsonObject converted = JsonObject.empty();
        JsonObject views = JsonObject.empty();
        JsonObject spatialViews = JsonObject.empty();
        JsonObject opts = JsonObject.empty();
        for (View view : this.views) {
            if (view instanceof SpatialView) {
                spatialViews.put(view.name(), view.map());
                continue;
            }
            JsonObject content = JsonObject.empty();
            content.put("map", view.map());
            if (view.hasReduce()) {
                content.put("reduce", view.reduce());
            }
            views.put(view.name(), content);
        }
        boolean hasOptions = false;
        for (Map.Entry<Option, Long> entry : this.options.entrySet()) {
            hasOptions = true;
            opts.put(entry.getKey().alias(), entry.getValue());
        }
        converted.put("views", views);
        converted.put("spatial", spatialViews);
        if (hasOptions) {
            converted.put("options", opts);
        }
        return converted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DesignDocument that = (DesignDocument)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.views != null ? !this.views.equals(that.views) : that.views != null) {
            return false;
        }
        return !(this.options == null ? that.options != null : !this.options.equals(that.options));
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.views != null ? this.views.hashCode() : 0);
        result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
        return result;
    }

    public static enum Option {
        UPDATE_MIN_CHANGES("updateMinChanges"),
        REPLICA_UPDATE_MIN_CHANGES("replicaUpdateMinChanges");

        private final String alias;

        private Option(String alias) {
            this.alias = alias;
        }

        public String alias() {
            return this.alias;
        }

        public static Option fromName(String name) {
            if (name.equals(UPDATE_MIN_CHANGES.alias())) {
                return UPDATE_MIN_CHANGES;
            }
            if (name.equals(REPLICA_UPDATE_MIN_CHANGES.alias())) {
                return REPLICA_UPDATE_MIN_CHANGES;
            }
            throw new IllegalArgumentException("Unknown name: " + name);
        }
    }
}

