/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.result.impl;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.search.result.SearchQueryRow;
import com.couchbase.client.java.search.result.hits.HitLocations;
import java.util.List;
import java.util.Map;

@InterfaceStability.Committed
@InterfaceAudience.Public
public class DefaultSearchQueryRow
implements SearchQueryRow {
    private final String index;
    private final String id;
    private final double score;
    private final JsonObject explanation;
    private final HitLocations locations;
    private final Map<String, List<String>> fragments;
    private final Map<String, String> fields;

    public DefaultSearchQueryRow(String index, String id, double score, JsonObject explanation, HitLocations locations, Map<String, List<String>> fragments, Map<String, String> fields) {
        this.index = index;
        this.id = id;
        this.score = score;
        this.explanation = explanation;
        this.locations = locations;
        this.fragments = fragments;
        this.fields = fields;
    }

    @Override
    public String index() {
        return this.index;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public double score() {
        return this.score;
    }

    @Override
    public JsonObject explanation() {
        return this.explanation;
    }

    @Override
    public HitLocations locations() {
        return this.locations;
    }

    @Override
    public Map<String, List<String>> fragments() {
        return this.fragments;
    }

    @Override
    public Map<String, String> fields() {
        return this.fields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultSearchQueryRow that = (DefaultSearchQueryRow)o;
        if (Double.compare(that.score, this.score) != 0) {
            return false;
        }
        if (!this.index.equals(that.index)) {
            return false;
        }
        return this.id.equals(that.id);
    }

    public int hashCode() {
        int result = this.index.hashCode();
        result = 31 * result + this.id.hashCode();
        long temp = Double.doubleToLongBits(this.score);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "DefaultSearchQueryRow{index='" + this.index + '\'' + ", id='" + this.id + '\'' + ", score=" + this.score + ", explanation=" + this.explanation + ", locations=" + this.locations + ", fragments=" + this.fragments + ", fields=" + this.fields + '}';
    }
}

