/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query.dsl.functions;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.deps.com.fasterxml.jackson.core.io.JsonStringEncoder;
import com.couchbase.client.java.CouchbaseAsyncBucket;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.query.dsl.Expression;

@InterfaceStability.Experimental
@InterfaceAudience.Public
public class JsonFunctions {
    private JsonFunctions() {
    }

    public static Expression decodeJson(Expression expression) {
        return Expression.x("DECODE_JSON(" + expression.toString() + ")");
    }

    public static Expression decodeJson(JsonObject json) {
        char[] encoded = JsonStringEncoder.getInstance().quoteAsString(json.toString());
        return Expression.x("DECODE_JSON(\"" + new String(encoded) + "\")");
    }

    public static Expression decodeJson(String jsonString) {
        try {
            JsonObject jsonObject = CouchbaseAsyncBucket.JSON_OBJECT_TRANSCODER.stringToJsonObject(jsonString);
            return JsonFunctions.decodeJson(jsonObject);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("String is not representing JSON object: " + jsonString);
        }
    }

    public static Expression encodeJson(Expression expression) {
        return Expression.x("ENCODE_JSON(" + expression.toString() + ")");
    }

    public static Expression encodeJson(String expression) {
        return JsonFunctions.encodeJson(Expression.x(expression));
    }

    public static Expression encodedSize(Expression expression) {
        return Expression.x("ENCODED_SIZE(" + expression.toString() + ")");
    }

    public static Expression encodedSize(String expression) {
        return JsonFunctions.encodedSize(Expression.x(expression));
    }

    public static Expression polyLength(Expression expression) {
        return Expression.x("POLY_LENGTH(" + expression.toString() + ")");
    }

    public static Expression polyLength(String expression) {
        return JsonFunctions.polyLength(Expression.x(expression));
    }
}

