/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query.dsl.element;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.query.dsl.element.Element;

@InterfaceStability.Experimental
@InterfaceAudience.Private
public class DropIndexElement
implements Element {
    private final String fullKeyspace;
    private final String indexName;

    public DropIndexElement(String namespace, String keyspace, String indexName) {
        this.fullKeyspace = namespace == null ? "`" + keyspace + "`" : "`" + namespace + "`:`" + keyspace + "`";
        this.indexName = indexName == null ? null : "`" + indexName + "`";
    }

    @Override
    public String export() {
        if (this.indexName == null) {
            return "DROP PRIMARY INDEX ON " + this.fullKeyspace;
        }
        return "DROP INDEX " + this.fullKeyspace + "." + this.indexName;
    }
}

