/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.query.AsyncN1qlQueryRow;
import com.couchbase.client.java.query.DefaultN1qlQueryRow;
import com.couchbase.client.java.query.N1qlMetrics;
import com.couchbase.client.java.query.N1qlQueryResult;
import com.couchbase.client.java.query.N1qlQueryRow;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@InterfaceStability.Committed
@InterfaceAudience.Public
public class DefaultN1qlQueryResult
implements N1qlQueryResult {
    private final String status;
    private final boolean finalSuccess;
    private final boolean parseSuccess;
    private final List<N1qlQueryRow> allRows;
    private final Object signature;
    private final N1qlMetrics info;
    private final JsonObject profileInfo;
    private final List<JsonObject> errors;
    private final String requestId;
    private final String clientContextId;

    public DefaultN1qlQueryResult(List<AsyncN1qlQueryRow> rows, Object signature, N1qlMetrics info, List<JsonObject> errors, JsonObject profileInfo, String finalStatus, Boolean finalSuccess, boolean parseSuccess, String requestId, String clientContextId) {
        this.requestId = requestId;
        this.clientContextId = clientContextId;
        this.parseSuccess = parseSuccess;
        this.finalSuccess = finalSuccess != null && finalSuccess != false;
        this.status = finalStatus;
        this.allRows = new ArrayList<N1qlQueryRow>(rows.size());
        for (AsyncN1qlQueryRow row : rows) {
            this.allRows.add(new DefaultN1qlQueryRow(row));
        }
        this.signature = signature;
        this.errors = errors;
        this.info = info;
        this.profileInfo = profileInfo;
    }

    @Override
    public List<N1qlQueryRow> allRows() {
        return this.allRows;
    }

    @Override
    public Iterator<N1qlQueryRow> rows() {
        return this.allRows.iterator();
    }

    @Override
    public Object signature() {
        return this.signature;
    }

    @Override
    public N1qlMetrics info() {
        return this.info;
    }

    @Override
    public JsonObject profileInfo() {
        return this.profileInfo;
    }

    @Override
    public boolean parseSuccess() {
        return this.parseSuccess;
    }

    @Override
    public List<JsonObject> errors() {
        return this.errors;
    }

    @Override
    public boolean finalSuccess() {
        return this.finalSuccess;
    }

    @Override
    public String status() {
        return this.status;
    }

    @Override
    public Iterator<N1qlQueryRow> iterator() {
        return this.rows();
    }

    @Override
    public String requestId() {
        return this.requestId;
    }

    @Override
    public String clientContextId() {
        return this.clientContextId;
    }

    public String toString() {
        return "N1qlQueryResult{status='" + this.status + '\'' + ", finalSuccess=" + this.finalSuccess + ", parseSuccess=" + this.parseSuccess + ", allRows=" + this.allRows + ", signature=" + this.signature + ", info=" + this.info + ", profileInfo=" + this.profileInfo + ", errors=" + this.errors + ", requestId='" + this.requestId + '\'' + ", clientContextId='" + this.clientContextId + '\'' + '}';
    }
}

