/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.analytics;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.analytics.AnalyticsMetrics;
import com.couchbase.client.java.analytics.AsyncAnalyticsDeferredResultHandle;
import com.couchbase.client.java.analytics.AsyncAnalyticsQueryResult;
import com.couchbase.client.java.analytics.AsyncAnalyticsQueryRow;
import com.couchbase.client.java.document.json.JsonObject;
import rx.Observable;
import rx.functions.Func1;

@InterfaceStability.Committed
@InterfaceAudience.Public
public class DefaultAsyncAnalyticsQueryResult
implements AsyncAnalyticsQueryResult {
    private Observable<AsyncAnalyticsQueryRow> rows;
    private final Observable<Object> signature;
    private final Observable<AnalyticsMetrics> info;
    private final boolean parsingSuccess;
    private final Observable<JsonObject> errors;
    private Observable<String> finalStatus;
    private final String requestId;
    private final String clientContextId;
    private AsyncAnalyticsDeferredResultHandle handle;

    public DefaultAsyncAnalyticsQueryResult(Observable<AsyncAnalyticsQueryRow> rows, Observable<Object> signature, Observable<AnalyticsMetrics> info, Observable<JsonObject> errors, Observable<String> finalStatus, boolean parsingSuccess, String requestId, String clientContextId) {
        this.rows = rows;
        this.signature = signature;
        this.info = info;
        this.errors = errors;
        this.finalStatus = finalStatus;
        this.parsingSuccess = parsingSuccess;
        this.requestId = requestId;
        this.clientContextId = clientContextId;
    }

    public DefaultAsyncAnalyticsQueryResult(AsyncAnalyticsDeferredResultHandle handle, Observable<Object> signature, Observable<AnalyticsMetrics> info, Observable<JsonObject> errors, Observable<String> finalStatus, boolean parsingSuccess, String requestId, String clientContextId) {
        this.handle = handle;
        this.signature = signature;
        this.info = info;
        this.errors = errors;
        this.finalStatus = finalStatus;
        this.parsingSuccess = parsingSuccess;
        this.requestId = requestId;
        this.clientContextId = clientContextId;
        this.rows = Observable.empty();
    }

    @Override
    public Observable<AsyncAnalyticsQueryRow> rows() {
        return this.finalStatus.flatMap((Func1)new Func1<String, Observable<AsyncAnalyticsQueryRow>>(){

            public Observable<AsyncAnalyticsQueryRow> call(String s) {
                if (s.equalsIgnoreCase("running")) {
                    return Observable.just(null);
                }
                return DefaultAsyncAnalyticsQueryResult.this.rows;
            }
        });
    }

    @Override
    public Observable<Object> signature() {
        return this.signature;
    }

    @Override
    public Observable<AnalyticsMetrics> info() {
        return this.info;
    }

    @Override
    public Observable<Boolean> finalSuccess() {
        return this.finalStatus.map((Func1)new Func1<String, Boolean>(){

            public Boolean call(String status) {
                return "success".equalsIgnoreCase(status) || "completed".equalsIgnoreCase(status);
            }
        });
    }

    @Override
    public Observable<String> status() {
        return this.finalStatus;
    }

    @Override
    public boolean parseSuccess() {
        return this.parsingSuccess;
    }

    @Override
    public Observable<JsonObject> errors() {
        return this.errors;
    }

    @Override
    public String requestId() {
        return this.requestId;
    }

    @Override
    public String clientContextId() {
        return this.clientContextId;
    }

    @Override
    public AsyncAnalyticsDeferredResultHandle handle() {
        return this.handle;
    }
}

