/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.columnar.client.java.internal;

import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JavaType;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.Module;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.ObjectMapper;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.columnar.client.java.DataConversionException;
import com.couchbase.columnar.client.java.codec.Deserializer;
import com.couchbase.columnar.client.java.codec.TypeRef;
import com.couchbase.columnar.client.java.internal.JsonSerializer;
import com.couchbase.columnar.client.java.internal.RepackagedJsonValueModule;
import java.io.IOException;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class InternalJacksonSerDes
implements JsonSerializer,
Deserializer {
    public static final InternalJacksonSerDes INSTANCE = new InternalJacksonSerDes();
    private final ObjectMapper mapper = Mapper.newObjectMapper();

    private InternalJacksonSerDes() {
        this.mapper.registerModule((Module)new RepackagedJsonValueModule());
    }

    @Override
    public byte[] serialize(Object input) {
        try {
            return this.mapper.writeValueAsBytes(input);
        }
        catch (Exception e) {
            throw new DataConversionException(e);
        }
    }

    @Override
    public <T> T deserialize(Class<T> target, byte[] input) throws IOException {
        return (T)this.mapper.readValue(input, target);
    }

    @Override
    public <T> T deserialize(TypeRef<T> target, byte[] input) throws IOException {
        JavaType type = this.mapper.getTypeFactory().constructType(target.type());
        return (T)this.mapper.readValue(input, type);
    }
}

