/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.servlet;

import com.cedarsoftware.servlet.ConfigurationProvider;
import com.cedarsoftware.servlet.Envelope;
import com.cedarsoftware.util.AdjustableGZIPOutputStream;
import com.cedarsoftware.util.ArrayUtilities;
import com.cedarsoftware.util.IOUtilities;
import com.cedarsoftware.util.StringUtilities;
import com.cedarsoftware.util.io.JsonIoException;
import com.cedarsoftware.util.io.JsonWriter;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import java.security.AccessControlException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.zip.Deflater;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonCommandServlet
extends HttpServlet
implements GroovyObject {
    public static final ThreadLocal<HttpServletRequest> servletRequest;
    public static final ThreadLocal<HttpServletResponse> servletResponse;
    private ConfigurationProvider configProvider;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public JsonCommandServlet() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public void init() {
        block5: {
            try {
                ConfigurationProvider configurationProvider;
                this.configProvider = configurationProvider = new ConfigurationProvider(this.getServletConfig());
            }
            catch (Exception e) {
                Object v0;
                if (log.isErrorEnabled()) {
                    log.error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{e.getMessage()}, new String[]{"Unable to set up SpringConfigurationProvider: ", ""})), (Throwable)e);
                    v0 = null;
                    break block5;
                }
                v0 = null;
            }
        }
        log.info("JsonCommandServlet init complete");
    }

    public void route(HttpServletRequest request, HttpServletResponse response) {
        if ("post".equalsIgnoreCase(request.getMethod())) {
            this.doPost(request, response);
        } else if ("get".equalsIgnoreCase(request.getMethod())) {
            this.doGet(request, response);
        } else if ("head".equalsIgnoreCase(request.getMethod())) {
            this.doHead(request, response);
        } else if ("put".equalsIgnoreCase(request.getMethod())) {
            this.doPut(request, response);
        } else if ("delete".equalsIgnoreCase(request.getMethod())) {
            this.doDelete(request, response);
        } else if ("options".equalsIgnoreCase(request.getMethod())) {
            this.doOptions(request, response);
        } else if ("trace".equalsIgnoreCase(request.getMethod())) {
            this.doTrace(request, response);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            String string;
            servletRequest.set(request);
            servletResponse.set(response);
            String json = request.getParameter("json");
            if (json == null || json.trim().length() < 1) {
                String msg = "error: HTTP-GET had empty or no 'json=' argument.";
                log.info(msg);
                JsonCommandServlet.sendJsonResponse(request, response, new Envelope(msg, false));
                return;
            }
            json = string = URLDecoder.decode(json, "UTF-8");
            if (log.isDebugEnabled()) {
                Object v0;
                if (log.isDebugEnabled()) {
                    log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{request.getPathInfo(), json}, new String[]{"HTTP GET(", "), json=", ""})));
                    v0 = null;
                } else {
                    v0 = null;
                }
            }
            this.handleRequestAndResponse(request, response, json);
        }
        finally {
            JsonCommandServlet.removeThreadLocals();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        JsonCommandServlet.servletRequest.set(request);
        JsonCommandServlet.servletResponse.set(response);
        if (!(request.getContentLength() < 1)) ** GOTO lbl20
        msg = "error: Call to server had incorrect Content-Length specified.";
        JsonCommandServlet.log.info(msg);
        JsonCommandServlet.sendJsonResponse(request, response, new Envelope(msg, false));
        JsonCommandServlet.removeThreadLocals();
        try {
            try {
                return;
lbl20:
                // 1 sources

                jsonBytes = new byte[request.getContentLength()];
                IOUtilities.transfer((InputStream)new BufferedInputStream((InputStream)request.getInputStream()), (byte[])jsonBytes);
                json = new String(IOUtilities.uncompressBytes((byte[])jsonBytes), "UTF-8");
                if (JsonCommandServlet.log.isDebugEnabled()) {
                    if (JsonCommandServlet.log.isDebugEnabled()) {
                        JsonCommandServlet.log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{request.getPathInfo(), json}, new String[]{"HTTP POST(", "), body=", ""})));
                        v0 = null;
                    } else {
                        v0 = null;
                    }
                }
                this.handleRequestAndResponse(request, response, json);
            }
            catch (Exception e) {
                msg = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{request.getRequestURI(), e.getMessage()}, new String[]{"error: Unable to read HTTP-POST JSON content from URI: ", ". Message: ", ""}));
                JsonCommandServlet.log.warn(msg);
                JsonCommandServlet.sendJsonResponse(request, response, new Envelope(msg, false, e));
            }
        }
        catch (Throwable var8_8) {
            throw var8_8;
        }
        finally {
            JsonCommandServlet.removeThreadLocals();
        }
    }

    private static void removeThreadLocals() {
        servletRequest.remove();
        servletResponse.remove();
    }

    private Object getController(HttpServletRequest request) {
        Matcher matcher = ConfigurationProvider.getUrlMatcher(request);
        if (matcher == null) {
            throw (Throwable)new IllegalArgumentException("error: Invalid JSON request - /controller/method not specified");
        }
        String controllerName = matcher.group(1);
        ConfigurationProvider configurationProvider = this.configProvider;
        Object controller = configurationProvider != null ? configurationProvider.getController(controllerName) : null;
        return controller;
    }

    private void handleRequestAndResponse(HttpServletRequest request, HttpServletResponse response, String json) {
        Envelope envelope = null;
        Object controller = null;
        try {
            Envelope envelope2;
            Object object;
            controller = object = this.getController(request);
            Object result = this.configProvider.callController(controller, request, json);
            envelope = envelope2 = new Envelope(result, true);
        }
        catch (ThreadDeath d) {
            throw (Throwable)d;
        }
        catch (Throwable e) {
            block32: {
                Envelope envelope3;
                Object v2;
                Map altMsg = null;
                if (e instanceof InvocationTargetException) {
                    Object v0;
                    Map map;
                    Throwable throwable;
                    Object[] pieces = null;
                    if (DefaultTypeTransformation.booleanUnbox((Object)controller)) {
                        String[] stringArray = DefaultGroovyMethods.inspect((Object)controller).split("@");
                        pieces = stringArray;
                    } else {
                        Object[] objectArray;
                        pieces = objectArray = new String[1];
                        String string = JsonCommandServlet.class.getName();
                        BytecodeInterface8.objectArraySet((Object[])pieces, (int)0, (Object)string);
                    }
                    e = throwable = e.getCause();
                    altMsg = map = JsonCommandServlet.buildLogMessages(e, StringGroovyMethods.plus((String)ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])pieces, (int)0)), (CharSequence)"."));
                    if (log.isInfoEnabled()) {
                        log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{request.getRequestURI(), altMsg.get("log")}, new String[]{"Controller threw an exception, request: ", ":\n", ""})));
                        v0 = null;
                    } else {
                        v0 = null;
                    }
                } else if (e instanceof IllegalArgumentException || e instanceof JsonIoException) {
                    Object v1;
                    if (log.isInfoEnabled()) {
                        log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{e.getMessage(), request.getRequestURI(), json}, new String[]{"", "\n  URI: ", "\n  JSON argument: ", ""})));
                        v1 = null;
                    } else {
                        v1 = null;
                    }
                } else if (log.isWarnEnabled()) {
                    log.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{request.getRequestURI()}, new String[]{"Unexpected exception, request: ", ":"})), e);
                    v2 = null;
                } else {
                    v2 = null;
                }
                String string = altMsg == null ? null : (String)altMsg.get("msg");
                String msg = ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox(string) ? string : e.getMessage()));
                if (StringUtilities.isEmpty((String)msg)) {
                    String string2;
                    msg = string2 = e.getClass().getName();
                }
                envelope = envelope3 = new Envelope(new GStringImpl(new Object[]{msg, request.getRequestURI()}, new String[]{"", " from URI: ", ""}), false, e);
                if (e instanceof IOException) {
                    if (ScriptBytecodeAdapter.compareEqual((Object)"org.apache.catalina.connector.ClientAbortException", (Object)e.getClass().getName())) {
                        log.info("Client aborted connection while processing JSON request.");
                    } else {
                        JsonCommandServlet.sendJsonResponse(request, response, new Envelope(new GStringImpl(new Object[]{request.getRequestURI()}, new String[]{"error: Invalid JSON request: ", "."}), false, e));
                    }
                    break block32;
                }
                if (e instanceof AccessControlException) {
                    JsonCommandServlet.sendJsonResponse(request, response, new Envelope("error: Your session with our website appears to have ended.  Please log out and back in.", false, e));
                    break block32;
                }
                JsonCommandServlet.sendJsonResponse(request, response, envelope);
            }
            return;
        }
        if (!response.isCommitted()) {
            long start = System.nanoTime();
            JsonCommandServlet.sendJsonResponse(request, response, envelope);
            long end = System.nanoTime();
            long time = Math.round((double)(end - start) / 1000000.0);
            if (time > (long)2000) {
                Object v3;
                if (json.length() > 256) {
                    String string;
                    json = string = json.substring(0, 255);
                }
                if (log.isInfoEnabled()) {
                    log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{time, request.getPathInfo(), json}, new String[]{"[SLOW XFR - ", " ms] request: ", ", response: ", ""})));
                    v3 = null;
                } else {
                    v3 = null;
                }
            }
            if (log.isDebugEnabled()) {
                Object v4;
                if (log.isDebugEnabled()) {
                    log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{time, request.getPathInfo(), json}, new String[]{"[XFR - ", " ms] request: ", ", response: ", ""})));
                    v4 = null;
                } else {
                    v4 = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void sendJsonResponse(HttpServletRequest request, HttpServletResponse response, Envelope envelope) {
        try {
            if (response.isCommitted()) {
                return;
            }
        }
        catch (ThreadDeath t) {
            throw (Throwable)t;
        }
        catch (Throwable t) {
            Throwable throwable;
            t = throwable = JsonCommandServlet.getDeepestException(t);
            String msg = t.getClass().getName();
            if (t.getMessage() != null) {
                String string;
                msg = string = StringGroovyMethods.plus((String)msg, (CharSequence)StringGroovyMethods.plus((String)" ", (CharSequence)t.getMessage()));
            }
            if (t instanceof IOException) {
                if (ScriptBytecodeAdapter.compareEqual((Object)"org.apache.catalina.connector.ClientAbortException", (Object)t.getClass().getName())) {
                    log.info("Client aborted connection while processing JSON request.");
                    return;
                }
                if (!log.isWarnEnabled()) return;
                log.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{msg}, new String[]{"IOException - sending response: ", ""})), t);
                return;
            }
            if (!(t instanceof AccessControlException)) {
                log.warn("An unexpected exception occurred sending JSON response to client", t);
                return;
            }
            if (!log.isWarnEnabled()) return;
            log.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{msg}, new String[]{"AccessControlException - sending response: ", ""})));
            return;
        }
        {
            String string = "application/json";
            response.setContentType(string);
            response.setHeader("Cache-Control", "private, no-cache, no-store");
            JsonCommandServlet.writeResponse(request, response, envelope);
            return;
        }
    }

    private static void writeResponse(HttpServletRequest request, HttpServletResponse response, Envelope envelope) {
        String header = request.getHeader("Accept-Encoding");
        BufferedOutputStream outputStream = null;
        String string = header;
        Boolean bl = string != null ? Boolean.valueOf(string.contains("gzip")) : null;
        if (bl == null ? false : bl) {
            response.setHeader("Content-Encoding", "gzip");
            AdjustableGZIPOutputStream adjustableGZIPOutputStream = new AdjustableGZIPOutputStream((OutputStream)new BufferedOutputStream((OutputStream)response.getOutputStream()), Deflater.BEST_SPEED);
            outputStream = adjustableGZIPOutputStream;
        } else {
            BufferedOutputStream bufferedOutputStream;
            outputStream = bufferedOutputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
        }
        JsonWriter writer = new JsonWriter((OutputStream)outputStream);
        Map map = (Map)ScriptBytecodeAdapter.asType((Object)envelope, Map.class);
        writer.write((Object)map);
        writer.flush();
        writer.close();
    }

    public static Throwable getDeepestException(Throwable e) {
        while (e.getCause() != null) {
            Throwable throwable;
            e = throwable = e.getCause();
        }
        if (!(e instanceof AccessControlException || e instanceof IOException)) {
            log.warn("Exception occurred: ", e);
        } else {
            Object v0;
            String msg = e.getClass().getName();
            if (e.getMessage() != null) {
                String string;
                msg = string = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)msg, (CharSequence)" "), (CharSequence)e.getMessage());
            }
            if (log.isWarnEnabled()) {
                log.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{msg}, new String[]{"Exception occurred: ", ""})));
                v0 = null;
            } else {
                v0 = null;
            }
        }
        return e;
    }

    private static Map buildLogMessages(Throwable t, String startPattern) {
        LinkedHashMap output = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"log", JsonCommandServlet.buildStack(t, startPattern)}), LinkedHashMap.class);
        StringBuilder sb = new StringBuilder();
        while (t != null) {
            Throwable throwable;
            boolean isEmpty = sb.length() == 0;
            String msg = t.getMessage();
            if (StringUtilities.isEmpty((String)msg)) {
                GStringImpl gStringImpl = new GStringImpl(new Object[]{t.getClass().getName()}, new String[]{"", ""});
                msg = ShortTypeHandling.castToString((Object)gStringImpl);
            }
            sb.append((CharSequence)(isEmpty ? msg : new GStringImpl(new Object[]{msg}, new String[]{"  Caused by ", ""})));
            sb.append("\n\n");
            t = throwable = t.getCause();
        }
        String string = sb.toString();
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)output, (String)"msg");
        return output;
    }

    private static String buildStack(Throwable t, String startPattern) {
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (DefaultTypeTransformation.booleanUnbox((Object)t)) {
            Throwable throwable;
            String msg = t.getMessage();
            if (StringUtilities.isEmpty((String)msg)) {
                String string;
                msg = string = "(no message)";
            }
            int n = i;
            int cfr_ignored_0 = n + 1;
            if (n == 0) {
                s.append((CharSequence)new GStringImpl(new Object[]{t.getClass().getName(), msg}, new String[]{"", ": ", "\n"}));
            } else {
                s.append((CharSequence)new GStringImpl(new Object[]{t.getClass().getName(), msg}, new String[]{"\n  Caused by ", ": ", "\n"}));
            }
            StackTraceElement[] stack = JsonCommandServlet.trimStack(t, startPattern);
            StackTraceElement[] nextStack = JsonCommandServlet.trimStack(t.getCause(), startPattern);
            s.append(JsonCommandServlet.trace(stack, nextStack));
            t = throwable = t.getCause();
        }
        return s.toString();
    }

    private static String trace(StackTraceElement[] stackTrace, StackTraceElement ... nextStrackTrace) {
        StringBuilder s = new StringBuilder();
        int len = stackTrace.length;
        int i = 0;
        while (i < len) {
            s.append("    ");
            StackTraceElement element = (StackTraceElement)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])stackTrace, (int)i), StackTraceElement.class);
            if (JsonCommandServlet.alreadyExists(element, nextStrackTrace)) {
                s.append("...");
                return s.toString();
            }
            s.append(element.toString());
            s.append("\n");
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        return s.toString();
    }

    private static boolean alreadyExists(StackTraceElement element, StackTraceElement ... stackTrace) {
        if (ArrayUtilities.isEmpty((Object)stackTrace)) {
            return false;
        }
        StackTraceElement traceElement2 = null;
        StackTraceElement[] stackTraceElementArray = stackTrace;
        if (stackTrace != null) {
            for (StackTraceElement traceElement2 : stackTraceElementArray) {
                if (!ScriptBytecodeAdapter.compareEqual((Object)element, (Object)traceElement2)) continue;
                return true;
            }
        }
        return false;
    }

    private static StackTraceElement[] trimStack(Throwable t, String startPattern) {
        if (t == null) {
            return (StackTraceElement[])ScriptBytecodeAdapter.castToType(null, StackTraceElement[].class);
        }
        Object[] elements = t.getStackTrace();
        int len = elements.length;
        LinkedList messages = (LinkedList)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), LinkedList.class);
        int i = 0;
        while (i < len) {
            messages.add(BytecodeInterface8.objectArrayGet((Object[])elements, (int)i));
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        boolean found = false;
        Iterator i2 = messages.descendingIterator();
        LinkedList trimmed = (LinkedList)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), LinkedList.class);
        while (i2.hasNext()) {
            StackTraceElement stackEntry = (StackTraceElement)ScriptBytecodeAdapter.castToType(i2.next(), StackTraceElement.class);
            if (stackEntry.toString().startsWith(startPattern)) {
                boolean bl;
                found = bl = true;
            }
            if (!found) continue;
            trimmed.push(stackEntry);
        }
        if (!found) {
            LinkedList linkedList;
            trimmed = linkedList = messages;
        }
        StackTraceElement[] array = new StackTraceElement[]{};
        return (StackTraceElement[])trimmed.toArray((Object[])ScriptBytecodeAdapter.castToType((Object)array, Object[].class));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != JsonCommandServlet.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        ThreadLocal threadLocal = new ThreadLocal();
        servletRequest = threadLocal;
        ThreadLocal threadLocal2 = new ThreadLocal();
        servletResponse = threadLocal2;
        log = logger = LoggerFactory.getLogger((String)"com.cedarsoftware.servlet.JsonCommandServlet");
    }
}

