/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.servlet;

import com.cedarsoftware.servlet.ConfigurationProvider;
import com.cedarsoftware.servlet.Envelope;
import com.cedarsoftware.util.AdjustableGZIPOutputStream;
import com.cedarsoftware.util.ArrayUtilities;
import com.cedarsoftware.util.IOUtilities;
import com.cedarsoftware.util.StringUtilities;
import com.cedarsoftware.util.io.JsonIoException;
import com.cedarsoftware.util.io.JsonWriter;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import java.security.AccessControlException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.zip.Deflater;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonCommandServlet
extends HttpServlet
implements GroovyObject {
    public static final ThreadLocal<HttpServletRequest> servletRequest;
    public static final ThreadLocal<HttpServletResponse> servletResponse;
    private ConfigurationProvider configProvider;
    private static final Logger LOG;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public JsonCommandServlet() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public void init() {
        try {
            ConfigurationProvider configurationProvider;
            this.configProvider = configurationProvider = new ConfigurationProvider(this.getServletConfig());
        }
        catch (Exception e) {
            LOG.error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{e.getMessage()}, new String[]{"Unable to set up SpringConfigurationProvider: ", ""})), (Throwable)e);
        }
        LOG.info("JsonCommandServlet init complete");
    }

    public void route(HttpServletRequest request, HttpServletResponse response) {
        if ("post".equalsIgnoreCase(request.getMethod())) {
            this.doPost(request, response);
        } else if ("get".equalsIgnoreCase(request.getMethod())) {
            this.doGet(request, response);
        } else if ("head".equalsIgnoreCase(request.getMethod())) {
            this.doHead(request, response);
        } else if ("put".equalsIgnoreCase(request.getMethod())) {
            this.doPut(request, response);
        } else if ("delete".equalsIgnoreCase(request.getMethod())) {
            this.doDelete(request, response);
        } else if ("options".equalsIgnoreCase(request.getMethod())) {
            this.doOptions(request, response);
        } else if ("trace".equalsIgnoreCase(request.getMethod())) {
            this.doTrace(request, response);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            String string;
            servletRequest.set(request);
            servletResponse.set(response);
            String json = request.getParameter("json");
            if (json == null || json.trim().length() < 1) {
                String msg = "error: HTTP-GET had empty or no 'json=' argument.";
                LOG.info(msg);
                JsonCommandServlet.sendJsonResponse(request, response, new Envelope(msg, false));
                return;
            }
            json = string = URLDecoder.decode(json, "UTF-8");
            if (LOG.isDebugEnabled()) {
                LOG.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{request.getPathInfo(), json}, new String[]{"HTTP GET(", "), json=", ""})));
            }
            this.handleRequestAndResponse(request, response, json);
        }
        finally {
            JsonCommandServlet.removeThreadLocals();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        JsonCommandServlet.servletRequest.set(request);
        JsonCommandServlet.servletResponse.set(response);
        if (!(request.getContentLength() < 1)) ** GOTO lbl20
        msg = "error: Call to server had incorrect Content-Length specified.";
        JsonCommandServlet.LOG.info(msg);
        JsonCommandServlet.sendJsonResponse(request, response, new Envelope(msg, false));
        JsonCommandServlet.removeThreadLocals();
        try {
            try {
                return;
lbl20:
                // 1 sources

                jsonBytes = new byte[request.getContentLength()];
                IOUtilities.transfer((InputStream)new BufferedInputStream((InputStream)request.getInputStream()), (byte[])jsonBytes);
                json = new String(IOUtilities.uncompressBytes((byte[])jsonBytes), "UTF-8");
                if (JsonCommandServlet.LOG.isDebugEnabled()) {
                    JsonCommandServlet.LOG.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{request.getPathInfo(), json}, new String[]{"HTTP POST(", "), body=", ""})));
                }
                this.handleRequestAndResponse(request, response, json);
            }
            catch (Exception e) {
                msg = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{request.getRequestURI(), e.getMessage()}, new String[]{"error: Unable to read HTTP-POST JSON content from URI: ", ". Message: ", ""}));
                JsonCommandServlet.LOG.warn(msg);
                JsonCommandServlet.sendJsonResponse(request, response, new Envelope(msg, false, e));
            }
        }
        catch (Throwable var8_8) {
            throw var8_8;
        }
        finally {
            JsonCommandServlet.removeThreadLocals();
        }
    }

    private static void removeThreadLocals() {
        servletRequest.remove();
        servletResponse.remove();
    }

    private Object getController(HttpServletRequest request) {
        Matcher matcher = ConfigurationProvider.getUrlMatcher(request);
        if (matcher == null) {
            throw (Throwable)new IllegalArgumentException("error: Invalid JSON request - /controller/method not specified");
        }
        String controllerName = matcher.group(1);
        ConfigurationProvider configurationProvider = this.configProvider;
        Object controller = configurationProvider != null ? configurationProvider.getController(controllerName) : null;
        return controller;
    }

    private void handleRequestAndResponse(HttpServletRequest request, HttpServletResponse response, String json) {
        Envelope envelope = null;
        Object controller = null;
        try {
            Envelope envelope2;
            Object object;
            controller = object = this.getController(request);
            Object result = this.configProvider.callController(controller, request, json);
            envelope = envelope2 = new Envelope(result, true);
        }
        catch (ThreadDeath d) {
            throw (Throwable)d;
        }
        catch (Throwable e) {
            Envelope envelope3;
            Map altMsg = null;
            if (e instanceof InvocationTargetException) {
                Map map;
                Throwable throwable;
                Object[] pieces = null;
                if (DefaultTypeTransformation.booleanUnbox((Object)controller)) {
                    String[] stringArray = DefaultGroovyMethods.inspect((Object)controller).split("@");
                    pieces = stringArray;
                } else {
                    Object[] objectArray;
                    pieces = objectArray = new String[1];
                    String string = JsonCommandServlet.class.getName();
                    BytecodeInterface8.objectArraySet((Object[])pieces, (int)0, (Object)string);
                }
                e = throwable = e.getCause();
                altMsg = map = JsonCommandServlet.buildLogMessages(e, StringGroovyMethods.plus((String)ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])pieces, (int)0)), (CharSequence)"."));
                LOG.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{request.getRequestURI(), altMsg.get("log")}, new String[]{"Controller threw an exception, request: ", ":\n", ""})));
            } else if (e instanceof IllegalArgumentException || e instanceof JsonIoException) {
                LOG.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{e.getMessage(), request.getRequestURI(), json}, new String[]{"", "\n  URI: ", "\n  JSON argument: ", ""})));
            } else {
                LOG.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{request.getRequestURI()}, new String[]{"Unexpected exception, request: ", ":"})), e);
            }
            String string = altMsg == null ? null : (String)altMsg.get("msg");
            String msg = ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox(string) ? string : e.getMessage()));
            if (StringUtilities.isEmpty((String)msg)) {
                String string2;
                msg = string2 = e.getClass().getName();
            }
            envelope = envelope3 = new Envelope(new GStringImpl(new Object[]{msg, request.getRequestURI()}, new String[]{"", " from URI: ", ""}), false, e);
            if (e instanceof IOException) {
                if (ScriptBytecodeAdapter.compareEqual((Object)"org.apache.catalina.connector.ClientAbortException", (Object)e.getClass().getName())) {
                    LOG.info("Client aborted connection while processing JSON request.");
                } else {
                    JsonCommandServlet.sendJsonResponse(request, response, new Envelope(new GStringImpl(new Object[]{request.getRequestURI()}, new String[]{"error: Invalid JSON request made from URI: ", "."}), false, e));
                }
            } else if (e instanceof AccessControlException) {
                JsonCommandServlet.sendJsonResponse(request, response, new Envelope("error: Your session with our website appears to have ended.  Please log out and back in.", false, e));
            } else {
                JsonCommandServlet.sendJsonResponse(request, response, envelope);
            }
            return;
        }
        if (!response.isCommitted()) {
            long start = System.nanoTime();
            JsonCommandServlet.sendJsonResponse(request, response, envelope);
            long end = System.nanoTime();
            if (end - start > (long)2000000000) {
                if (json.length() > 256) {
                    String string;
                    json = string = json.substring(0, 255);
                }
                long time = Math.round((double)(end - start) / 1000000.0);
                LOG.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{time, json}, new String[]{"[SLOW - ", " ms] response: ", ""})));
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void sendJsonResponse(HttpServletRequest request, HttpServletResponse response, Envelope envelope) {
        try {
            if (response.isCommitted()) {
                return;
            }
        }
        catch (ThreadDeath t) {
            throw (Throwable)t;
        }
        catch (Throwable t) {
            Throwable throwable;
            t = throwable = JsonCommandServlet.getDeepestException(t);
            String msg = t.getClass().getName();
            if (t.getMessage() != null) {
                String string;
                msg = string = StringGroovyMethods.plus((String)msg, (CharSequence)StringGroovyMethods.plus((String)" ", (CharSequence)t.getMessage()));
            }
            if (t instanceof IOException) {
                if (ScriptBytecodeAdapter.compareEqual((Object)"org.apache.catalina.connector.ClientAbortException", (Object)t.getClass().getName())) {
                    LOG.info("Client aborted connection while processing JSON request.");
                    return;
                }
                LOG.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{msg}, new String[]{"IOException - sending response: ", ""})));
                return;
            }
            if (t instanceof AccessControlException) {
                LOG.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{msg}, new String[]{"AccessControlException - sending response: ", ""})));
                return;
            }
            LOG.warn("An unexpected exception occurred sending JSON response to client", t);
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        {
            String string = "application/json";
            response.setContentType(string);
            response.setHeader("Cache-Control", "private, no-cache, no-store");
            JsonCommandServlet.writeResponse(request, response, envelope);
            return;
        }
    }

    private static void writeResponse(HttpServletRequest request, HttpServletResponse response, Envelope envelope) {
        String header = request.getHeader("Accept-Encoding");
        BufferedOutputStream outputStream = null;
        String string = header;
        Boolean bl = string != null ? Boolean.valueOf(string.contains("gzip")) : null;
        if (bl == null ? false : bl) {
            response.setHeader("Content-Encoding", "gzip");
            AdjustableGZIPOutputStream adjustableGZIPOutputStream = new AdjustableGZIPOutputStream((OutputStream)new BufferedOutputStream((OutputStream)response.getOutputStream()), Deflater.BEST_SPEED);
            outputStream = adjustableGZIPOutputStream;
        } else {
            BufferedOutputStream bufferedOutputStream;
            outputStream = bufferedOutputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
        }
        JsonWriter writer = new JsonWriter((OutputStream)outputStream);
        Map map = (Map)ScriptBytecodeAdapter.asType((Object)envelope, Map.class);
        writer.write((Object)map);
        writer.flush();
        writer.close();
    }

    private static String getExceptionAsJsonObjectString(Throwable t) {
        if (t == null) {
            return "null";
        }
        String json = JsonWriter.objectToJson((Object)t);
        String string = json;
        try {
            return string;
        }
        catch (Exception e) {
            String json2 = JsonWriter.objectToJson((Object)new RuntimeException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{e.getMessage(), t.getClass().getName()}, new String[]{"Unable to serialize exception. Exception message: ", ", type: ", ""}))));
            String string2 = json2;
            return string2;
        }
    }

    public static Throwable getDeepestException(Throwable e) {
        while (e.getCause() != null) {
            Throwable throwable;
            e = throwable = e.getCause();
        }
        if (!(e instanceof AccessControlException || e instanceof IOException)) {
            LOG.warn("Exception occurred: ", (Object)e);
        } else {
            String msg = e.getClass().getName();
            if (e.getMessage() != null) {
                String string;
                msg = string = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)msg, (CharSequence)" "), (CharSequence)e.getMessage());
            }
            LOG.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{msg}, new String[]{"Exception occurred: ", ""})));
        }
        return e;
    }

    private static Map buildLogMessages(Throwable t, String startPattern) {
        LinkedHashMap output = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"log", JsonCommandServlet.buildStack(t, startPattern)}), LinkedHashMap.class);
        StringBuilder sb = new StringBuilder();
        while (t != null) {
            Throwable throwable;
            boolean isEmpty = sb.length() == 0;
            String msg = t.getMessage();
            if (StringUtilities.isEmpty((String)msg)) {
                GStringImpl gStringImpl = new GStringImpl(new Object[]{t.getClass().getName()}, new String[]{"", ""});
                msg = ShortTypeHandling.castToString((Object)gStringImpl);
            }
            sb.append((CharSequence)(isEmpty ? msg : new GStringImpl(new Object[]{msg}, new String[]{"  Caused by ", ""})));
            sb.append("\n\n");
            t = throwable = t.getCause();
        }
        String string = sb.toString();
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)output, (String)"msg");
        return output;
    }

    private static String buildStack(Throwable t, String startPattern) {
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (DefaultTypeTransformation.booleanUnbox((Object)t)) {
            Throwable throwable;
            String msg = t.getMessage();
            if (StringUtilities.isEmpty((String)msg)) {
                String string;
                msg = string = "(no message)";
            }
            int n = i;
            int cfr_ignored_0 = n + 1;
            if (n == 0) {
                s.append((CharSequence)new GStringImpl(new Object[]{t.getClass().getName(), msg}, new String[]{"", ": ", "\n"}));
            } else {
                s.append((CharSequence)new GStringImpl(new Object[]{t.getClass().getName(), msg}, new String[]{"\n  Caused by ", ": ", "\n"}));
            }
            StackTraceElement[] stack = JsonCommandServlet.trimStack(t, startPattern);
            StackTraceElement[] nextStack = JsonCommandServlet.trimStack(t.getCause(), startPattern);
            s.append(JsonCommandServlet.trace(stack, nextStack));
            t = throwable = t.getCause();
        }
        return s.toString();
    }

    private static String trace(StackTraceElement[] stackTrace, StackTraceElement ... nextStrackTrace) {
        StringBuilder s = new StringBuilder();
        int len = stackTrace.length;
        int i = 0;
        while (i < len) {
            s.append("    ");
            StackTraceElement element = (StackTraceElement)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])stackTrace, (int)i), StackTraceElement.class);
            if (JsonCommandServlet.alreadyExists(element, nextStrackTrace)) {
                s.append("...");
                return s.toString();
            }
            s.append(element.toString());
            s.append("\n");
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        return s.toString();
    }

    private static boolean alreadyExists(StackTraceElement element, StackTraceElement ... stackTrace) {
        if (ArrayUtilities.isEmpty((Object)stackTrace)) {
            return false;
        }
        StackTraceElement traceElement2 = null;
        StackTraceElement[] stackTraceElementArray = stackTrace;
        if (stackTrace != null) {
            for (StackTraceElement traceElement2 : stackTraceElementArray) {
                if (!ScriptBytecodeAdapter.compareEqual((Object)element, (Object)traceElement2)) continue;
                return true;
            }
        }
        return false;
    }

    private static StackTraceElement[] trimStack(Throwable t, String startPattern) {
        if (t == null) {
            return (StackTraceElement[])ScriptBytecodeAdapter.castToType(null, StackTraceElement[].class);
        }
        Object[] elements = t.getStackTrace();
        int len = elements.length;
        LinkedList<Object> messages = new LinkedList<Object>();
        int i = 0;
        while (i < len) {
            messages.add(BytecodeInterface8.objectArrayGet((Object[])elements, (int)i));
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        boolean found = false;
        Iterator i2 = messages.descendingIterator();
        LinkedList<StackTraceElement> trimmed = new LinkedList<StackTraceElement>();
        while (i2.hasNext()) {
            StackTraceElement stackEntry = (StackTraceElement)ScriptBytecodeAdapter.castToType(i2.next(), StackTraceElement.class);
            if (stackEntry.toString().startsWith(startPattern)) {
                boolean bl;
                found = bl = true;
            }
            if (!found) continue;
            trimmed.push(stackEntry);
        }
        if (!found) {
            LinkedList<Object> linkedList = messages;
            trimmed = linkedList;
        }
        return (StackTraceElement[])ScriptBytecodeAdapter.castToType((Object)trimmed.toArray((Object[])ScriptBytecodeAdapter.castToType((Object)new StackTraceElement[0], Object[].class)), StackTraceElement[].class);
    }

    public static /* synthetic */ void access$0(JsonCommandServlet $that, HttpServletRequest param0, HttpServletResponse param1) throws ServletException, IOException {
        $that.doDelete(param0, param1);
    }

    public static /* synthetic */ void access$1(JsonCommandServlet $that, HttpServletRequest param0, HttpServletResponse param1) throws ServletException, IOException {
        $that.doTrace(param0, param1);
    }

    public static /* synthetic */ void access$2(JsonCommandServlet $that, HttpServletRequest param0, HttpServletResponse param1) throws ServletException, IOException {
        $that.doOptions(param0, param1);
    }

    public static /* synthetic */ void access$3(JsonCommandServlet $that, HttpServletRequest param0, HttpServletResponse param1) throws ServletException, IOException {
        $that.doHead(param0, param1);
    }

    public static /* synthetic */ void access$4(JsonCommandServlet $that, HttpServletRequest param0, HttpServletResponse param1) throws ServletException, IOException {
        $that.doPut(param0, param1);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != JsonCommandServlet.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        ThreadLocal threadLocal = new ThreadLocal();
        servletRequest = threadLocal;
        ThreadLocal threadLocal2 = new ThreadLocal();
        servletResponse = threadLocal2;
        LOG = logger = LoggerFactory.getLogger(JsonCommandServlet.class);
    }
}

