/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.servlet;

import com.cedarsoftware.servlet.ConfigurationProvider;
import com.cedarsoftware.servlet.Envelope;
import com.cedarsoftware.util.IOUtilities;
import com.cedarsoftware.util.StringUtilities;
import com.cedarsoftware.util.io.JsonIoException;
import com.cedarsoftware.util.io.JsonWriter;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import java.security.AccessControlException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Matcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberDiv;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonCommandServlet
extends HttpServlet
implements GroovyObject {
    public static final ThreadLocal<HttpServletRequest> servletRequest;
    public static final ThreadLocal<HttpServletResponse> servletResponse;
    private ConfigurationProvider configProvider;
    private static final Logger LOG;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public JsonCommandServlet() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public void init() {
        try {
            ConfigurationProvider configurationProvider;
            this.configProvider = configurationProvider = new ConfigurationProvider(this.getServletConfig());
        }
        catch (Exception e) {
            LOG.error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{e.getMessage()}, new String[]{"Unable to set up SpringConfigurationProvider: ", ""})), (Throwable)e);
        }
        LOG.info("JsonCommandServlet init complete");
    }

    public void route(HttpServletRequest request, HttpServletResponse response) {
        if ("post".equalsIgnoreCase(request.getMethod())) {
            this.doPost(request, response);
        } else if ("get".equalsIgnoreCase(request.getMethod())) {
            this.doGet(request, response);
        } else if ("head".equalsIgnoreCase(request.getMethod())) {
            this.doHead(request, response);
        } else if ("put".equalsIgnoreCase(request.getMethod())) {
            this.doPut(request, response);
        } else if ("delete".equalsIgnoreCase(request.getMethod())) {
            this.doDelete(request, response);
        } else if ("options".equalsIgnoreCase(request.getMethod())) {
            this.doOptions(request, response);
        } else if ("trace".equalsIgnoreCase(request.getMethod())) {
            this.doTrace(request, response);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            String string;
            servletRequest.set(request);
            servletResponse.set(response);
            String json = request.getParameter("json");
            if (json == null || json.trim().length() < 1) {
                String msg = "error: HTTP-GET had empty or no 'json=' argument.";
                LOG.info(msg);
                JsonCommandServlet.sendJsonResponse(request, response, new Envelope(msg, false));
                return;
            }
            json = string = URLDecoder.decode(json, "UTF-8");
            if (LOG.isDebugEnabled()) {
                LOG.debug("GET RESTful JSON");
            }
            this.handleRequestAndResponse(request, response, json);
        }
        finally {
            JsonCommandServlet.removeThreadLocals();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        JsonCommandServlet.servletRequest.set(request);
        JsonCommandServlet.servletResponse.set(response);
        if (!(request.getContentLength() < 1)) ** GOTO lbl20
        msg = "error: Call to server had incorrect Content-Length specified.";
        JsonCommandServlet.LOG.info(msg);
        JsonCommandServlet.sendJsonResponse(request, response, new Envelope(msg, false));
        JsonCommandServlet.removeThreadLocals();
        try {
            try {
                return;
lbl20:
                // 1 sources

                jsonBytes = new byte[request.getContentLength()];
                IOUtilities.transfer((InputStream)request.getInputStream(), (byte[])jsonBytes);
                json = new String(jsonBytes, "UTF-8");
                if (JsonCommandServlet.LOG.isDebugEnabled()) {
                    JsonCommandServlet.LOG.debug("POST RESTful JSON");
                }
                this.handleRequestAndResponse(request, response, json);
            }
            catch (Exception e) {
                msg = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{request.getRequestURI(), e.getMessage()}, new String[]{"error: Unable to read HTTP-POST JSON content from URI: ", ". Message: ", ""}));
                JsonCommandServlet.LOG.warn(msg);
                JsonCommandServlet.sendJsonResponse(request, response, new Envelope(msg, false, e));
            }
        }
        catch (Throwable var8_8) {
            throw var8_8;
        }
        finally {
            JsonCommandServlet.removeThreadLocals();
        }
    }

    private static void removeThreadLocals() {
        servletRequest.remove();
        servletResponse.remove();
    }

    private Object getController(HttpServletRequest request, String json) {
        Matcher matcher = ConfigurationProvider.getUrlMatcher(request);
        if (matcher == null) {
            throw (Throwable)new IllegalArgumentException("error: Invalid JSON request - /controller/method not specified");
        }
        String controllerName = matcher.group(1);
        ConfigurationProvider configurationProvider = this.configProvider;
        Object controller = configurationProvider != null ? configurationProvider.getController(controllerName) : null;
        return controller;
    }

    private void handleRequestAndResponse(HttpServletRequest request, HttpServletResponse response, String json) {
        Envelope envelope = null;
        Object controller = null;
        try {
            Envelope envelope2;
            Object object;
            controller = object = this.getController(request, json);
            Object result = this.configProvider.callController(controller, request, json);
            envelope = envelope2 = new Envelope(result, true);
        }
        catch (ThreadDeath d) {
            throw (Throwable)d;
        }
        catch (Throwable e) {
            Envelope envelope3;
            if (e instanceof InvocationTargetException) {
                Throwable throwable;
                e = throwable = e.getCause();
                if (e.getCause() == null) {
                    if (DefaultTypeTransformation.booleanUnbox((Object)controller)) {
                        Object[] pieces = DefaultGroovyMethods.inspect((Object)controller).split("@");
                        LOG.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{request.getRequestURI(), JsonCommandServlet.stackToString(e, StringGroovyMethods.plus((String)ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])pieces, (int)0)), (CharSequence)"."))}, new String[]{"Controller threw an exception, request: ", "\n\n", ""})));
                    } else {
                        LOG.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{request.getRequestURI()}, new String[]{"Controller threw an exception, request: ", ""})), e);
                    }
                } else {
                    LOG.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{request.getRequestURI()}, new String[]{"Controller threw an exception, request: ", ""})), e);
                }
            } else if (e instanceof IllegalArgumentException || e instanceof JsonIoException) {
                LOG.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{e.getMessage(), request.getRequestURI(), json}, new String[]{"", "\n  URI: ", "\n  JSON argument: ", ""})));
            } else {
                LOG.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{request.getRequestURI()}, new String[]{"Unexpected exception, request: ", ":"})), e);
            }
            String msg = e.getMessage();
            if (StringUtilities.isEmpty((String)msg)) {
                String string;
                msg = string = e.getClass().getName();
            }
            envelope = envelope3 = new Envelope(new GStringImpl(new Object[]{msg, request.getRequestURI()}, new String[]{"", " from URI: ", ""}), false, e);
            if (e instanceof IOException) {
                if (ScriptBytecodeAdapter.compareEqual((Object)"org.apache.catalina.connector.ClientAbortException", (Object)e.getClass().getName())) {
                    LOG.info("Client aborted connection while processing JSON request.");
                } else {
                    JsonCommandServlet.sendJsonResponse(request, response, new Envelope(new GStringImpl(new Object[]{request.getRequestURI()}, new String[]{"error: Invalid JSON request made from URI: ", "."}), false, e));
                }
            } else if (e instanceof AccessControlException) {
                JsonCommandServlet.sendJsonResponse(request, response, new Envelope("error: Your session with our website appears to have ended.  Please log out and back in.", false, e));
            } else {
                JsonCommandServlet.sendJsonResponse(request, response, envelope);
            }
            return;
        }
        if (!response.isCommitted()) {
            long start = System.nanoTime();
            JsonCommandServlet.sendJsonResponse(request, response, envelope);
            long end = System.nanoTime();
            if (end - start > (long)2000000000) {
                if (json.length() > 256) {
                    String string;
                    json = string = json.substring(0, 255);
                }
                LOG.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{NumberNumberDiv.div((Number)(end - start), (Number)1000000), json}, new String[]{"[SLOW - ", " ms] response: ", ""})));
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void sendJsonResponse(HttpServletRequest request, HttpServletResponse response, Envelope envelope) {
        try {
            if (response.isCommitted()) {
                return;
            }
        }
        catch (ThreadDeath t) {
            throw (Throwable)t;
        }
        catch (Throwable t) {
            Throwable throwable;
            t = throwable = JsonCommandServlet.getDeepestException(t);
            String msg = t.getClass().getName();
            if (t.getMessage() != null) {
                String string;
                msg = string = StringGroovyMethods.plus((String)msg, (CharSequence)StringGroovyMethods.plus((String)" ", (CharSequence)t.getMessage()));
            }
            if (t instanceof IOException) {
                if (ScriptBytecodeAdapter.compareEqual((Object)"org.apache.catalina.connector.ClientAbortException", (Object)t.getClass().getName())) {
                    LOG.info("Client aborted connection while processing JSON request.");
                    return;
                }
                LOG.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{msg}, new String[]{"IOException - sending response: ", ""})));
                return;
            }
            if (t instanceof AccessControlException) {
                LOG.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{msg}, new String[]{"AccessControlException - sending response: ", ""})));
                return;
            }
            LOG.warn("An unexpected exception occurred sending JSON response to client", t);
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        {
            String json = JsonCommandServlet.buildResponse(request, response, envelope);
            JsonCommandServlet.writeResponse(request, response, json);
            return;
        }
    }

    private static String buildResponse(HttpServletRequest request, HttpServletResponse response, Envelope envelope) {
        String string = "application/json";
        response.setContentType(string);
        response.setHeader("Cache-Control", "private, no-cache, no-store");
        String retJson = JsonWriter.objectToJson((Object)new Object[]{envelope.getData()});
        StringBuilder s = new StringBuilder("{\"data\":");
        if (ScriptBytecodeAdapter.compareEqual((Object)"[]", (Object)retJson)) {
            s.append("null");
        } else {
            s.append(retJson.substring(1, retJson.length() - 1));
        }
        s.append(",\"status\":");
        s.append(envelope.getStatus());
        if (envelope.getException() != null) {
            s.append(",\"exception\":");
            s.append(JsonCommandServlet.getExceptionAsJsonObjectString(envelope.getException()));
        }
        s.append("}");
        return s.toString();
    }

    private static void writeResponse(HttpServletRequest request, HttpServletResponse response, String json) {
        ByteArrayOutputStream jsonBytes = new ByteArrayOutputStream();
        jsonBytes.write(json.getBytes("UTF-8"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{StringUtilities.createUtf8String((byte[])jsonBytes.toByteArray())}, new String[]{"  return ", ""})));
        }
        String header = request.getHeader("Accept-Encoding");
        if (jsonBytes.size() > 512 && header != null && header.contains("gzip")) {
            ByteArrayOutputStream compressedBytes = new ByteArrayOutputStream(jsonBytes.size());
            IOUtilities.compressBytes((ByteArrayOutputStream)jsonBytes, (ByteArrayOutputStream)compressedBytes);
            if (compressedBytes.size() < jsonBytes.size()) {
                ByteArrayOutputStream byteArrayOutputStream;
                response.setHeader("Content-Encoding", "gzip");
                jsonBytes = byteArrayOutputStream = compressedBytes;
            }
        }
        int n = jsonBytes.size();
        response.setContentLength(n);
        BufferedOutputStream output = new BufferedOutputStream((OutputStream)response.getOutputStream());
        jsonBytes.writeTo(output);
        output.flush();
    }

    private static String getExceptionAsJsonObjectString(Throwable t) {
        if (t == null) {
            return "null";
        }
        String json = JsonWriter.objectToJson((Object)t);
        String string = json;
        try {
            return string;
        }
        catch (Exception e) {
            String json2 = JsonWriter.objectToJson((Object)new RuntimeException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{e.getMessage(), t.getClass().getName()}, new String[]{"Unable to serialize exception. Exception message: ", ", type: ", ""}))));
            String string2 = json2;
            return string2;
        }
    }

    public static Throwable getDeepestException(Throwable e) {
        while (e.getCause() != null) {
            Throwable throwable;
            e = throwable = e.getCause();
        }
        if (!(e instanceof AccessControlException || e instanceof IOException)) {
            LOG.warn("Exception occurred: ", (Object)e);
        } else {
            String msg = e.getClass().getName();
            if (e.getMessage() != null) {
                String string;
                msg = string = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)msg, (CharSequence)" "), (CharSequence)e.getMessage());
            }
            LOG.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{msg}, new String[]{"Exception occurred: ", ""})));
        }
        return e;
    }

    public static String stackToString(Throwable t, String startPattern) {
        Object[] elements = t.getStackTrace();
        int len = elements.length;
        LinkedList<String> messages = new LinkedList<String>();
        int i = 0;
        while (i < len) {
            messages.add(((StackTraceElement)BytecodeInterface8.objectArrayGet((Object[])elements, (int)i)).toString());
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        boolean found = false;
        Iterator i2 = messages.descendingIterator();
        LinkedList<String> trimmed = new LinkedList<String>();
        while (i2.hasNext()) {
            String stackEntry = ShortTypeHandling.castToString(i2.next());
            if (stackEntry.contains(startPattern)) {
                boolean bl;
                found = bl = true;
            }
            if (!found) continue;
            trimmed.push(stackEntry);
        }
        if (!found) {
            Iterator iterator = messages.descendingIterator();
            i2 = iterator;
        } else {
            Iterator iterator = trimmed.iterator();
            i2 = iterator;
        }
        messages.clear();
        StringBuilder s = new StringBuilder();
        s.append((CharSequence)new GStringImpl(new Object[]{t.getClass().getName(), t.getMessage()}, new String[]{"", ": ", "\n"}));
        while (i2.hasNext()) {
            s.append((CharSequence)new GStringImpl(new Object[]{i2.next()}, new String[]{"    ", "\n"}));
        }
        s.append("    ...");
        return ShortTypeHandling.castToString((Object)s);
    }

    public static /* synthetic */ void access$0(JsonCommandServlet $that, HttpServletRequest param0, HttpServletResponse param1) throws ServletException, IOException {
        $that.doDelete(param0, param1);
    }

    public static /* synthetic */ void access$1(JsonCommandServlet $that, HttpServletRequest param0, HttpServletResponse param1) throws ServletException, IOException {
        $that.doTrace(param0, param1);
    }

    public static /* synthetic */ void access$2(JsonCommandServlet $that, HttpServletRequest param0, HttpServletResponse param1) throws ServletException, IOException {
        $that.doOptions(param0, param1);
    }

    public static /* synthetic */ void access$3(JsonCommandServlet $that, HttpServletRequest param0, HttpServletResponse param1) throws ServletException, IOException {
        $that.doHead(param0, param1);
    }

    public static /* synthetic */ void access$4(JsonCommandServlet $that, HttpServletRequest param0, HttpServletResponse param1) throws ServletException, IOException {
        $that.doPut(param0, param1);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != JsonCommandServlet.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        ThreadLocal threadLocal = new ThreadLocal();
        servletRequest = threadLocal;
        ThreadLocal threadLocal2 = new ThreadLocal();
        servletResponse = threadLocal2;
        LOG = logger = LoggerFactory.getLogger(JsonCommandServlet.class);
    }
}

