/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.servlet;

import com.cedarsoftware.servlet.ConfigurationProvider;
import com.cedarsoftware.servlet.Envelope;
import com.cedarsoftware.servlet.SpringConfigurationProvider;
import com.cedarsoftware.util.IOUtilities;
import com.cedarsoftware.util.StringUtilities;
import com.cedarsoftware.util.io.JsonWriter;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.security.AccessControlException;
import java.util.regex.Matcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberDiv;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class JsonCommandServlet
extends HttpServlet
implements GroovyObject {
    public static final ThreadLocal<HttpServletRequest> servletRequest;
    public static final ThreadLocal<HttpServletResponse> servletResponse;
    public static final String ATTRIBUTE_STATUS = "status";
    public static final String ATTRIBUTE_FAIL_MESSAGE = "failMsg";
    private SpringConfigurationProvider springCfgProvider;
    private static final Logger LOG;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public JsonCommandServlet() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public void init() {
        try {
            SpringConfigurationProvider springConfigurationProvider;
            this.springCfgProvider = springConfigurationProvider = new SpringConfigurationProvider(this.getServletConfig());
        }
        catch (Exception e) {
            LOG.warn((CharSequence)new GStringImpl(new Object[]{e.getMessage()}, new String[]{"Unable to set up SpringConfigurationProvider: ", ""}), (Throwable)e);
        }
        LOG.info("JsonCommandServlet init complete");
    }

    public void route(HttpServletRequest request, HttpServletResponse response) {
        if ("post".equalsIgnoreCase(request.getMethod())) {
            this.doPost(request, response);
        } else if ("get".equalsIgnoreCase(request.getMethod())) {
            this.doGet(request, response);
        } else if ("head".equalsIgnoreCase(request.getMethod())) {
            this.doHead(request, response);
        } else if ("put".equalsIgnoreCase(request.getMethod())) {
            this.doPut(request, response);
        } else if ("delete".equalsIgnoreCase(request.getMethod())) {
            this.doDelete(request, response);
        } else if ("options".equalsIgnoreCase(request.getMethod())) {
            this.doOptions(request, response);
        } else if ("trace".equalsIgnoreCase(request.getMethod())) {
            this.doTrace(request, response);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            String string;
            request.setAttribute(ATTRIBUTE_STATUS, (Object)true);
            servletRequest.set(request);
            servletResponse.set(response);
            String json = request.getParameter("json");
            json = string = URLDecoder.decode(json, "UTF-8");
            if (json == null || json.trim().length() < 1) {
                JsonCommandServlet.sendJsonResponse(request, response, new Envelope("error: HTTP-GET had empty or no 'json' parameter.", false));
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("GET RESTful JSON");
            }
            this.handleRequestAndResponse(request, response, json);
        }
        finally {
            JsonCommandServlet.removeThreadLocals();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute(JsonCommandServlet.ATTRIBUTE_STATUS, (Object)true);
        JsonCommandServlet.servletRequest.set(request);
        JsonCommandServlet.servletResponse.set(response);
        if (!(request.getContentLength() < 1)) ** GOTO lbl18
        JsonCommandServlet.sendJsonResponse(request, response, new Envelope("error: Call to server had incorrect Content-Length specified.", false));
        JsonCommandServlet.removeThreadLocals();
        try {
            try {
                return;
lbl18:
                // 1 sources

                jsonBytes = new byte[request.getContentLength()];
                IOUtilities.transfer((InputStream)request.getInputStream(), (byte[])jsonBytes);
                json = URLDecoder.decode(new String(jsonBytes), "UTF-8");
                if (JsonCommandServlet.LOG.isDebugEnabled()) {
                    JsonCommandServlet.LOG.debug("POST RESTful JSON");
                }
                this.handleRequestAndResponse(request, response, json);
            }
            catch (Exception e) {
                JsonCommandServlet.sendJsonResponse(request, response, new Envelope(new GStringImpl(new Object[]{e.getMessage()}, new String[]{"error: Unable to read HTTP-POST JSON content. Message: ", ""}), false));
            }
        }
        catch (Throwable var6_6) {
            throw var6_6;
        }
        finally {
            JsonCommandServlet.removeThreadLocals();
        }
    }

    private static void removeThreadLocals() {
        servletRequest.remove();
        servletResponse.remove();
    }

    private Object getProvider(HttpServletRequest request, String json) {
        Matcher matcher = ConfigurationProvider.getUrlMatcher(request);
        if (matcher == null) {
            String msg = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{json}, new String[]{"error: Invalid JSON request - /controller/method not specified: ", ""}));
            LOG.warn(msg);
            return new Envelope(msg, false);
        }
        String controllerName = matcher.group(1);
        SpringConfigurationProvider springConfigurationProvider = this.springCfgProvider;
        Object var = springConfigurationProvider != null ? springConfigurationProvider.getController(controllerName) : null;
        if (var == null) {
            throw (Throwable)new IllegalStateException("You have no ConfigurationProviders set for the JsonCommandServlet.  It cannot route any HTTP Requests to controllers.");
        }
        return var instanceof Envelope ? var : this.springCfgProvider;
    }

    private void handleRequestAndResponse(HttpServletRequest request, HttpServletResponse response, String json) {
        Object envelope = null;
        try {
            Object provider = this.getProvider(request, json);
            if (provider instanceof Envelope) {
                Object object;
                envelope = object = provider;
            } else {
                ConfigurationProvider cfgProvider = (ConfigurationProvider)ScriptBytecodeAdapter.castToType((Object)provider, ConfigurationProvider.class);
                Envelope envelope2 = cfgProvider.callController(request, json);
                envelope = envelope2;
            }
        }
        catch (ThreadDeath d) {
            throw (Throwable)d;
        }
        catch (Throwable e) {
            Throwable t = JsonCommandServlet.getDeepestException(e);
            String msg = t.getClass().getName();
            if (t.getMessage() != null) {
                String string;
                msg = string = StringGroovyMethods.plus((String)msg, (CharSequence)StringGroovyMethods.plus((String)" ", (CharSequence)t.getMessage()));
            }
            if (t instanceof IOException) {
                if (ScriptBytecodeAdapter.compareEqual((Object)"org.apache.catalina.connector.ClientAbortException", (Object)t.getClass().getName())) {
                    LOG.info("Client aborted connection while processing JSON request.");
                } else {
                    JsonCommandServlet.sendJsonResponse(request, response, new Envelope("error: Invalid JSON request made.", false));
                }
            } else if (t instanceof AccessControlException) {
                JsonCommandServlet.sendJsonResponse(request, response, new Envelope("error: Your session with our website appears to have ended.  Please log out and back in.", false));
            } else {
                JsonCommandServlet.sendJsonResponse(request, response, new Envelope(new GStringImpl(new Object[]{msg}, new String[]{"error: Communications issue between your computer and our website (", ")"}), false));
            }
            return;
        }
        if (!response.isCommitted()) {
            long start = System.nanoTime();
            JsonCommandServlet.sendJsonResponse(request, response, (Envelope)ScriptBytecodeAdapter.castToType((Object)envelope, Envelope.class));
            long end = System.nanoTime();
            if (end - start > (long)2000000000) {
                if (json.length() > 256) {
                    String string;
                    json = string = json.substring(0, 255);
                }
                LOG.info((CharSequence)new GStringImpl(new Object[]{json, NumberNumberDiv.div((Number)(end - start), (Number)1000000)}, new String[]{"Slow return response: ", " took ", " ms"}));
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void sendJsonResponse(HttpServletRequest request, HttpServletResponse response, Envelope envelope) {
        try {
            if (response.isCommitted()) {
                return;
            }
        }
        catch (ThreadDeath t) {
            throw (Throwable)t;
        }
        catch (Throwable t) {
            Throwable throwable;
            t = throwable = JsonCommandServlet.getDeepestException(t);
            String msg = t.getClass().getName();
            if (t.getMessage() != null) {
                String string;
                msg = string = StringGroovyMethods.plus((String)msg, (CharSequence)StringGroovyMethods.plus((String)" ", (CharSequence)t.getMessage()));
            }
            if (t instanceof IOException) {
                if (ScriptBytecodeAdapter.compareEqual((Object)"org.apache.catalina.connector.ClientAbortException", (Object)t.getClass().getName())) {
                    LOG.info("Client aborted connection while processing JSON request.");
                    return;
                }
                LOG.warn((CharSequence)new GStringImpl(new Object[]{msg}, new String[]{"IOException - sending response: ", ""}));
                return;
            }
            if (t instanceof AccessControlException) {
                LOG.warn((CharSequence)new GStringImpl(new Object[]{msg}, new String[]{"AccessControlException - sending response: ", ""}));
                return;
            }
            LOG.warn("An unexpected exception occurred sending JSON response to client", t);
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        {
            String json = JsonCommandServlet.buildResponse(request, response, envelope);
            JsonCommandServlet.writeResponse(request, response, json);
            return;
        }
    }

    private static void writeResponse(HttpServletRequest request, HttpServletResponse response, String json) throws IOException {
        ByteArrayOutputStream jsonBytes = new ByteArrayOutputStream();
        jsonBytes.write(json.getBytes("UTF-8"));
        if (LOG.isDebugEnabled()) {
            LOG.debug((CharSequence)new GStringImpl(new Object[]{StringUtilities.createUtf8String((byte[])jsonBytes.toByteArray())}, new String[]{"  return ", ""}));
        }
        String header = request.getHeader("Accept-Encoding");
        if (jsonBytes.size() > 512 && header != null && header.contains("gzip")) {
            ByteArrayOutputStream compressedBytes = new ByteArrayOutputStream(jsonBytes.size());
            IOUtilities.compressBytes((ByteArrayOutputStream)jsonBytes, (ByteArrayOutputStream)compressedBytes);
            if (compressedBytes.size() < jsonBytes.size()) {
                ByteArrayOutputStream byteArrayOutputStream;
                response.setHeader("Content-Encoding", "gzip");
                jsonBytes = byteArrayOutputStream = compressedBytes;
            }
        }
        int n = jsonBytes.size();
        response.setContentLength(n);
        BufferedOutputStream output = new BufferedOutputStream((OutputStream)response.getOutputStream());
        jsonBytes.writeTo(output);
        output.flush();
    }

    private static String buildResponse(HttpServletRequest request, HttpServletResponse response, Envelope envelope) {
        Boolean success = (Boolean)ScriptBytecodeAdapter.castToType((Object)request.getAttribute(ATTRIBUTE_STATUS), Boolean.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)success) && envelope.getData() == null) {
            Object object = request.getAttribute(ATTRIBUTE_FAIL_MESSAGE);
            envelope.setData(object);
        }
        String string = "application/json";
        response.setContentType(string);
        response.setHeader("Cache-Control", "private, no-cache, no-store");
        String retJson = JsonWriter.objectToJson((Object)new Object[]{envelope.getData()});
        StringBuilder s = new StringBuilder("{\"data\":");
        if (ScriptBytecodeAdapter.compareEqual((Object)"[]", (Object)retJson)) {
            s.append("null");
        } else {
            s.append(retJson.substring(1, retJson.length() - 1));
        }
        s.append(",\"status\":");
        if (!DefaultTypeTransformation.booleanUnbox((Object)success)) {
            s.append(false);
        } else {
            s.append(envelope.getStatus());
        }
        s.append("}");
        return s.toString();
    }

    public static Throwable getDeepestException(Throwable e) {
        while (e.getCause() != null) {
            Throwable throwable;
            e = throwable = e.getCause();
        }
        if (!(e instanceof AccessControlException || e instanceof IOException)) {
            LOG.warn("unexpected exception occurred: ", (Object)e);
        } else {
            String msg = e.getClass().getName();
            if (e.getMessage() != null) {
                String string;
                msg = string = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)msg, (CharSequence)" "), (CharSequence)e.getMessage());
            }
            LOG.warn((CharSequence)new GStringImpl(new Object[]{msg}, new String[]{"exception occurred: ", ""}));
        }
        return e;
    }

    public static /* synthetic */ void access$0(JsonCommandServlet $that, HttpServletRequest param0, HttpServletResponse param1) throws ServletException, IOException {
        $that.doDelete(param0, param1);
    }

    public static /* synthetic */ void access$1(JsonCommandServlet $that, HttpServletRequest param0, HttpServletResponse param1) throws ServletException, IOException {
        $that.doTrace(param0, param1);
    }

    public static /* synthetic */ void access$2(JsonCommandServlet $that, HttpServletRequest param0, HttpServletResponse param1) throws ServletException, IOException {
        $that.doOptions(param0, param1);
    }

    public static /* synthetic */ void access$3(JsonCommandServlet $that, HttpServletRequest param0, HttpServletResponse param1) throws ServletException, IOException {
        $that.doHead(param0, param1);
    }

    public static /* synthetic */ void access$4(JsonCommandServlet $that, HttpServletRequest param0, HttpServletResponse param1) throws ServletException, IOException {
        $that.doPut(param0, param1);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != JsonCommandServlet.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        ThreadLocal threadLocal = new ThreadLocal();
        servletRequest = threadLocal;
        ThreadLocal threadLocal2 = new ThreadLocal();
        servletResponse = threadLocal2;
        LOG = logger = LogManager.getLogger(JsonCommandServlet.class);
    }
}

