/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.servlet;

import com.cedarsoftware.servlet.AppCtx;
import com.cedarsoftware.servlet.ControllerClass;
import com.cedarsoftware.servlet.ControllerMethod;
import com.cedarsoftware.servlet.HttpResponseHandler;
import com.cedarsoftware.servlet.framework.driver.ServletCtxProvider;
import com.cedarsoftware.util.IOUtilities;
import com.cedarsoftware.util.ReflectionUtils;
import com.cedarsoftware.util.io.JsonReader;
import com.cedarsoftware.util.io.JsonWriter;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JsonCommandServlet
extends HttpServlet {
    private AppCtx appCtx;
    private static final Logger LOG = LogManager.getLogger(JsonCommandServlet.class);
    private static final Map<String, Method> methodMap = new ConcurrentHashMap<String, Method>();
    private static Pattern cmdUrlPattern = Pattern.compile("^/([^/]+)/([^/]+)(.*)$");
    public static final String ATTRIBUTE_STATUS = "status";
    public static final String ATTRIBUTE_FAIL_MESSAGE = "failMsg";
    public static final ThreadLocal<HttpServletRequest> servletRequest = new ThreadLocal();
    public static final ThreadLocal<HttpServletResponse> servletResponse = new ThreadLocal();

    public void init() {
        try {
            this.appCtx = ServletCtxProvider.getAppCtx(this.getServletContext());
        }
        catch (Exception e) {
            LOG.error("Error initializing app context", (Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute(ATTRIBUTE_STATUS, (Object)true);
        servletRequest.set(request);
        servletResponse.set(response);
        String json = request.getParameter("json");
        if (json == null || json.trim().length() < 1) {
            JsonCommandServlet.sendJsonResponse(request, response, new Object[]{"error: HTTP-GET had empty or no 'json' parameter.", false});
            JsonCommandServlet.removeThreadLocals();
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("GET RESTful JSON");
        }
        this.processJsonRequest(request, response, json);
        JsonCommandServlet.removeThreadLocals();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute(ATTRIBUTE_STATUS, (Object)true);
        servletRequest.set(request);
        servletResponse.set(response);
        if (request.getContentLength() < 1) {
            JsonCommandServlet.sendJsonResponse(request, response, new Object[]{"error: Call to server had incorrect Content-Length specified.", false});
            JsonCommandServlet.removeThreadLocals();
            return;
        }
        try {
            byte[] jsonBytes = new byte[request.getContentLength()];
            IOUtilities.transfer((InputStream)request.getInputStream(), (byte[])jsonBytes);
            String json = new String(jsonBytes, "UTF-8");
            if (LOG.isDebugEnabled()) {
                LOG.debug("POST RESTful JSON");
            }
            this.processJsonRequest(request, response, json);
        }
        catch (Exception exception) {
            JsonCommandServlet.sendJsonResponse(request, response, new Object[]{"error: Unable to read HTTP-POST JSON content.", false});
        }
        JsonCommandServlet.removeThreadLocals();
    }

    private static void removeThreadLocals() {
        servletRequest.remove();
        servletResponse.remove();
    }

    private void processJsonRequest(HttpServletRequest request, HttpServletResponse response, String json) {
        boolean methodHandledResponse;
        Object[] ret;
        try {
            ret = this.makeJsonCall(request, response, json);
            methodHandledResponse = (Boolean)ret[2];
        }
        catch (ThreadDeath d) {
            throw d;
        }
        catch (Throwable e) {
            Throwable t = JsonCommandServlet.getDeepestException(e);
            String msg = t.getClass().getName();
            if (t.getMessage() != null) {
                msg = String.valueOf(msg) + ' ' + t.getMessage();
            }
            if (t instanceof IOException) {
                if ("org.apache.catalina.connector.ClientAbortException".equals(t.getClass().getName())) {
                    LOG.info("Client aborted connection while processing JSON request.");
                } else {
                    JsonCommandServlet.sendJsonResponse(request, response, new Object[]{"error: Invalid JSON request made.", false});
                }
            } else if (t instanceof AccessControlException) {
                JsonCommandServlet.sendJsonResponse(request, response, new Object[]{"error: Your session with our website appears to have ended.  Please log out and back in.", false});
            } else {
                JsonCommandServlet.sendJsonResponse(request, response, new Object[]{"error: Communications issue between your computer and our website (" + msg + ')', false});
            }
            return;
        }
        if (!methodHandledResponse) {
            long start = System.nanoTime();
            JsonCommandServlet.sendJsonResponse(request, response, new Object[]{ret[0], ret[1]});
            long end = System.nanoTime();
            if (end - start > 2000000000L) {
                if (json.length() > 256) {
                    json = json.substring(0, 255);
                }
                LOG.info("Slow return response: " + json + " took " + (end - start) / 1000000L + " ms");
            }
        }
    }

    private Object[] makeJsonCall(HttpServletRequest request, HttpServletResponse response, String json) throws Exception {
        Object result;
        Object target;
        int argCount;
        Object jArgs;
        String pathInfo = request.getPathInfo();
        Matcher matcher = cmdUrlPattern.matcher(pathInfo);
        if (matcher.find() && matcher.groupCount() < 2) {
            String msg = "error: Invalid JSON request - /controller/method not specified: " + json;
            LOG.warn(msg);
            return new Object[]{msg, false, false};
        }
        String bean = matcher.group(1);
        String methodName = matcher.group(2);
        try {
            jArgs = JsonReader.jsonToJava((String)json);
        }
        catch (Exception e) {
            String errMsg = "error: unable to parse JSON argument list on call '" + bean + "." + methodName + "'";
            LOG.error(errMsg, (Throwable)e);
            return new Object[]{errMsg, false, false};
        }
        if (jArgs != null && !(jArgs instanceof Object[])) {
            return new Object[]{"error: Arguments must be either null or a JSON array", false};
        }
        Object[] args = (Object[])jArgs;
        int n = argCount = args == null ? 0 : args.length;
        if (LOG.isDebugEnabled()) {
            LOG.debug("  " + bean + '.' + methodName + '(' + json.substring(1, json.length() - 1) + ')');
        }
        try {
            target = this.appCtx.getBean(bean);
        }
        catch (Exception exception) {
            LOG.warn("Invalid JSON target: " + bean);
            return new Object[]{"error: Invalid target '" + bean + "'.", false, false};
        }
        Class<?> targetType = target.getClass();
        Annotation annotation = ReflectionUtils.getClassAnnotation(targetType, ControllerClass.class);
        if (annotation == null) {
            return new Object[]{"error: target '" + bean + "' is not marked as a ControllerClass.", false, false};
        }
        long start = System.nanoTime();
        boolean selfHandlingResponse = false;
        boolean status = true;
        try {
            Annotation a;
            String methodKey = String.valueOf(bean) + '.' + methodName + '.' + argCount;
            Method method = methodMap.get(methodKey);
            if (method == null) {
                ControllerMethod cm;
                method = JsonCommandServlet.getMethod(targetType, methodName, argCount);
                if (method == null) {
                    return new Object[]{"error: Method not found: " + methodKey, false, false};
                }
                a = ReflectionUtils.getMethodAnnotation((Method)method, ControllerMethod.class);
                if (a != null && "false".equalsIgnoreCase((cm = (ControllerMethod)a).allow())) {
                    return new Object[]{"error: Method '" + methodName + "' is not allowed to be called via HTTP Request.", false, false};
                }
                methodMap.put(methodKey, method);
            }
            selfHandlingResponse = (a = ReflectionUtils.getMethodAnnotation((Method)method, HttpResponseHandler.class)) != null;
            result = JsonCommandServlet.callMethod(method, target, args);
        }
        catch (ThreadDeath t) {
            throw t;
        }
        catch (Throwable t) {
            t = JsonCommandServlet.getDeepestException(t);
            String msg = t.getClass().getName();
            if (t.getMessage() != null) {
                msg = String.valueOf(msg) + ' ' + t.getMessage();
            }
            LOG.warn("An exception occurred calling '" + bean + '.' + methodName + "'", t);
            result = "error: '" + methodName + "' failed with the following error: " + msg;
            status = false;
        }
        long end = System.nanoTime();
        String api = String.valueOf(bean) + '.' + methodName + json;
        if (api.length() > 256) {
            api = api.substring(0, 255);
        }
        LOG.info(String.valueOf(api) + ' ' + (end - start) / 1000000L + " ms");
        return new Object[]{result, status, selfHandlingResponse};
    }

    private static void sendJsonResponse(HttpServletRequest request, HttpServletResponse response, Object[] o) {
        try {
            Boolean success = (Boolean)request.getAttribute(ATTRIBUTE_STATUS);
            if (!success.booleanValue()) {
                o[0] = request.getAttribute(ATTRIBUTE_FAIL_MESSAGE);
            }
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "private, no-cache, no-store");
            String retVal = JsonWriter.objectToJson((Object)new Object[]{o[0]});
            StringBuilder s = new StringBuilder("{\"data\":");
            if ("[]".equals(retVal)) {
                s.append("null");
            } else {
                s.append(retVal.substring(1, retVal.length() - 1));
            }
            retVal = null;
            s.append(",\"status\":");
            if (!success.booleanValue()) {
                s.append(false);
            } else {
                s.append(o[1]);
            }
            s.append('}');
            ByteArrayOutputStream jsonBytes = new ByteArrayOutputStream();
            jsonBytes.write(s.toString().getBytes("UTF-8"));
            s.setLength(0);
            s = null;
            if (LOG.isDebugEnabled()) {
                LOG.debug("  return " + new String(jsonBytes.toByteArray(), "UTF-8"));
            }
            String header = request.getHeader("Accept-Encoding");
            if (jsonBytes.size() > 512 && header != null && header.contains("gzip")) {
                ByteArrayOutputStream compressedBytes = new ByteArrayOutputStream(jsonBytes.size());
                IOUtilities.compressBytes((ByteArrayOutputStream)jsonBytes, (ByteArrayOutputStream)compressedBytes);
                if (compressedBytes.size() < jsonBytes.size()) {
                    response.setHeader("Content-Encoding", "gzip");
                    jsonBytes = compressedBytes;
                }
            }
            response.setContentLength(jsonBytes.size());
            BufferedOutputStream output = new BufferedOutputStream((OutputStream)response.getOutputStream());
            jsonBytes.writeTo(output);
            ((OutputStream)output).flush();
        }
        catch (ThreadDeath t) {
            throw t;
        }
        catch (Throwable t) {
            t = JsonCommandServlet.getDeepestException(t);
            String msg = t.getClass().getName();
            if (t.getMessage() != null) {
                msg = String.valueOf(msg) + ' ' + t.getMessage();
            }
            if (t instanceof IOException) {
                if ("org.apache.catalina.connector.ClientAbortException".equals(t.getClass().getName())) {
                    LOG.info("Client aborted connection while processing JSON request.");
                } else {
                    LOG.warn("IOException - sending response: " + msg);
                }
            }
            if (t instanceof AccessControlException) {
                LOG.warn("AccessControlException - sending response: " + msg);
            }
            LOG.warn("An unexpected exception occurred sending JSON response to client", t);
        }
    }

    private static Throwable getDeepestException(Throwable e) {
        while (e.getCause() != null) {
            e = e.getCause();
        }
        if (!(e instanceof AccessControlException) && !(e instanceof IOException)) {
            LOG.warn("unexpected exception occurred: ", e);
        } else {
            String msg = e.getClass().getName();
            if (e.getMessage() != null) {
                msg = String.valueOf(msg) + ' ' + e.getMessage();
            }
            LOG.warn("exception occurred: " + msg);
        }
        return e;
    }

    private static Method getMethod(Class c, String name, int argc) {
        Method[] methods;
        Method[] methodArray = methods = c.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (name.equals(method.getName()) && method.getParameterTypes().length == argc) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    private static Object callMethod(Method method, Object target, Object[] args) {
        try {
            return method.invoke(target, args);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
    }
}

