package com.cedarsoftware.servlet.framework.driver;

import com.cedarsoftware.servlet.AppCtx;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import javax.servlet.ServletContext;

/**
 * @author John DeRegnaucourt (jdereg@gmail.com)
 *         <br/>
 *         Copyright (c) Cedar Software LLC
 *         <br/><br/>
 *         Licensed under the Apache License, Version 2.0 (the "License");
 *         you may not use this file except in compliance with the License.
 *         You may obtain a copy of the License at
 *         <br/><br/>
 *         http://www.apache.org/licenses/LICENSE-2.0
 *         <br/><br/>
 *         Unless required by applicable law or agreed to in writing, software
 *         distributed under the License is distributed on an "AS IS" BASIS,
 *         WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *         See the License for the specific language governing permissions and
 *         limitations under the License.
 */
public class ServletCtxProvider
{
    public static AppCtx getAppCtx(final ServletContext servletContext)
    {
        final ApplicationContext appCtx = WebApplicationContextUtils.getWebApplicationContext(servletContext);

        return new AppCtx()
        {
            public Object getBean(String name)
            {
                return appCtx.getBean(name);
            }
        };
    }
}
