/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.examples.randomizedrunner;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.annotations.Repeat;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeaks;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.junit.Test;

public class Test010Lingering
extends RandomizedTest {
    @Test
    @ThreadLeaks(linger=2000)
    public void lingerForLeftOverThread() throws Exception {
        final CountDownLatch go = new CountDownLatch(1);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    go.countDown();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        t.start();
        go.await();
    }

    @Test
    @Repeat(iterations=10)
    public void executorLeak() throws Exception {
        int numThreads = 50;
        ExecutorService executor = Executors.newFixedThreadPool(numThreads);
        for (int i = 0; i < 2 * numThreads; ++i) {
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    RandomizedTest.sleep((long)10L);
                }
            });
        }
        executor.shutdown();
        executor.awaitTermination(1L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)executor.isShutdown());
        Assert.assertTrue((boolean)executor.isTerminated());
    }
}

