/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.event.publish;

import com.adobe.aio.event.publish.PublishService;
import com.adobe.aio.event.publish.model.CloudEvent;
import com.adobe.aio.util.WorkspaceUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.UUID;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishServiceTester {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String DATA_EVENT_ID_NODE = "data_event_id";
    private final PublishService publishService = PublishService.builder().workspace(WorkspaceUtil.getSystemWorkspaceBuilder().build()).url(WorkspaceUtil.getSystemProperty((String)"aio_publish_url")).build();

    public String publishCloudEvent(String providerId, String eventCode) {
        try {
            String eventId = UUID.randomUUID().toString();
            CloudEvent cloudEvent = this.publishService.publishCloudEvent(providerId, eventCode, eventId, PublishServiceTester.getEventDataNode(eventId));
            this.logger.info("Published CloudEvent: {}", (Object)cloudEvent);
            Assert.assertEquals((Object)eventId, (Object)cloudEvent.getId());
            Assert.assertEquals((Object)("urn:uuid:" + providerId), (Object)cloudEvent.getSource());
            Assert.assertEquals((Object)eventCode, (Object)cloudEvent.getType());
            Assert.assertEquals((Object)eventId, (Object)cloudEvent.getData().get(DATA_EVENT_ID_NODE).asText());
            Assert.assertEquals((Object)"1.0", (Object)cloudEvent.getSpecVersion());
            Assert.assertEquals((Object)"application/json", (Object)cloudEvent.getDataContentType());
            return eventId;
        }
        catch (JsonProcessingException e) {
            Assert.fail((String)("publishService.publishCloudEvent failed with " + e.getMessage()));
            return null;
        }
    }

    public String publishRawEvent(String providerId, String eventCode) {
        String eventId = UUID.randomUUID().toString();
        String rawEventPayload = PublishServiceTester.getEventDataNode(eventId);
        this.publishService.publishRawEvent(providerId, eventCode, rawEventPayload);
        this.logger.info("Published Raw Event: {}", (Object)rawEventPayload);
        return eventId;
    }

    public static String getEventDataNode(String eventId) {
        return "{\"data_event_id\" : \"" + eventId + "\"}";
    }
}

