/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.event.management;

import com.adobe.aio.event.management.RegistrationService;
import com.adobe.aio.event.management.model.EventsOfInterestInputModel;
import com.adobe.aio.event.management.model.Registration;
import com.adobe.aio.event.management.model.RegistrationCreateModel;
import com.adobe.aio.util.WorkspaceUtil;
import com.adobe.aio.workspace.Workspace;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.Set;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistrationServiceTester {
    public static final String TEST_DESCRIPTION = "Test description";
    public static final String DELIVERY_TYPE_JOURNAL = "journal";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Workspace workspace = WorkspaceUtil.getSystemWorkspaceBuilder().build();
    protected final RegistrationService registrationService = RegistrationService.builder().workspace(this.workspace).url(WorkspaceUtil.getSystemProperty((String)"aio_api_url")).build();

    public RegistrationService getRegistrationService() {
        return this.registrationService;
    }

    public static EventsOfInterestInputModel.Builder getTestEventsOfInterestBuilder(String providerId, String eventCode) {
        return EventsOfInterestInputModel.builder().eventCode(eventCode).providerId(providerId);
    }

    public Registration createJournalRegistration(String registrationName, String providerId, String eventCode) {
        return this.createRegistration((RegistrationCreateModel.Builder)((RegistrationCreateModel.Builder)((RegistrationCreateModel.Builder)((RegistrationCreateModel.Builder)RegistrationCreateModel.builder().name(registrationName)).description(TEST_DESCRIPTION)).deliveryType(DELIVERY_TYPE_JOURNAL)).addEventsOfInterests(RegistrationServiceTester.getTestEventsOfInterestBuilder(providerId, eventCode).build()));
    }

    public Registration createRegistration(RegistrationCreateModel.Builder registrationInputModelBuilder) {
        RegistrationCreateModel registrationInputModel = registrationInputModelBuilder.clientId(this.workspace.getApiKey()).build();
        Optional registration = this.registrationService.createRegistration(registrationInputModelBuilder);
        Assert.assertTrue((boolean)registration.isPresent());
        Registration registratinCreated = (Registration)registration.get();
        this.logger.info("Created AIO Event Registration: {}", registration.get());
        String registrationId = registratinCreated.getRegistrationId();
        Assert.assertNotNull((Object)registrationId);
        Assert.assertEquals((Object)registrationInputModel.getDescription(), (Object)registratinCreated.getDescription());
        Assert.assertEquals((Object)registrationInputModel.getName(), (Object)registratinCreated.getName());
        Assert.assertEquals((Object)registrationInputModel.getDeliveryType(), (Object)registratinCreated.getDeliveryType());
        Set eventsOfInterestSet = ((Registration)registration.get()).getEventsOfInterests();
        Assert.assertEquals((long)registrationInputModel.getEventsOfInterests().size(), (long)eventsOfInterestSet.size());
        for (EventsOfInterestInputModel eventsOfInterestInput : registrationInputModel.getEventsOfInterests()) {
            Assert.assertTrue((boolean)eventsOfInterestSet.stream().anyMatch(eventsOfInterest -> eventsOfInterest.getEventCode().equals(eventsOfInterestInput.getEventCode())));
        }
        Assert.assertEquals((Object)"verified", (Object)registratinCreated.getWebhookStatus());
        Assert.assertEquals((Object)true, (Object)registratinCreated.isEnabled());
        Assert.assertNull((Object)((Registration)registration.get()).getWebhookUrl());
        RegistrationServiceTester.assertUrl(((Registration)registration.get()).getJournalUrl().getHref());
        RegistrationServiceTester.assertUrl(((Registration)registration.get()).getTraceUrl().getHref());
        Assert.assertNotNull((Object)((Registration)registration.get()).getCreatedDate());
        Assert.assertNotNull((Object)((Registration)registration.get()).getUpdatedDate());
        Assert.assertEquals((Object)((Registration)registration.get()).getUpdatedDate(), (Object)((Registration)registration.get()).getCreatedDate());
        return (Registration)registration.get();
    }

    public void deleteRegistration(String registrationId) {
        this.registrationService.delete(registrationId);
        Assert.assertFalse((boolean)this.registrationService.findById(registrationId).isPresent());
        this.logger.info("Deleted AIO Event Registration: {}", (Object)registrationId);
    }

    private static void assertUrl(String stringUrl) {
        try {
            Assert.assertNotNull((Object)stringUrl);
            URL uRL = new URL(stringUrl);
        }
        catch (MalformedURLException e) {
            Assert.fail((String)("invalid url due to " + e.getMessage()));
        }
    }
}

