/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.event.management;

import com.adobe.aio.event.management.ProviderService;
import com.adobe.aio.event.management.model.EventMetadata;
import com.adobe.aio.event.management.model.Provider;
import com.adobe.aio.event.management.model.ProviderInputModel;
import com.adobe.aio.util.WorkspaceUtil;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProviderServiceTester {
    public static final String DEFAULT_DESC_SUFFIX = " description";
    public static final String DEFAULT_PROVIDER_DOCS_URL = "https://github.com/adobe/aio-lib-java";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final ProviderService providerService = ProviderService.builder().workspace(WorkspaceUtil.getSystemWorkspaceBuilder().build()).url(WorkspaceUtil.getSystemProperty((String)"aio_api_url")).build();

    public static EventMetadata.Builder getTestEventMetadataBuilder(String eventCode) {
        return EventMetadata.builder().eventCode(eventCode).description(eventCode + DEFAULT_DESC_SUFFIX);
    }

    public static ProviderInputModel.Builder getTestProviderInputModelBuilder(String label) {
        return ProviderInputModel.builder().label(label).description(label + DEFAULT_DESC_SUFFIX).docsUrl(DEFAULT_PROVIDER_DOCS_URL);
    }

    public ProviderService getProviderService() {
        return this.providerService;
    }

    public Provider createOrUpdateProvider(String providerLabel, String eventCode) {
        return this.createOrUpdateProvider(ProviderServiceTester.getTestProviderInputModelBuilder(providerLabel).build(), Collections.singleton(ProviderServiceTester.getTestEventMetadataBuilder(eventCode).build()));
    }

    public Provider createOrUpdateProvider(ProviderInputModel providerInputModel, Set<EventMetadata> eventMetadataSet) {
        return this.assertProviderResponseAndCreateEventMetadata(providerInputModel, eventMetadataSet, () -> this.providerService.createOrUpdateProvider(providerInputModel));
    }

    public Provider createProvider(ProviderInputModel providerInputModel, Set<EventMetadata> eventMetadataSet) {
        return this.assertProviderResponseAndCreateEventMetadata(providerInputModel, eventMetadataSet, () -> this.providerService.createProvider(providerInputModel));
    }

    private Provider assertProviderResponseAndCreateEventMetadata(ProviderInputModel providerInputModel, Set<EventMetadata> eventMetadataSet, Supplier<Optional<Provider>> providerSupplier) {
        Optional<Provider> provider = providerSupplier.get();
        Assert.assertTrue((boolean)provider.isPresent());
        this.logger.info("Created AIO Events Provider: {}", provider);
        String providerId = provider.get().getId();
        Assert.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)providerId));
        Assert.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)provider.get().getInstanceId()));
        Assert.assertNotNull((Object)provider.get().getId());
        Assert.assertNotNull((Object)provider.get().getInstanceId());
        Assert.assertEquals((Object)providerInputModel.getLabel(), (Object)provider.get().getLabel());
        Assert.assertEquals((Object)providerInputModel.getDescription(), (Object)provider.get().getDescription());
        Assert.assertEquals((Object)providerInputModel.getDocsUrl(), (Object)provider.get().getDocsUrl());
        Assert.assertEquals((Object)WorkspaceUtil.getSystemProperty((String)"aio_ims_org_id"), (Object)provider.get().getPublisher());
        Assert.assertEquals((Object)("urn:uuid:" + provider.get().getId()), (Object)provider.get().getSource());
        Assert.assertEquals((Object)providerInputModel.getProviderMetadataId(), (Object)provider.get().getProviderMetadata());
        for (EventMetadata eventMetadataInput : eventMetadataSet) {
            Optional eventMetadata = this.providerService.createEventMetadata(providerId, eventMetadataInput);
            Assert.assertTrue((boolean)eventMetadata.isPresent());
            Assert.assertEquals((Object)eventMetadataInput.getEventCode(), (Object)((EventMetadata)eventMetadata.get()).getEventCode());
            Assert.assertEquals((Object)eventMetadataInput.getDescription(), (Object)((EventMetadata)eventMetadata.get()).getDescription());
            Assert.assertEquals((Object)eventMetadataInput.getLabel(), (Object)((EventMetadata)eventMetadata.get()).getLabel());
            this.logger.info("Added EventMetadata `{}` to AIO Events Provider `{}`", (Object)eventMetadata, (Object)providerId);
        }
        return provider.get();
    }

    public void deleteProvider(String providerId) {
        this.providerService.deleteProvider(providerId);
        this.logger.info("Deleted AIO Events Provider: {}", (Object)providerId);
        Optional deleted = this.providerService.findProviderById(providerId);
        Assert.assertFalse((boolean)deleted.isPresent());
        this.logger.info("No more AIO Events Provider with id: {}", (Object)providerId);
    }
}

