/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.event.journal;

import com.adobe.aio.event.journal.JournalService;
import com.adobe.aio.event.journal.model.Event;
import com.adobe.aio.event.journal.model.JournalEntry;
import com.adobe.aio.util.WorkspaceUtil;
import com.adobe.aio.workspace.Workspace;
import java.util.function.BiPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalServiceTester {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long JOURNAL_POLLING_TIME_OUT_IN_MILLISECONDS = 120000L;
    private static final String CLOUD_EVENT_ID_FIELD = "id";
    private static final String CLOUD_EVENT_DATA_FIELD = "data";
    public static final BiPredicate<Event, String> isEventIdInTheCloudEventData = (event, eventId) -> event.getEvent().has(CLOUD_EVENT_DATA_FIELD) && event.getEvent().get(CLOUD_EVENT_DATA_FIELD).has("data_event_id") && event.getEvent().get(CLOUD_EVENT_DATA_FIELD).get("data_event_id").asText().contains((CharSequence)eventId);
    public static final BiPredicate<Event, String> isEventIdTheCloudEventId = (event, eventId) -> event.getEvent().has(CLOUD_EVENT_ID_FIELD) && event.getEvent().get(CLOUD_EVENT_ID_FIELD).asText().equals(eventId);
    private final Workspace workspace = WorkspaceUtil.getSystemWorkspaceBuilder().build();

    public boolean pollJournalForEvent(String journalUrl, String eventId, BiPredicate<Event, String> isEventIdInEvent) throws InterruptedException {
        JournalService journalService = JournalService.builder().workspace(this.workspace).url(journalUrl).build();
        long pollingDuration = 0L;
        JournalEntry entry = journalService.getOldest();
        while (!this.isEventIdInJournalEntry(entry, eventId, isEventIdInEvent)) {
            if (entry.isEmpty()) {
                this.logger.info("Empty journal entry, we will retry-after {} seconds.", (Object)entry.getRetryAfterInSeconds());
                long sleeptime = (long)entry.getRetryAfterInSeconds() * 1000L;
                if ((pollingDuration += sleeptime) < 120000L) {
                    Thread.sleep(sleeptime);
                } else {
                    this.logger.error("We polled the journal for 120000 milliseconds and could NOT find the expected eventId.");
                    return false;
                }
            }
            entry = journalService.get(entry.getNextLink());
        }
        return true;
    }

    private boolean isEventIdInJournalEntry(JournalEntry entry, String eventId, BiPredicate<Event, String> isEventIdInEvent) {
        if (!entry.isEmpty()) {
            for (Event event : entry.getEvents()) {
                this.logger.debug("Journal Event {}: ", (Object)event);
                if (!isEventIdInEvent.test(event, eventId)) continue;
                this.logger.info("EventId {} found in a cloudEvent in this journal entry", (Object)eventId);
                return true;
            }
            this.logger.info("EventId {} not found in this journal entry: {}", (Object)eventId, (Object)entry);
        }
        return false;
    }
}

