/*
 * Copyright 2017 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package com.adobe.aio.event.journal.api;

import com.adobe.aio.event.journal.model.JournalEntry;
import feign.Headers;
import feign.Param;
import feign.RequestLine;

@Headers("Accept: application/vnd.adobecloud.events+json")
public interface JournalApi {

  @RequestLine("GET")
  @Headers({"x-ims-org-id: {imsOrgId}"})
  JournalEntry get(@Param("imsOrgId") String imsOrgId);

  @RequestLine("GET ?latest=true")
  @Headers({"x-ims-org-id: {imsOrgId}"})
  JournalEntry getLatest(@Param("imsOrgId") String imsOrgId);

  @RequestLine("GET ?since={position}")
  @Headers({"x-ims-org-id: {imsOrgId}"})
  JournalEntry getSince(@Param("imsOrgId") String imsOrgId, @Param("position") String position);

  @RequestLine("GET ?since={position}&limit={maxBatchSize}")
  @Headers({"x-ims-org-id: {imsOrgId}"})
  JournalEntry getSince(@Param("imsOrgId") String imsOrgId,
      @Param("position") String position, @Param("maxBatchSize") int maxBatchSize);

}
